<?php 
class Model_category_Controller extends Base_Controller{
	function __construct(){
		parent::__construct();
		$this->channel		=	new Model_Channel_Model();
		$this->category		=	new Model_Category_Model();
		$this->manager		=	new Model_Manager_Model();
		$this->createForm	=	new Model_Createform_Model();
		$this->modelhtml	=	new Model_html_Controller();
		$this->content		=	new Model_content_Model();
		$this->html			=	new Html_Model();
	}
	//分类列表
	function index($channel_id=false){
		$this->view			=	new View("category/list");
		$channelList			=	$this->channel->getchannellist();
		if(count($channelList)==0){
			$this->main->message		=	"请先添加站点";
			$this->main->message_type	=	"warning";
			die('请先添加站点');
		}
		if($channel_id===false){
			$channel			=	$channelList[0];
			$channel_id			=	$channel->channel_id;
		}
		else{
			$channel			=	$this->channel->getchannel($channel_id);
		}
		if($channel_id){
			$sortobject				=	$this->category->catList($channel->model_value,$channel_id)->result_array(false);
			$tree	=	new Tree($sortobject);
			$tree->set_array_colum(array("id"=>"cat_id","parent_id"=>"parentid","name"=>"cat_name"));
			$treeCat=	$tree->get_tree(0,"\$spacer\$cat_name");
			$catobjs	=	array();
			foreach($treeCat as $key=>$cat){
				$cat['url']	=	$this->html->url($channel_id,$cat['cat_id']);
				$catobjs[]	=	$cat;
			}
			$this->view->sortobj		=	$catobjs;
		}
		else{
			$htis->main->message_type	=	"error";
			$this->main->message		=	Kohana::lang('category_lang.error');
		}
		$this->view->model				=	$this->category;
		$this->view->channel_id			=	$channel_id;
		$this->view->channel_name		=	$channel->channel_name;
		$this->view->title				=	Kohana::lang("category_lang.sort_list")."-".$channel->channel_name;
		$this->view->dropdowncChannel	=	$this->channel->dropdowncChannel("channel_id",$channel_id,"onChange='button_location(\"".BASEURI."model_category/index/\"+this.value)'");
		$this->view->channel_name		=	$channel->channel_name;
		$this->view->model_id			=	$channel->model_id;
		$this->display();
	}
	//添加分类
	function add($channel_id=false){
		if($this->input->post()){
			$category	=	$this->input->post("cat");
			$channel_id	=	$category['channel_id'];
			$channel	=	$this->channel->getchannel($channel_id);
			$category['cat_create_date']	=	time();
			
			//检查是否填写了目录名称
			if(empty($category['cat_dir'])){
				$category['cat_dir']	=	zhpy::py($category['cat_name']);
			}
			//设置目录
			if($category['parentid']!=0){
				$parentCat				=	$this->category->get_category_id($channel->model_value,$category['parentid']);
				$category['cat_dir']	=	$parentCat->cat_dir."/".$category['cat_dir'];
			}
			else{
				$category['cat_dir']	=	$channel->channel_html_dir.$category['cat_dir'];
			}
			//检查目录
			$dir		=	path::uploadattachment();
			if(!file_exists($dir)){
				file::create_dir_path($dir,true);
			}
			
			//添加
			$category_Id=	$this->category->addCategory($channel->model_value,$category);
			$this->index($channel_id);
		}
		else{
			$this->view				=	new View("category/add");
			$channel				=	$this->channel->getchannel($channel_id);
			$this->view->title		=	"添加分类";
			$this->view->treeCategory	=	$this->category->dropdownCategory("cat[parentid]",$channel);
			$this->view->channel_id		=	$channel_id;
			if(!$form=$this->createForm->create($channel_id,"category")){
				$htis->view->message_type	=	"error";
				$this->view->message		=	Kohana::lang('category_lang.form_error');
			}
			$this->view->form				=	$form;
			$this->main->formAction			=	"model_category/add";
			$this->main->is_validator		=	true;
			$this->display();
		}
	}
	//编辑分类
	function edit($channel_id=false,$category_id=false){
		if($this->input->post()){
			$category	=	$this->input->post('cat');
			$channel_id	=	$category['channel_id'];
			$channel	=	$this->channel->getchannel($channel_id);
			//检查是否填写了目录名称
			if(empty($category['cat_dir'])){
				$category['cat_dir']	=	zhpy::py($category['cat_name']);
			}
			//设置目录
			if($category['parentid']!=0){
				$parentCat				=	$this->category->get_category_id($channel->model_value,$category['parentid']);
				$category['cat_dir']	=	$parentCat->cat_dir."/".$category['cat_dir'];
			}
			else{
				$category['cat_dir']	=	$channel->channel_html_dir.$category['cat_dir'];
			}
			$category['cat_create_date']	=	time();
			//检查目录
			$dir		=	path::uploadattachment();
			if(!file_exists($dir)){
				file::create_dir_path($dir,true);
			}
			
			//创建并设置目录
			//添加
			$category_Id				=	$this->category->updateCategory($channel->model_value,$category,$this->input->post('cat_id'));
			//更新HTML文件
			//1，更新首页
			$this->modelhtml->updateIndexHtml();
			//2，更新分类
			$this->modelhtml->updateCategoryHtml($channel_id,$this->input->post('cat_id'));
			$this->index($channel_id);
		}
		else{
			$this->view					=	new View("category/add");
			//取得站点分类数据
			$channel					=	$this->channel->getchannel($channel_id);
			$channel_data				=	$this->channel->getchannel($this->input->post('channel_id')?$this->input->post('channel_id'):$channel_id);
			$sortdata					=	$this->category->get_category_id($channel_data->model_value,$category_id);
			$sortdata->cat_dir			=	basename($sortdata->cat_dir);
			$this->view->cat			=	$sortdata;
			$this->view->title			=	"编辑分类";
			$this->main->formAction		=	"model_category/edit";
			$this->main->is_validator	=	true;
			$this->view->treeCategory	=	$this->category->dropdownParentCategory("cat[parentid]",$channel,$sortdata->cat_id,$sortdata->parentid);
			$this->view->channel_id		=	$channel_id;
			$this->view->form			=	$this->createForm->create($channel_id,"category",$sortdata);
			$this->display();
		}
	}
	/**
	 * 删除分类
	 */
	function delete($channel_id=false,$sort_id=false){

		if($this->input->post()){
			$channel_id	=	$this->input->post('channel_id');
			$id			=	$this->input->post('select_id');
		}
		else{
			$id[]		=	$sort_id;
		}
		$channel_data	=	$this->channel->getchannel($channel_id);
		//删除内容数
		$this->content->delete($channel_data->model_value,$channel_id,false,$id);
		//删除分类数据
		$this->category->delete($channel_data->model_value,$channel_id,$id);
		$this->index($channel_id);
	}
}