<?php
class Model_column_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->manager		=	new Model_Manager_Model();
		$this->column		=	new Model_Column_Model();
		$this->modelForm	=	new Model_Form_Model();
	}
	function table($model_id){
		//最得模型数据
		$modelobj					=	$this->manager->getModel($model_id);
		$this->view					=	new View("column/tablelist");
		$this->view->model			=	$modelobj;
		$this->view->model_id		=	$model_id;
		$this->display();
	}
	function manager($table_name="",$modelid){
		$this->db					=	new Database();
		$this->view					=	new View("column/manager");
		$this->view->columnlist		=	$this->column->analyseSql($table_name);
		$this->view->table_name		=	$table_name;
		$this->view->modelid		=	$modelid;
		$this->display();
	}
	function add($table_name=false,$modelid=false){
		if(@$this->input->post()){
			$this->db		=	new Database();
			$table_name		=	$this->input->post('table_name');
			$fields 		= 	$this->column->list_fields($table_name);
			$field_name		=	$this->input->post('field_name');
			$field_type		=	$this->input->post('field_type');
			$field_length	=	$this->input->post('field_length');
			$field_null		=	$this->input->post('field_null');
			$field_default	=	$this->input->post('field_default');
			$field_index	=	$this->input->post('field_index');
			$field_fulltext	=	$this->input->post('field_fulltext');
			$field_comments	=	$this->input->post('field_comments');
			$input			=	$this->input->post('input');
			$modelid		=	$this->input->post('modelid');
			$input['column_name']		=	$field_name;
			if(array_key_exists($field_name,$fields)){
				$this->view					=	new View("column/add");
				$this->main->message		=	"字段名称已经存在";
				$this->main->message_type	=	"warning";
				unset($_POST);
				$this->add($table_name,$modelid);
			}
			else{
				$addFiled	=	"ALTER TABLE `".DBFIX.$table_name."` ADD `$field_name` $field_type ";
				if($field_length){
					$addFiled.="($field_length) ";
				}
				$addFiled.="$field_null";
				if($field_default){
					$addFiled.=" default '$field_default'";
				}
				$addFiled.=" COMMENT '$field_comments'";
				$this->db->query($addFiled);
				if($field_index){
					$this->db->query("ALTER TABLE `".DBFIX.$table_name."` ADD INDEX ( `$field_name` )");
				}
				//添加到表单字段表
				$this->modelForm->addFormInput($input);
				$this->view->message	=	Kohana::lang("column_lang.add_column_success");
				$this->manager($table_name,$input['model_id']);
			}
		}
		else{
			if(strpos($table_name,"category")){
				$formtype	=	"cat";	
				$tabstring	=	"category";
			}
			if(strpos($table_name,"content")){
				$formtype	=	"con";	
				$tabstring	=	"content";
			}
			if(strpos($table_name,"annex")){
				$formtype	=	"con";
				$tabstring	=	"attachment";
			}
			$this->view					=	new View("column/add");
			$this->view->title			=	Kohana::lang("column_lang.addcolumn");
			$this->main->formAction		=	"model_column/add";
			$this->view->formtab		=	$this->modelForm->getFormTab($modelid,$formtype);
			$this->view->tabs			=	$this->view->formtab;
			$this->view->form_type		=	$formtype;
			$this->view->FiledType		=	$this->modelForm->getFiledType();
			$this->view->beforehand		=	$this->modelForm->getDefaultValueType();			
			$this->view->valids			=	Kohana::config("model.valids");
			$this->main->is_validator	=	true;
			$this->view->tabstring		=	$tabstring;
			$this->view->table_name		=	$table_name;
			$this->view->modelid		=	$modelid;
			$this->display();
		}
	}
	function edit($column_name=false,$tablename=false,$modelid=false){
		if(@$this->input->post()){
			$this->db		=	new Database();
			$table_name		=	$this->input->post('table_name');
			$fields 		= 	$this->column->getColumnList($table_name);
			$field_name		=	$this->input->post('field_name');
			$field_type		=	$this->input->post('field_type');
			$field_length	=	$this->input->post('field_length');
			$field_null		=	$this->input->post('field_null');
			$field_default	=	$this->input->post('field_default');
			$field_index	=	$this->input->post('field_index');
			$field_fulltext	=	$this->input->post('field_fulltext');
			$field_comments	=	$this->input->post('field_comments');
			$oldFiledName	=	$this->input->post('oldFiledName');
			$modelid		=	$this->input->post('modelid');

			if(array_key_exists($field_name,$fields)){
				$this->main->message	=	"字段名称已经存在";
				unset($_POST);
				$this->edit($oldFiledName,$table_name);
			}
			else{
				$addFiled	=	"ALTER TABLE `".DBFIX.$table_name."` CHANGE `$oldFiledName` `$field_name` $field_type ";
				if($field_length){
					$addFiled.="($field_length) ";
				}
				$addFiled.="$field_null";
				if($field_default!=''){
					$addFiled.=" default '$field_default'";
				}
				$addFiled.=" COMMENT '$field_comments'";
				$this->db->query($addFiled);
				if($field_index){
					$this->db->query("ALTER TABLE `".DBFIX.$table_name."` ADD INDEX ( `$field_name` )");
				}
				$this->view->message	=	Kohana::lang("column_lang.add_column_success");
				$this->manager($table_name,$modelid);
			}
		}
		else{
			$this->view						=	new View("column/edit");
			$this->view->title				=	"编辑";
			$this->view->table_name			=	$tablename;
			$this->view->fieldData			=	(object)$this->column->analyseSql($tablename,$column_name);
			$this->view->columnType			=	Kohana::config("model.columnType");
			$this->view->oldFiledName		=	$column_name;
			$this->view->modelid			=	$modelid;
			$this->main->formAction			=	"model_column/edit";
			$this->display();
		}
	}
	function delete($column_name=false,$tablename=false,$modelid){
		if($this->column->drop_column($tablename,$column_name)){
			$this->main->message	=	Kohana::lang("column_lang.delete_column_success");
			$this->main->message_type=	"success";
			$this->manager($tablename,$modelid);
		}
		else{
			$this->view->message		=	Kohana::lang("column_lang.delete_column_failed");
			$this->main->message_type	=	"error";
			$this->manager($tablename,$modelid);
		}
	}
}