<?php
class Model_form_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->modelForm	=	new Model_Form_Model();
		$this->column		=	new Model_Column_Model();
		$this->group		=	new Auth_Group_Model();
	}

	function tablecolumn($table_name=false){
		$this->view->columnlist		=	$this->db->list_fields($table_name);
		$this->view->tpl_path		=	$this->tpl_admin_path."model/form/columnlist";
		$this->view->title			=	$this->lang->line("columnmanager");
		$this->view->table_name=	$table_name;
		$this->load->vars($this->page);
		$this->load->view($this->tpl_path);
	}
	
	function index($table_name=false,$model_id=false){
		$this->view					=	new View("form/formlist");
		$this->view->model_id		=	$model_id;
		$this->view->formlist		=	$this->modelForm->getTableForm($table_name)->result_array();
		$this->view->title			=	Kohana::lang("column_lang.columnmanager");
		$this->view->table_name		=	$table_name;
		$this->display();
	}
	
	function edit($modelid=0,$formtype=0){
		if(@!$this->input->post()){
			$this->view					=	new View("form/editform");
			$this->view->title			=	"编辑表单";
			$this->view->modelid		=	$modelid;
			$this->view->role			=	$this->group->grouplist()->result_array(false);
			//取得所有input字段
			$inputColumn				=	$this->modelForm->getFormFiled($modelid,$formtype);
			$this->view->columnform		=	$inputColumn?$inputColumn:array();
			$this->view->FiledType		=	$this->modelForm->getFiledType();
			$this->view->beforehand		=	$this->modelForm->getDefaultValueType();
			$this->view->formtab		=	$this->modelForm->getFormTab($modelid,$formtype);
			$this->view->tabs			=	$this->view->formtab;
			$this->view->form_type		=	$formtype;
			$this->view->valids			=	Kohana::config("model.valids");
			$this->main->is_validator	=	true;
			$this->main->formAction		=	"model_form/edit";
			$this->display();
		}
		else{
			$inputid			=	$this->input->post('inputid');
			$modelid			=	$this->input->post('modelid');
			$input_title		=	$this->input->post('input_title');
			$input_status		=	$this->input->post('input_status');
			$input_type			=	$this->input->post('input_type');
			$beforehand			=	$this->input->post('beforehand');
			$input_description	=	$this->input->post('input_description');
			$input_lenght		=	$this->input->post('input_lenght');
			$vlidata			=	$this->input->post('vlidata');
			$input_order		=	$this->input->post('input_order');
			$error_msg			=	$this->input->post('error_msg');
			$tabid				=	$this->input->post('tabid');
			for($i=0;$i<count($inputid);$i++){
				$updateInput	=	array(
					"input_title"	=>	$input_title[$i],						  
					"input_status"	=>	$input_status[$i],						  
					"input_description"	=>	$input_description[$i],						  
					"input_lenght"		=>	$input_lenght[$i],						  
					"vlidata"			=>	$vlidata[$i],						  
					"input_order"		=>	$input_order[$i],						  
					"error_msg"			=>	$error_msg[$i],						  
					"tabid"				=>	$tabid[$i],						  
				);
				$this->modelForm->updateInput($updateInput,array("input_id"=>$inputid[$i],"model_id"=>$modelid));
			}
			url::redirect(BASEURI."model_manager/index");
		}
	}
	function del_input_field($inputid,$modelid,$type){
		$this->modelForm->delInputField($inputid);
		$this->edit($modelid,$type);
	}
	function tab(){
		$ids		=	$this->input->post("tabids");
		$names		=	$this->input->post("name");
		$tabnames	=	$this->input->post("tabnames");
		$orders		=	$this->input->post("orders");
		for($i=0;$i<count($tabnames);$i++){
			$this->modelForm->upTab(array("name"=>$tabnames[$i],"order"=>$orders[$i]),$ids[$i]);
		}
		$modelid=	$this->input->post("modelid");
		$formtype=	$this->input->post('formtype');
		foreach($names as $name){
			if($name!='')	$this->modelForm->addTab(array("form_type"=>$formtype,"model_id"=>$modelid,"name"=>$name));
		}
		url::redirect(BASEURI."model_form/edit/$modelid/$formtype");
	}
	
	function tabdel(){
		$ids	=	$this->input->post("select_id");
		$this->modelForm->delTab($ids);
		$modelid=	$this->input->post("modelid");
		$formtype=	$this->input->post('formtype');
		url::redirect(BASEURI."model_form/edit/$modelid/$formtype");
	}
	
	function edit_input_field($inputid=0,$modelid=0,$type=0){
		if($this->input->post()){
			$inputid	=	$this->input->post("inputid");
			$input		=	$this->input->post("input");
			$modelid	=	$this->input->post("modelid");
			$type		=	$this->input->post("formtype");
			$this->modelForm->updateInput($input,array("input_id"=>$inputid));
			$this->main->message="修改表单字段成功";
			$this->main->message_type="sccusse";
			unset($_POST);
			$this->edit($modelid,$type);
		}
		else{
			$this->view		=	new View("form/editinput");
			$this->view->input=	$this->modelForm->getInput($inputid);
			$this->view->FiledType		=	$this->modelForm->getFiledType();
			$this->view->beforehand		=	$this->modelForm->getDefaultValueType();
			$this->view->valids			=	Kohana::config("model.valids");
			$this->view->tabs			=	$this->modelForm->getFormTab($modelid,$type);
			$this->main->is_validator	=	true;
			$this->main->formAction		=	"model_form/edit_input_field";
			$this->view->modelid=$modelid;
			$this->view->form_type=$type;
			$this->display();
		}
	}
}


