<?php
class Model_manager_Controller extends Base_Controller{
	function __construct(){
		parent::__construct();
		$this->manager	=	new Model_Manager_Model();
		$this->form		=	new Model_Form_Model();
	}
	function index(){
		$this->view				=	new View("manager/list");
		$this->view->modelobj	=	$this->manager->getModelList();
		$this->display();		
	}
	function edit($modelid=false){
		if($this->input->post()){
			$modelid	=	$this->input->post("modelid");
			$model		=	$this->input->post("model");
			$this->manager->update($model,$modelid);
			$this->index();
		}
		else{
			$this->view	=	new View("manager/edit");
			$this->view->model	=	$this->manager->getModel($modelid);
			$this->main->formAction="model_manager/edit";
			$this->display();
		}
	}
	function add(){
		if(!$this->input->post()){
			$this->view	=	new View("manager/add");
			$this->main->is_validator	=	true;
			$this->main->formAction		=	"model_manager/add";
			$this->display();
		}
		else{
			$sql	=	"";
			$model				=	$this->input->post('model');
			$model_name			=	$model['model_name'];
			$model_value		=	$model['model_value'];
			//检查同名
			if($this->manager->valid_model($model_name,$model_value)){
				$this->main->message_type		=	"error";
				$this->main->message	=	Kohana::lang("manager_lang.model_error");
				$this->index();
				return false;
			}
			
			$sql				.=	file_get_contents("modules/model/controllers/content.sql");
			$sql				.=	file_get_contents("modules/model/controllers/category.sql");
			$sql				.=	file_get_contents("modules/model/controllers/annex.sql");
			//替换表名
			$findtable[]		=	"#DROP\s+TABLE\s+IF\s+EXISTS\s+`#i";
			$replacetable[]		=	"DROP TABLE IF EXISTS `".DBFIX.$model_value."_";
			$findtable[]		=	"#CREATE\s+TABLE\s+IF\s+NOT\s+EXISTS\s+`#i";
			$replacetable[]		=	"CREATE TABLE IF NOT EXISTS `".DBFIX.$model_value."_";
			$findtable[]		=	"#INSERT\s+INTO\s+`#i";
			$replacetable[]		=	"INSERT INTO `".DBFIX.$model_value."_";
			$runsql				= 	preg_replace($findtable,$replacetable,$sql);	
			if($this->manager->runquery($runsql)){
				$model['model_install_date']	=	date("Y-m-d H:i:s",time());
				$model['is_delete']				=	1;
				$model['model_article_table']	=	$model_value."_content";
				$model['model_category_table']	=	$model_value."_category";
				$model['model_annex_table']		=	$model_value."_annex";
				//新增模型并返回modelid
				$modelid	=	$this->manager->add_model($model);
				
				//建立模板默认表单
				//插入默认选项卡返回ID
				$modelInputSql	=	file_get_contents("modules/model/controllers/model_input.sql");
				$modelInputSql	=	str_replace("{suffix}",DBFIX,$modelInputSql);
				$formTabs		=	Kohana::config("formtab.formTab");
				foreach($formTabs as $key=>$tab){
					$tab['model_id']	=	$modelid;
					$tabid				=	$this->form->addTab($tab);
					$modelInputSql		=	str_replace("{".$key."}",$tabid,$modelInputSql);
				}
				$modelInputSql	=	str_replace("{modelid}",$modelid,$modelInputSql);
				$this->manager->runquery($modelInputSql);
				$this->main->message_type		=	"success";
				$this->main->message	=	Kohana::lang("manager_lang.add_model_success");
			}
			else{
				$this->main->message_type	=	"error";
				$this->main->message	=	Kohana::lang("manager_lang.add_model_faild");
			}
			$this->index();
		}
	}
	function delete($model_id){
		//取得模型数据
		$modelobj	=	$this->manager->getModel($model_id);
		//取得表单数据
		$modelForm	=	$this->form->getModelForm($model_id);
		if(count($modelForm)){
			foreach ($modelForm as $form){
				$formid[]	=	$form->form_id;
			}
			//删除表单及表单字段
			$this->form->delete($formid);
		}
		$model_value=	$modelobj->model_value;
		if(!empty($modelobj->model_article_table)){
			//删除文章表
			$this->manager->drop_table($modelobj->model_article_table);
		}
		if(!empty($modelobj->model_category_table)){
			//删除分类表
			$this->manager->drop_table($modelobj->model_category_table);
		}
		if(!empty($modelobj->model_assistant_table)){
			//删除副分类
			$this->manager->drop_table($modelobj->model_assistant_table);
		}
		if(!empty($modelobj->model_annex_table)){
			//删除附件表
			$this->manager->drop_table($modelobj->model_annex_table);
		}
		if($this->manager->delete_model($model_id)){
			$this->main->message_type		=	"success";
			$this->main->message	=	Kohana::lang("manager_lang.delete_model_success");
		}
		else{
			$this->main->message_type		=	"error";
			$this->main->message	=	Kohana::lang("manager_lang.delete_model_failed");
		}
		//删除模型表单数据
		$this->form->deleteModelInput($model_id);
		$this->form->deleteModelFormTab($model_id);
		$this->index();
	}
}