<?php 
class html_model extends Model{
	function html_model(){
		parent::Model();
		$this->table['sort_article']			=	"sort_article";
		$this->table['channel_sort']			=	"channel_sort";
		$this->table['article']					=	"article";
		$this->table['article_annex']			=	"article_annex";
		$this->table['annex']					=	"annex";
		$this->table['article_pageation']		=	"article_pageation";
		$this->table['model_article_attach']	=	"model_article_attach";
		$this->table['channel_article_attach']	=	"channel_article_attach";
		$this->table['sort_attach_article']		=	"sort_attach_article";
		$this->table['sort']					=	"sort";
		$this->table['article_attach']			=	"article_attach";		
		$this->table['article_attach_category']	=	"article_attach_category";		
	}
	/**
	 * 取得文章列表
	 *
	 * @param unknown_type $channel_id	频道ID
	 * @param unknown_type $sort_id		分类ID
	 * @param unknown_type $annex		是否查询附件
	 * @param unknown_type $start		开始位置
	 * @param unknown_type $showline	结束位置
	 * @param unknown_type $attach_category	是否有负分类
	 * @return unknown
	 */
	function article_list_2($channel_id=false,$sort_id=0,$annex=false,$start=false,$showline=30,$attach_category=false){
		
		if($sort_id!==false&&$channel_id!==false){
			
			$sortlist	=	$this->sort->get_channel_all_sort($channel_id);
			$sortlist	=	$this->public_model->category_select_id($sortlist,$sort_id,true,0);
			if(count($sortlist)>=1){
				foreach($sortlist as $tmp_id){
					$id[]		=	$tmp_id['sort_id'];
				}
				$this->db->where_in("sort.sort_id",$id);
			}
		}
		//选取字段
		$this->db->select("distinct article_pageation.article_id,min(article_pageation.article_pageation_id) as child_id,article_child_title,article_title,article_child_contents,article_description,sort.sort_id,sort.sort_name,article_publish_time");
		
		if($channel_id!==false){
			$this->db->join($this->table['channel_sort']." as channel_sort","channel_sort.channel_id=$channel_id");
			$this->db->where("channel_sort.sort_id=sort_article.sort_id");
		}
		$this->db->join($this->table['sort_article']." as sort_article","sort_article.article_id=article.article_id");
		if($sort_id!==false){
			$this->db->join($this->table['sort']." as sort","sort.sort_id=sort_article.sort_id");
		}
		$this->db->join($this->table['article_pageation']." as article_pageation","article_pageation.article_id=article.article_id");
		$this->db->groupby("article_pageation.article_id");
		
		//当副分类为真时
		if($attach_category!==false){
			$this->db->select("article_attach_category.article_attach_name,article_attach_category.article_attach_category");
			$this->db->join($this->table['article_attach']." as article_attach","article_attach.article_id=article.article_id","LEFT");
			$this->db->join($this->table['article_attach_category']." as article_attach_category","article_attach_category.article_attach_category=article_attach.attach_category_id","LEFT");
			$this->db->where("article_attach_category.article_attach_parent_id",$attach_category);
			$this->db->where("article_attach_category.channel_id",$channel_id);
			$this->db->orderby("article_attach_category.article_attach_name DESC");
		}
//		附件为真时
//		if($annex){
//			$this->db->select("annex.*");
//			$this->db->join($this->table['article_annex']." as article_annex","article_annex.article_id=article.article_id","left");
//			$this->db->join($this->table['annex']." as annex","annex.annex_id=article_annex.annex_id","left");
//			$this->db->where("(annex.annex_type=1 or annex.annex_type is null)");
//		}
		if($start!==false){
			$this->db->limit($showline,$start);
		}
		$this->db->orderby("article.article_order","DESC");
		$this->db->orderby("article.article_publish_time","DESC");
		return $this->db->get($this->table['article']." as article");
	}
	
	function article_list($select=array("channel_id"=>0,"model_value"=>false,"category_id"=>false,"page_no"=>0,"showline"=>20,"attach_category"=>false)){
		$model_value		=	$select['model_value'];
		$attach_category	=	$select['attach_category'];
		if($select['category_id']!==false&&$select['category_id']!=="false"){
			$sortlist			=	$this->category->get_channel_all_sort($model_value,$select['channel_id']);
			$sortlist			=	$this->public_model->category_select_id($sortlist,$select['category_id'],true,0);
			$this->db->select("category.*");
			$this->db->join($model_value."_category_article as category_article","category_article.article_id=article.article_id");
			$this->db->join($model_value."_channel_category as channel_category","channel_category.channel_id=".$select['channel_id']);
			$this->db->join($model_value."_category as category","category.category_id=channel_category.category_id");
			if(count($sortlist)>=1){
				foreach ($sortlist as $value){
					$category_id[]	=	$value['category_id'];
				}
				$this->db->where_in("channel_category.category_id",$category_id);
			}
		}
		else{
			$this->db->join($model_value."_channel_article as ch_ar","ch_ar.channel_id=$select[channel_id]");
			$this->db->where("ch_ar.article_id=article.article_id");
		}
		$this->db->select("distinct article_child.article_id,min(article_child.article_pageation_id) as child_id,article.*,article_child.*");
		//当副分类为真时
		if($attach_category!==false){
			$this->db->select("article_attach_category.article_attach_name,article_attach_category.article_attach_category");
			$this->db->join($model_value."_article_attach as article_attach","article_attach.article_id=article.article_id","LEFT");
			$this->db->join($model_value."_article_attach_category as article_attach_category","article_attach_category.article_attach_category=article_attach.attach_category_id","LEFT");
			$this->db->where("article_attach_category.article_attach_parent_id",$attach_category);
			$this->db->where("article_attach_category.channel_id",$select['channel_id']);
			$this->db->orderby("article_attach_category.article_attach_name DESC");
		}
		$this->db->from($model_value."_article as article");
		$this->db->join($model_value."_article_child as article_child","article_child.article_id=article.article_id");
		$this->db->orderby("article.article_order","DESC");
		$this->db->orderby("article.article_id","DESC");
		$this->db->groupby("article_child.article_id");
		if($select['page_no']>=0){
			$this->db->limit($select['showline'],$select['page_no']);
		}
		return $this->db->get();
	}
	function get_article_data($model_value,$article_id=false){
		$this->db->where("article_id",$article_id);
		$this->db->orderby("article_pageation_id ASC");
		return $this->db->get($model_value."_article_child");
	}
	function cut_str($str_cut,$length = 6){  
		$length*=2;
		if (strlen($str_cut) > $length){ 
		  for($i=0; $i < $length; $i++) 
		   if (ord($str_cut[$i]) > 128) $i++; 
		  $str_cut = substr($str_cut,0,$i) . "..."; 
		} 
		return $str_cut; 
	} 
	//取得副负类
	function get_article_attach($model_value,$attach_id=false){
		$this->db->where("article_attach_category",$attach_id);
		return $this->db->get($model_value."_article_attach_category as article_attach_category")->current();
	}
	//根据副负类ID查文章
	function attach_id_article($model_value,$attach_id=false,$is_category=false){
		$this->db->select("article_attach.*,article.*");
		$this->db->join($model_value."_article_attach as article_attach","article_attach.article_id=article.article_id");
		if($is_category){
			$this->db->select("category.*");
			$this->db->join($model_value."_category_article as cat_art","cat_art.article_id=article.article_id");
			$this->db->join($model_value."_category as category","category.category_id=cat_art.category_id");
		}
		$this->db->where("attach_category_id",$attach_id);
		return $this->db->get($model_value."_article as article")->result_array();
	}
}