<?php
class Model_Category_Model extends Model {
	function __construct(){
		parent::__construct();
	}
	
	/**
	 * 添加分类
	 *
	 * @param unknown_type $model_value
	 * @param unknown_type $category
	 * @return unknown
	 */
	function addCategory($model_value=false,$category){
		if($this->db->insert($model_value."_category",$category)){
			return $this->db->insert_id();
		}
		else{
			return false;
		}
	}
	/**
	 * 更新分类
	 *
	 * @param unknown_type $model_value
	 * @param unknown_type $category
	 * @param unknown_type $cat_id
	 * @return unknown
	 */
	function updateCategory($model_value=false,$category,$cat_id){
		$this->db->where("cat_id",$cat_id);
		if($this->db->update($model_value."_category",$category)){
			return true;
		}
		else{
			return false;
		}
	}
	/**
	 * 取得指定栏目ID的数据
	 *
	 * @param unknown_type $model
	 * @param unknown_type $cat_id
	 * @return unknown
	 */
	function get_category_id($model,$cat_id=0){
		return $this->db->where("cat_id",$cat_id)
		->get($model."_category")->current();
	}
	function delete($model,$channel_id,$cat_id=false){
		$category_Array	=	array();
		if($cat_id){
			//查询分类下面所有子分类
			foreach ($cat_id as $id){
				$sortlist		=	$this->getCatAllChild($model,$channel_id,$id);
				foreach ($sortlist as $value){
					$category_Array[]	=	$value->cat_id;
					file::delete_files($value->cat_dir);
				}
			}
			$this->db->in("cat_id",$category_Array);
		}
		$this->db->where("channel_id",$channel_id);
		return $this->db->delete($model."_category");
	}
	//取得频道所有栏目
	function catList($model,$channel_id){
		return $this->db->where("channel_id",$channel_id)
		->orderby("list_order","DESC")
		->get($model."_category");
	}
	//取得所有频道的分类
	function allCats($is_tree=true){
		$channels	=	$this->db->select("m.model_value,c.channel_id,c.channel_name")
		->from("channel as c")
		->join("model as m","m.model_id","c.model_id")
		->orderby("c.channel_order","DESC")
		->get()
		->result_array();
		foreach($channels as $ch){
			$cats	=	$this->catList($ch->model_value,$ch->channel_id)->result_array(false);
			if($is_tree){
				$istree	=	"\$spacer";
			}
			else{
				$istree	=	"";
			}
			$tree	=	new Tree($cats);
			$tree->set_array_colum(array("id"=>"cat_id","parent_id"=>"parentid","name"=>"cat_name"));
			$treeCats[$ch->channel_id]=	$tree->get_tree(0,"$istree\$cat_name");
		}
		return $treeCats;
	}
	function dropdownCategory($column,$channel,$select_id="",$attr=''){
		//取得频道所有分类
		$reobj	=	$this->db->select("*")
		->where("channel_id",$channel->channel_id)
		->orderby("list_order","DESC")
		->get($channel->model_value."_category")
		->result_array(false);
		$tree	=	new Tree($reobj);
		$tree->set_array_colum(array("id"=>"cat_id","parent_id"=>"parentid","name"=>"cat_name"));
		$treeCat=	$tree->get_tree(0,"\$spacer\$cat_name");
		$arrCat['']	=	"未选择";
		foreach($treeCat as $cat){
			$arrCat[$cat['cat_id']]	=	$cat['cat_name'];
		}
		return form::dropdown($column,$arrCat,$select_id,$attr);
	}
	//树分类 Return array();
	function TreeCatArray($column,$channel,$select_id="",$attr=''){
		//取得频道所有分类
		$reobj	=	$this->db->select("*")
		->where("channel_id",$channel->channel_id)
		->orderby("list_order","DESC")
		->get($channel->model_value."_category")
		->result_array(false);
		$tree	=	new Tree($reobj);
		$tree->set_array_colum(array("id"=>"cat_id","parent_id"=>"parentid","name"=>"cat_name"));
		$treeCat=	$tree->get_tree(0,"\$spacer\$cat_name");
		$arrCat['']	=	"未选择";
		foreach($treeCat as $cat){
			$arrCat[$cat['cat_id']]	=	$cat['cat_name'];
		}
		return $arrCat;
	}
	function dropdownParentCategory($column,$channel,$cat_id,$select_id=""){
		//取得频道所有分类
		$reobj	=	$this->getCatAllParent($channel->model_value,$channel->channel_id,$cat_id);
		$tree	=	new Tree($reobj);
		$tree->set_array_colum(array("id"=>"cat_id","parent_id"=>"parentid","name"=>"cat_name"));
		$treeCat=	$tree->get_tree(0,"\$spacer\$cat_name");
		$arrCat['0']	=	"请选择父分类";
		foreach($treeCat as $cat){
			$arrCat[$cat['cat_id']]	=	$cat['cat_name'];
		}
		return form::dropdown($column,$arrCat,$select_id);
	}
	function getCatAllChild($model,$channel_id,$cat_id=false){
		$channelAllCat	=	$this->catList($model,$channel_id)->result_array();
		foreach ($channelAllCat as $category){
			if(!@$selfCat){
				if($category->cat_id==$cat_id){
					$this->ResCat[]		=	$category;
					$selfCat		=	true;
				}
			}
		}
		$this->childCat($channelAllCat,$cat_id);
		$ResCat		=	$this->ResCat;
		unset($this->ResCat);
		return $ResCat;
	}
	function childCat($cat,$parent_id){
		foreach ($cat as $tmp){
			if($tmp->parentid==$parent_id){
				$this->ResCat[]	=	$tmp;
				$this->childCat($cat,$tmp->cat_id);
			}
		}
		if(count(@$this->ResCat)==0){
			$this->ResCat	=	array();
		}
		return $this->ResCat;
	}
	function getCatAllParent($model,$channel_id,$cat_id=false){
		$channelAllCat	=	$this->catList($model,$channel_id)->result_array();
		$child			=	$this->getCatAllChild($model,$channel_id,$cat_id);
		$category_Array	=	array();
		foreach ($child as $value){
			$category_Array[]	=	$value->cat_id;
		}
		foreach ($channelAllCat as $category){
			if(!in_array($category->cat_id,$category_Array)){
				$this->ResCat[]		=	(array)$category;
				$selfCat		=	true;
			}
		}
		@$ResCat		=	$this->ResCat;
		unset($this->ResCat);
		return @$ResCat;
	}
	function parentCat($cat,$cat_id){
		foreach ($cat as $tmp){
			if($tmp->parentid!=$cat_id){
				$this->ResCat[]	=	(array)$tmp;
			}
		}
		return @$this->ResCat;
	}
}