<?php
class Model_Channel_Model extends Model {
	function __construct(){
		parent::__construct();
		$this->table['channel']		=	"channel";
		$this->table['sort']		=	"sort";
		$this->table['ch_sort']		=	"channel_sort";
		$this->table['role_sort']	=	"role_sort";
		$this->table['model']		=	"model";
	}
	//检查频道名称
	function check_channel_name($channel_name,$channel_id=false){
		$this->db->where("channel_name",$channel_name);
		if($channel_id){
			$this->db->where("channel_id!=",$channel_id);
		}
		return $this->db->get($this->table['channel'])->count() ;
	}
	//检查频道目录
	function check_channel_dir($channel_dir){
		$this->db->where("channel_html_dir",$channel_dir);
		return $this->db->get($this->table['channel'])->count() ;
	}
	//创建频道
	function addchannel($insert){
		return $this->db->insert($this->table['channel'],$insert);
	}
	function getchannellist($model_value=false,$is_out_link=false){
		if($model_value!==false){
			$this->db->where("channel_type",$model_value);	
		}
		if($is_out_link!==false){
			$this->db->where("is_out_linke",0);	
		}
		$this->db->join("model","model.model_id","channel.model_id");
		$this->db->orderby("channel_order","DESC");
		return $this->db->get($this->table['channel']);
	}
	function dropdowncChannel($columnName,$selected="",$attr=""){
		$channelList	=	$this->getchannellist();
		foreach ($channelList as $channel){
			$selection[$channel->channel_id]	=	$channel->channel_name;
		}
		return form::dropdown($columnName,$selection,$selected,$attr);
	}
	function deletechannel($model_value,$channel_id,$is_category=false,$is_assistant=false,$is_annex=false){
		/**
		* 删除频道的所有数据
		*/
		$this->db->where("channel_id",$channel_id);
		return $this->db->delete($this->table['channel']);
	}
	function getchannel($channel_id){
		
		$this->db->where("c.channel_id",$channel_id);
		$this->db->join("model as m","m.model_id","c.model_id","left");
		return $this->db->get("channel as c")->current();
	}
	
	function updatechannel($update,$channel_id){
		$this->db->where("channel_id",$channel_id);
		return $this->db->update($this->table['channel'],$update);
	}
	function channel_type_get($channel_type){
		$this->db->where("channel_type",$channel_type);
		return $this->db->get($this->table['channel'])->result_array();
	}
	
}