<?php
class Model_Content_Model extends Model {
	function __construct(){
		parent::__construct();
		$this->category	=	new Model_Category_Model();

	}
	/**
	 * 添加文章
	 *
	 * @param unknown_type $insert
	 * @param unknown_type $sort_id
	 * @return unknown
	 */
	function addContent($model_vlaue="",$insert){
		if($this->db->insert($model_vlaue."_content",$insert)){
			//取得当前文章ID
			$content_id	=	$this->db->insert_id();
			return $content_id;
		}
		else{
			false;
		}
	}
	function updateContent($model_value,$content,$content_id){
		$this->db->where("content_id",$content_id);
		return $this->db->update($model_value."_content",$content);
	}
	function addAnnex($model_value,$annex=false){
		return $this->db->insert($model_value."_annex",$annex);
	}
	function updateAnnex($model_vlaue,$update,$annex_id){
		$this->db->where("annex_id",$annex_id);
		return $this->db->update($model_vlaue."_annex",$update);
	}
	/**
	 * Enter description here...
	 *
	 * @param unknown_type $select
	 * $select['channel_id'] 频道ID
	 * $select['sort_id'] 分类ID 可以是数组
	 * $select['page_no'] 页码
	 * $select['showlines'] 查询记录数
	 */
	function get_content_list($select=array("channel_id"=>0,"model_value"=>false,"category_id"=>false,"page"=>1,"showline"=>20,"keywords"=>false)){
		$model_value		=	$select['model_value'];
		if($select['category_id']>0){
			$sortlist			=	$this->category->getCatAllChild($model_value,$select['channel_id'],$select['category_id']);
			$this->db->select("cat.*");
			$this->db->join($model_value."_category as cat","cat.cat_id",'con.cat_id','LEFT');
			if(count($sortlist)>=1){
				foreach ($sortlist as $value){
					$category_id[]	=	$value->cat_id;
				}
				$this->db->in("cat.cat_id",$category_id);
			}
		}
		else{
			$this->db->select("cat.*");
			$this->db->join($model_value."_category as cat","cat.cat_id",'con.cat_id','LEFT');

		}
		$this->db->select("con.*,m.user_id,m.user_name");
		$this->db->from($model_value."_content as con");
		$this->db->where("con.channel_id",$select['channel_id']);
		if(@$select['keywords']){
			$this->db->like("con.title","%".$select['keywords']."%");
		}
		$this->db->join("member as m","m.user_id","con.memberid","left");
		$this->db->orderby('con.publish_date',"DESC");
		if($select['page']>=1){
			$this->db->limit($select['showline'],$select['showline']*$select['page']-$select['showline']);
		}
		return $this->db->get();
	}
	function htmlcontent($conlists){
		$cons		=	array();
		foreach($conlists as $reg){
			if(is_object($reg)){
				if(strpos($reg->tags,",")){
					$tags		=	explode(",",$reg->tags);
					$reg->tags	=	"";
					foreach ($tags as $value){
						$reg->tags	.=	"<a href='".BASEURI."search/index/".rawurlencode($value)."'>".$value."</a>";
					}
				}
				elseif($reg->tags!=''){
					$reg->tags	=	"<a href='".BASEURI."search/index/".rawurlencode($reg->tags)."'>".$reg->tags."</a>";
				}
				$reg->big_img	=	BASEURL.$reg->big_img;
				$reg->downurl	=	BASEURI."attachment/download/".$reg->channel_id."/".$reg->cat_id."/".$reg->content_id;
			}
			$cons[]				=	$reg;
		}
		return $cons;
	}
	function delete($model_value,$channel_id,$content_id=false,$ids=false){
		if(is_array($ids)){
			$cat	=	new Model_category_Model();
			foreach ($ids as $id){
				$sortlist		=	$cat->getCatAllChild($model_value,$channel_id,$id);
				foreach ($sortlist as $value){
					$catids[]	=	$value->cat_id;
				}
			}
			$this->db->in("cat_id",$catids);
			$result	=	$this->db->get("search_cache")->result_array();
			foreach($result as $con){
				$content_id[]	=	$con->content_id;
			}
			if(count($result)==0){
				$content_id[]	=	0;
			}
		}
		//删除搜索缓存
		if($content_id){
			$this->db->in("content_id",$content_id);
		}
		$this->db->where("channel_id",$channel_id)->delete("search_cache");
		//删除附件
		if($content_id){
			$this->db->in("content_id",$content_id);
		}
		
		$this->db->where("channel_id",$channel_id);
		$annexs	=	$this->db->get($model_value."_annex")->result_array();
		foreach($annexs as $annex){
			@unlink($annex->path);
			@unlink($annex->thumbs_path);
		}
		//delete the attachments
		if(is_array($content_id))	$this->db->in("content_id",$content_id);
		$this->db->where("channel_id",$channel_id)->delete($model_value."_annex");
		//delete content the thumb picture
		if(is_array($content_id))	$this->db->in("content_id",$content_id);
		$this->db->where("channel_id",$channel_id);
		$contents	=	$this->db->get($model_value."_content")->result_array();
		foreach($contents as $content){
			@unlink($content->thumb);
			@unlink($content->big_img);
		}
		//删除内容
		if($content_id){
			$this->db->in("content_id",$content_id);
		}
		return $this->db->where("channel_id",$channel_id)->delete($model_value."_content");
	}
	/**
	 * 取得提定文章ID的文章所有数据
	 *
	 * @param unknown_type $model_value
	 * @param unknown_type $content_id
	 * @return unknown
	 */
	function get_content_id($model_value,$content_id=false){
		$this->db->select("con.*,cat.cat_name,cat.cat_dir,cat.cat_id,cat.parentid");
		$this->db->where("con.content_id",$content_id);
		$this->db->join($model_value."_category as cat","cat.cat_id","con.cat_id","left");
		return $this->db->get($model_value.'_content as con')->current();
	}
	
	/**
	 * 取得内容附件
	 *
	 * @param unknown_type $model_value
	 * @param unknown_type $content_id
	 * @return unknown
	 */
	function getannexs($model_value,$content_id){
		$this->db->where('content_id',$content_id);
		return $this->db->get($model_value."_annex");
	}
	/**
	 * 删除附件
	 *
	 * @param unknown_type $model_value
	 * @param unknown_type $annex_id
	 * @return unknown
	 */
	function delete_annex($model_value,$annex_id){
		$this->db->where("annex_id",$annex_id);
		$annex	=	$this->db->get($model_value."_annex")->current();
		@unlink($annex->path);
		@unlink($annex->thumbs_path);
		return $this->db->where("annex_id",$annex_id)->delete($model_value."_annex");
	}
	/**
	 * 通过频道查询到文章
	 *
	 * @param unknown_type $model_value
	 * @param unknown_type $channel_id
	 * @param unknown_type $page_no
	 * @param unknown_type $showline
	 * @return unknown
	 */
	function channel_article_get($model_value,$channel_id,$page_no=false,$showline=30){
		$this->db->join($model_value."_channel_article as c_a","c_a.content_id=a.content_id");
		$this->db->where("c_a.channel_id",$channel_id);
		if($page_no){
			$this->db->limit($showline,$page_no);
		}
		$this->db->orderby("a.article_create_time DESC");
		return	$this->db->get($model_value."_article as a");
	}
	/**
	 * 删除与频道的关系
	 *
	 * @param unknown_type $model_value
	 * @param unknown_type $content_id
	 * @param unknown_type $channel_id
	 * @return unknown
	 */
	function delete_channel_article($model_value,$content_id,$channel_id){
		if($content_id){	$this->db->where_in("content_id",$content_id);		}
		else{	$this->db->where("channel_id",$channel_id);		}
		return $this->db->delete($model_value."_channel_article");
	}
	function searchCache($data){
		return $this->db->insert("search_cache",$data);
	}
	function updateSearchCache($data,$content_id){
		$this->db->where("content_id",$content_id);
		return $this->db->update("search_cache",$data);
	}
	function deleteSearch($channelid,$contentid=false){
		if($contentid)	$this->db->in("content_id",$contentid);
		$this->db->where("channel_id",$channelid);
		return $this->db->delete("search_cache");
	}
	function auditing($audit,$conid,$model){
		$this->db->in("content_id",$conid)->update("search_cache",array("status"=>$audit));
		$this->db->in("content_id",$conid)->update($model."_content",array("status"=>$audit));
	}
}
