<?php
class Model_Createform_Model extends Model {

	function __construct(){
		parent::__construct();
		$this->table['form_table']	=	"form_table";
		$this->table['input_form']	=	"model_input_form";
		$this->put_form				=	new Put_form();
		$this->channel				=	new Model_Channel_Model();
		$this->modelForm			=	new Model_Form_Model();
		$this->category				=	new Model_Category_Model();
		$this->defaultValue			=	new Default_Model();
	}

	//生成表单
	function create($channel_id=false,$action=false,$value=false){
		//取得频道数据
		$channel				=	$this->channel->getchannel($channel_id);
		@define("channel_id",$channel_id);
		@define("model_value",$channel->model_value);
		@define("MODELID",$channel->model_id);
		switch($action){
			case "category":
				//取得分类字段
				$columnList	=	$this->getFormFiled($channel->model_category_table,$channel->model_id,"cat","category");
				//取得选项卡
				$tabs		=	$this->modelForm->getFormTab($channel->model_id,"cat");
				//组合表单
				$inputs		=	$this->assemble($columnList,$value,$channel);
				//完成表单
				$form_html	=	$this->assginTab($inputs,$tabs,"cat");
			break;
			case "content":
				//取得内容字段
				$columnList	=	$this->getFormFiled($channel->model_category_table,$channel->model_id,"con","content");
				//组合表单
				$inputs		=	$this->assemble($columnList,$value,$channel);
				//取得选项卡
				$tabs		=	$this->modelForm->getFormTab($channel->model_id,"con");
				define("TABID",$tabs[count($tabs)-1]->tabid);
				define("SumTab",count($tabs));
				//完成表单
				$form_html	=	$this->assginTab($inputs,$tabs,"content");
			break;
			case "attachment":
				//取得表单字段
				$columnList	=	$this->getFormFiled($channel->model_category_table,$channel->model_id,"con","attachment");
				//组合表单
				$form_html	=	$this->assemble($columnList,$value,$channel);
			break;
			case "EditAttachment":
				//取得表单字段
				$columnList	=	$this->getFormFiled($channel->model_category_table,$channel->model_id,"con","attachment");
				//组合表单
				$form_html	=	array();
				$attachLists=	array();
				$i=0;
				foreach($value as $inputV){
					$attachFeild			=	$this->assemble($columnList,$inputV,$channel);
					$attachLists[$i]['input']	=	$attachFeild[TABID];
					$attachLists[$i]['name']	=	'
						<input type="hidden" name="oldannexs[annex_id][]" class="text" value="'.$inputV->annex_id.'" />
						<input type="hidden" name="oldannexs[path][]" class="text" value="'.$inputV->path.'" />
						<span id="name'.$inputV->annex_id.'">'.$inputV->name.'</span>&nbsp;&nbsp;
						<span id="newpath'.$inputV->annex_id.'">
						[<a href="javascript:void(0);" onclick="updateAnnex('.$inputV->annex_id.',true)">修改</a>]
						</span>
						&nbsp;&nbsp;
					';
					if($inputV->is_image){
						$attachLists[$i]['name'].='
						<span id="newthumb'.$inputV->annex_id.'" >
						[<a href="javascript:void();" onclick="updateAnnexthumb('.$inputV->annex_id.',true)">修改缩略图</a>]
						</span>&nbsp;&nbsp;
						<span><a thumb="'.BASEURL.$inputV->thumbs_path.'" href="'.BASEURL.$inputV->path.'" target="_blank" class="preview"><img src="'.BASEURL.$inputV->thumbs_path.'" height="50" border=0/></a></span>
						';
					}
					$attachLists[$i]['action']	=	"<a href='javascript:void(0)' onclick='deleteannex(\"annex".$inputV->annex_id."\",".$inputV->annex_id.",".$channel->channel_id.")'><IMG SRC='".BASEURL."public/admin/images/delete.png' border=0></a>";
					$attachLists[$i]['annexid']	=	$inputV->annex_id;
					$i++;
				}
				$form_html['attachLists']		=	$attachLists;
				$form_html['formFeild']			=	$this->assemble($columnList,false,$channel);
			break;
		}
		return $form_html;
	}

	//输入类型选择器
	function assemble($columnList=false,$value=false,$channel){
		$form=array();
		//取得所有预设值
		foreach ($columnList as $tmpFiled){
			//如果设置预设值
			$default_value		=	array();
			if($tmpFiled->beforehand!=''){
				if(in_array($tmpFiled->beforehand,array("category"))){
					if($tmpFiled->beforehand=="category"){
						$default_value	=	$this->category->TreeCatArray($tmpFiled->column_name,$channel);
					}
				}
				else{
					
					$defaults	=	$this->defaultValue->typeGet($tmpFiled->beforehand)->default_value;
					$defaults	=	explode("\n",$defaults);
					foreach($defaults as $d){
						if(strpos($d,"|")){
							list($key,$dfvalue)	=	explode("|",$d);
							$default_value[$key]=	$dfvalue;
						}
						else{
							$default_value[]	=	$d;
						}
					}
				}
			}
			if($value){
				$Filed			=	$tmpFiled->column_name;
				$inputValue		=	$value->$Filed;
			}
			else{
				$inputValue	=	$tmpFiled->default_value;
			}
			switch ($tmpFiled->input_type){
				case "text":		$form[$tmpFiled->tabid][]=$this->put_form->text($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght,$tmpFiled->style);
				break;
				case "tplText":		$form[$tmpFiled->tabid][]=$this->put_form->tplText($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
				break;
				case "radio":		$form[$tmpFiled->tabid][]=$this->put_form->radio($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$default_value,$tmpFiled->input_lenght);
				break;
				case "checkbox":	$form[$tmpFiled->tabid][]=$this->put_form->checkbox($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$default_value,$tmpFiled->input_lenght);
				break;
				case "singlePicture":	$form[$tmpFiled->tabid][]=$this->put_form->singlePicture($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
				break;
				case "annex":		$form[$tmpFiled->tabid][]=$this->put_form->singlePicture($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
				break;
				case "select":		$form[$tmpFiled->tabid][]=$this->put_form->select($tmpFiled->column_name,$tmpFiled->input_title,$default_value,$tmpFiled->input_description,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg);
				break;
				case "textarea":	$form[$tmpFiled->tabid][]=$this->put_form->textarea($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
				break;
				case "simpleEdit":  $form[$tmpFiled->tabid][]=$this->put_form->simpleEdit($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
				break;
				case "advancedEdit":  $form[$tmpFiled->tabid][]=$this->put_form->advancedEdit($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
				break;
				case "dateText": 	$form[$tmpFiled->tabid][]=$this->put_form->dateText($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
				break;
				case "multifile": 	$form[$tmpFiled->tabid][]=$this->put_form->multifile($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
				break;
				default:			$form[$tmpFiled->tabid][]=$this->put_form->text($tmpFiled->column_name,$tmpFiled->input_title,$inputValue,$tmpFiled->vlidata,$tmpFiled->error_msg,$tmpFiled->input_description,$inputValue,$tmpFiled->input_lenght);
			}
			
		}
		return $form;
	}

	//取得表单字段
	function getFormFiled($table_name=false,$modelid,$form_type,$next_type=false){
		if($next_type){		$this->db->where("tab",$next_type);		}
		return $this->db->where("form_type",$form_type)
						->where("model_id",$modelid)
						->orderby("input_order","DESC")
						->get($this->table['input_form'])
						->result_array();
	}
	/**
	*	$inputs	表单字段数组
	*	$tabs	表单选项卡
	**/
	function assginTab($inputs,$tabs,$formtype){
		$form	=	"<dl class='adminoption'>";
		$a		=	0;
		foreach($tabs as $tab){
			$a++;
			$form.="<dd ".($a==1?"class=\"active\"":"")."><a href='#tab$a'>$tab->name</a></dd>";
		}
		$form  .=	"</dl>";
		for($i=1;$i<=count($tabs);$i++){
			if(array_key_exists($tabs[$i-1]->tabid,$inputs)){
				$form	.=	"<div class='tab' id='tab$i'>
				<table class='adminform' cellspacing=0>";
				foreach($inputs[$tabs[$i-1]->tabid] as $input){
					$form	.=	"<tr><th colspan=2>".$input['title']."</th></tr>";
					$form	.=	"<tr><td width=50%>".$input['input']."</td><td>&nbsp;".$input['description']."</td></tr>";
				}
				$form	.=	"
				</table>
				</div>";
			}
		}
		$find		=	array();
		$replace	=	array();
		$find[]		=	"#\{form\}#i";
		$replace[]	=	$formtype;
		$find[]		=	"#\[\]#i";
		$replace[]	=	"";
		return preg_replace($find,$replace,$form);
	}

}