<?php
class Model_Form_Model extends Model {
	function __construct(){
		parent::__construct();
		$this->table['form_table']		=	"form_table";
		$this->table['user_group']		=	"user_group";
		$this->table['input_form']		=	"model_input_form";
	}
	function getTableForm($table_name){
		$this->db->where("form_table.table_name",$table_name);
		$this->db->join($this->table['user_group']." as group","group.group_id=","form_table.role_id");
		return $this->db->get($this->table['form_table']." as form_table");
	}
	/**
	 * 查询模型所有表
	 * @param unknown_type $model_id
	 * @return unknown
	 */
	function getModelForm($model_id){
		return $this->db->where("model_id",$model_id)
		->get("form_table")->result_array();
	}
	/**
	 * 查所有字段类型
	 *
	 * @return unknown
	 */
	function getFiledType(){
		return $this->db->get("model_column_type")->result_array();
	}
	/**
	 * 查企业家所有默认值
	 *
	 * @return unknown
	 */
	function getDefaultValueType(){
		return $this->db->get("model_defvaltype")->result_array();
	}
	
	function check_form_table($form_name,$table_name,$form_id){
		$this->db->where("form_name",$form_name);
		$this->db->where("table_name",$table_name);
		$this->db->where("form_id!=",$form_id);
		return $this->db->get($this->table['form_table'])->count();
	}
	
	function checkGroupForm($form_name,$table_name,$group_id){
		return $this->db->where(array("table_name"=>$table_name,"role_id"=>$group_id))
		->get($this->table['form_table'])->count();
	}
	
	function insert_form_table($data){
		if($this->db->insert($this->table['form_table'],$data)){
			return $this->db->insert_id();
		}
		else{
			return false;
		}
	}
	
	function insert_form_column($form_column){
		if($this->db->insert($this->table['input_form'],$form_column)){
			return true;
		}
		else{
			return false;
		}
	}
	function delete($form_id){
		if(!is_array($form_id)){
			$id[]	=	$form_id;
		}
		$result	=	$this->db->in("form_id",$id)
		->delete($this->table['form_table']);
		if($result){
			$this->db->in("form_id",$id);
			if($this->db->delete($this->table['input_form'])){
				return true;
			}
		}
		else{
			return false;
		}
	}
	
	//取得表单所有字段。
	function getFormFiled($modelid,$formtype){
		$this->db->where("model_id",$modelid);
		$this->db->where("form_type",$formtype);
		$this->db->orderby("input_order","DESC");
		return $this->db->get($this->table['input_form'])->result_array();
	}
	function updateInput($updateInput,$condition){
		return $this->db->where($condition)->update($this->table['input_form'],$updateInput);
	}
	function getFormTab($modelid,$type){
		$this->db->where("form_type",$type);
		$this->db->where("model_id",$modelid);
		$this->db->orderby("order","DESC");
		return $this->db->get("form_tab")->result_array();
	}
	function addTab($data){
		$this->db->insert("form_tab",$data);
		return $this->db->insert_id();
	}
	function delTab($condition){
		return $this->db->in("tabid",$condition)->delete("form_tab");
	}
	function delTabTM($condition){
		return $this->db->where($condition)->delete("form_tab");
	}
	function upTab($data,$tabid){
		return $this->db->where("tabid",$tabid)->update("form_tab",$data);
	}
	function delInputField($inputid){
		return $this->db->where("input_id",$inputid)->delete($this->table['input_form']);
	}
	function getInput($inputid){
		return $this->db->where("input_id",$inputid)->get($this->table['input_form'])->current();
	}
	function addFormInput($data){
		return $this->db->insert($this->table['input_form'],$data);
	}
	//删除模型表单所有字段
	function deleteModelInput($modelid){
		$this->db->where("model_id",$modelid);
		return $this->db->delete($this->table['input_form']);
	}
	//删除模型表单所有选项卡
	function deleteModelFormTab($modelid){
		$this->db->where("model_id",$modelid);
		return $this->db->delete("form_tab");
	}

}