<?php 
class Imgdemo_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->imgdemo		=	new Imgdemo_Model();
		$this->channel	=	new Model_Channel_Model();
	}

	function index($channel_id=false,$typeid=false){
		$channelList			=	$this->channel->getchannellist();
		if(count($channelList)==0){
			$this->main->message		=	"请先添加站点";
			$this->main->message_type	=	"warning";
			die('请先添加站点');
		}
		if($channel_id===false){
			$channel			=	$channelList[0];
			$channel_id			=	$channel->channel_id;
		}
		else{
			$channel			=	$this->channel->getchannel($channel_id);
		}
		$this->view				=	new View("imgdemo/list");
		$this->view->channel_id	=	$channel_id;
		$this->view->lists		=	$this->imgdemo->demolists($channel_id,$typeid);
		$this->view->dropdowncChannel	=	$this->channel->dropdowncChannel("channel_id",$channel_id,"onChange='button_location(\"".BASEURI."imgdemo/typelist/\"+this.value)'");
		$this->main->formAction		=	"imgdemo/addtype";
		$this->main->is_validator	=	true;
		$this->view->type_id		=	$typeid;
		$this->display();
	}
	function sliderlist($channel_id=false,$slider_type_id=false){
		if(!$channel_id) $this->My_error();
		//图片展示类型
		$slider_type				=	$this->slider->slider_type_list($channel_id,$slider_type_id)->row_object();
		$this->view->slider_type	=	$slider_type;
		$this->view->slider_list	=	$this->slider->get_slider($channel_id,false,$slider_type_id)->result_object();
		$this->view->tpl_path		=	$this->tpl_admin_path.'picture/slider/list';
		$this->view->title			=	$this->lang->line("slider")."-".$slider_type->slider_type_name;
		$this->view->channel_id		=	$channel_id;
		$this->load->vars($this->page);
		$this->load->view($this->tpl_path);
	}
	function delete($channel_id=false,$typdid=0,$demoid=0){
		if($this->input->post()){
			$id			=	$this->input->post('select_id');
			$channel_id	=	$this->input->post('channel_id');
		}
		else{
			$id[]	=	$demoid;
		}
		$this->imgdemo->deleteImgdemo($id);

		$this->index($channel_id,$typdid);
	}

	function add($channel_id=false,$type_id=false){
		if($this->input->post()){
			$demoimg		=	$this->input->post("demo");
			$demoimg['time']=	time();
			if(file_exists($demoimg['img_url'])){
				//检查目录
				$dir			=	path::uploadattachment();
				if(!file_exists($dir)){
					file::create_dir_path($dir,true);
				}
				$np	=	$dir."/".time().".".pathinfo($demoimg['img_url'],PATHINFO_EXTENSION);
				rename($demoimg['img_url'],$np);
				$demoimg['img_url']	=	$np;
			}
			$this->imgdemo->add($demoimg);
			$this->index($demoimg['channel_id'],$demoimg['type_id']);
		}
		else{
			$this->view						=	new View("imgdemo/add");
			$this->view->slider_type_list	=	$this->imgdemo->gettypes($channel_id)->result_array();
			$this->view->type_id			=	$type_id;
			$this->view->channel_id			=	$channel_id;
			$this->main->formAction			=	"imgdemo/add";
			$this->main->is_validator		=	true;
			$this->display();
		}
	}

	function edit($channel_id=false,$typeid=0,$demoid=0){
		if($this->input->post()){
			$demoid		=	$this->input->post("demo_id");
			$demo		=	$this->input->post("demo");
			//检查目录
			if(file_exists($demo['img_url'])){
				$dir			=	path::uploadattachment();
				if(!file_exists($dir)){
					file::create_dir_path($dir,true);
				}
				$np	=	$dir."/".time().".".pathinfo($demo['img_url'],PATHINFO_EXTENSION);
				rename($demo['img_url'],$np);
				$demo['img_url']	=	$np;
			}

			$this->imgdemo->updateImgdemo($demo,$demoid);
			$this->index($channel_id,$demo['type_id']);
		}
		else{
			$this->view		=	new View("imgdemo/add");
			$this->view->demo=	$this->imgdemo->demolists($channel_id,$typeid,$demoid)->current();
			$this->view->channel_id	=	$channel_id;
			$this->main->formAction	=	"imgdemo/edit";
			$this->view->type_id	=	$typeid;
			$this->main->is_validator	=	true;
			$this->display();
		}
	}

	function addtype(){
		if($this->input->post()){
			$type	=	$this->input->post("type");
			if(!$this->imgdemo->addtype($type)){

				$this->view->message_type		=	"notice";
				$this->view->message	=	$this->lang->line('add_slider_type_failed');
			}
			$this->typelist($type['channel_id']);
		}
	}

	function typelist($channel_id=false){
		$channelList			=	$this->channel->getchannellist();
		if(count($channelList)==0){
			$this->main->message		=	"请先添加站点";
			$this->main->message_type	=	"warning";
			die('请先添加站点');
		}
		if($channel_id===false){
			$channel			=	$channelList[0];
			$channel_id			=	$channel->channel_id;
		}
		else{
			$channel			=	$this->channel->getchannel($channel_id);
		}
		$this->view				=	new View("imgdemo/typelist");
		$this->view->channel_id	=	$channel_id;
		$this->view->types		=	$this->imgdemo->gettypes($channel_id);
		$this->view->dropdowncChannel	=	$this->channel->dropdowncChannel("channel_id",$channel_id,"onChange='button_location(\"".BASEURI."imgdemo/typelist/\"+this.value)'");
		$this->main->formAction	=	"imgdemo/addtype";
		$this->main->is_validator	=	true;
		$this->display();
	}

	function deltype($channel_id=false,$type_id=false){
		$id[]	=	$type_id;
		if($this->imgdemo->deleteType($id)){
			$this->view->message_type		=	"message";
			$this->view->message			=	"删除成功";
		}
		$this->typelist($channel_id);
	}
	function edittype($channel_id=false,$type_id=false){
		if($this->input->post()){
			$type	=	$this->input->post("type");
			$typeid	=	$this->input->post("typeid");
			$channel_id=	$this->input->post("channel_id");
			$this->imgdemo->upType($typeid,$type);
			unset($_POST);
			$this->typelist($channel_id);
		}
		else{
			$this->view			=	new View("imgdemo/edittype");
			$this->view->type	=	$this->imgdemo->gettypes($channel_id,$type_id)->current();
			$this->view->typeid	=	$type_id;
			$this->view->channel_id=$channel_id;
			$this->main->formAction="imgdemo/edittype";
			$this->display();
		}
	}
}