<?php 
class Note_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->notes	=	new Note_Model();
	}
	function index($page=1,$showlines=20){
		$notes	=	$this->notes->get(false,$page,$showlines)->result_array();
		$contents_sum	=	$this->notes->get(false,false,false)->count();
		$pagecfg['total_items']			=	$contents_sum;
		$pagecfg['current_page']		=	$page;
		$pagecfg['items_per_page']		=	$showlines;
		$pagecfg['base_url']			=	BASEURI."model_content/index";
		$this->pagination				=	new Pagination($pagecfg);
		$this->view	=	new View("note/list");
		$this->view->notes=$notes;
		$this->display();
	}
	function write_back($noteid=false){
		if($this->input->post()){
			$note			=	$this->input->post("note");
			$note['userid']	=	$_SESSION['adminmanager']->user_id;
			$noteid			=	$this->input->post("noteid");
			$this->notes->update($note,$noteid);
			$this->index();
		}
		else{
			$this->view	=	new View("note/edit");
			$this->main->formAction="note/write_back";
			$this->view->note=$this->notes->get($noteid)->current();
			$this->display();
		}
	}
	function delete($noteid=false){
		if($this->input->post()){
			$noteids	=	$this->input->post("select_id");
		}
		else{
			$noteids[]	=	$noteid;
		}
		$this->notes->delete($noteids);
		self::index();
	}
}