<?php 
class Pageweb_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->pageweb	=	new Pageweb_Model();
		file::create_dir_path("pageweb/");
	}
	function index(){
		$this->view	=	new View("pageweb/list");
		$this->view->pages	=	$this->pageweb->pages()->result_array();
		$this->display();
	}
	function add(){
		if($this->input->post()){
			$page				=	$this->input->post("page");
			$page['time']		=	time();
			$page['savepath']	=	"pageweb/".$page['filename'].SITE_HTML_SUFFIX;
			$this->pageweb->insert($page);
			$this->lmtpl->content	=(object)$page;
			$this->lmtpl->save($page['template'],$page['savepath']);
			unset($_POST);
			$this->index();
		}
		else{
			$this->view	=	new View("pageweb/add");
			$this->main->is_validator	=	true;
			$this->main->formAction		=	"pageweb/add";
			$this->display();
		}
	}
	function delete($pageid=0){
		if($this->input->post()){
			$pageids	=	$this->input->post("select_id");
		}
		else{
			$pageids[]	=	$pageid;
		}
		$this->pageweb->delete($pageid);
		unset($_POST);
		$this->index();
	}
	function edit($pageid=false){
		if($this->input->post()){
			$page	=	$this->input->post("page");
			$pageid	=	$this->input->post("pageid");
			$page['savepath']	=	"pageweb/".$page['filename'].SITE_HTML_SUFFIX;
			$this->pageweb->update($page,$pageid);
			$this->lmtpl->content	=(object)$page;
			$this->lmtpl->save($page['template'],$page['savepath']);
			unset($_POST);
			$this->index();
		}
		else{
			$this->view					=	new View("pageweb/add");
			$this->view->content		=	$this->pageweb->pages($pageid)->current();
			$this->main->is_validator	=	true;
			$this->main->formAction		=	"pageweb/edit";
			$this->display();
		}
	}
	
}