<?php 
class Cfg_Model extends Model{
	function __construct(){
		parent::__construct();
		$this->db	=	new Database();
	}
	/**
	 * 将全局变量插入数据库
	 *
	 * @param unknown_type $_global
	 */
	function insertGlobal($_global=array()){
		if(!$this->checkGlobalName($_global['global_name'])>=1){
			return $this->db->insert("global_cfg",$_global);
		}
		else{
			return false;
		}
	}
	/**
	 * 检查全局变量标识是否存在同名
	 *
	 * @param unknown_type $global_name
	 */
	function checkGlobalName($global_name=''){
		return $this->db->where("global_name",$global_name)->get("global_cfg")->count();
	}
	/**
	 * 删除系统配置
	 *
	 * @param unknown_type $gl_id
	 * @return unknown
	 */
	function deleteGlobal($gl_id=array()){
		return $this->db->in("global_cfg_id",$gl_id)->delete("global_cfg");
	}
	/**
	 * 更新系统配置
	 *
	 * @param array $update
	 * @param id $cfg_id
	 * @return boolean
	 */
	function updateGlobal($update,$cfg_id){
		if($this->checkGlobalName($update['global_name'])<=1){
			return $this->db->where("global_cfg_id",$cfg_id)->update("global_cfg",$update);
		}
		else{
			return false;
		}
	}
	/**
	 * 取得全局变量
	 *
	 * @param int $cfg_Id
	 * @return object
	 */
	function getGlobal($cfg_Id=false){
		if($cfg_Id!==false){
			$this->db->where('global_cfg_id',$cfg_Id);
		}
		return $this->db->get('global_cfg');
	}
	
	/**
	 * 取得系统配置
	 */
	function getBaseCfg(){
		return $this->db->get("basecfg")->current();
	}
	function updateBaseCfg($base){
		return $this->db->update("basecfg",$base);
	}
}