<?php
	require_once("includes/general.php");
	require_once("classes/FileSystems/LocalFileImpl.php");

	@set_time_limit(20*60); // 20 minutes execution time

	$orgWidth = getRequestParam("orgwidth");
	$orgHeight = getRequestParam("orgheight");
	$newWidth = getRequestParam("newwidth");
	$newHeight = getRequestParam("newheight");
	$left = getRequestParam("left");
	$top = getRequestParam("top");
	$action = getRequestParam("action");
	$path = getRequestParam("path");
	$orgpath = getRequestParam("orgpath", "");

	if ($orgpath == "")
		$orgpath = $path;

	$temp_image = "mcic_". session_id() ."";

	verifyAccess($mcImageManagerConfig);

	$rootpath = removeTrailingSlash(getRequestParam("rootpath", toUnixPath(getRealPath($mcImageManagerConfig, 'filesystem.rootpath'))));
	$fileFactory =& new FileFactory($mcImageManagerConfig, $rootPath);


	addFileEventListeners($fileFactory);

	$file =& $fileFactory->getFile($path);
	$config = $file->getConfig();
	$demo = checkBool($config['general.demo']) ? "true" : "false";
	$imageutils = new $config['thumbnail'];

	$tools = explode(',', $config['thumbnail.image_tools']);
	if (!in_array("edit", $tools))
		die("The thumbnail.image_tools needs to include edit.");

	// File info
	$fileInfo = getFileType($file->getAbsolutePath());
	$file_icon = $fileInfo['icon'];
	$file_type = $fileInfo['type'];
	$file_ext = $fileInfo['ext'];

	$tempFile =& $fileFactory->getFile(dirname($file->getAbsolutePath()) . "/" . $temp_image .".". $file_ext);
	$tempFile->setTriggerEvents(false);

	switch ($action) {
		case "resize":
			$status = $imageutils->resizeImage($file->getAbsolutePath(), $tempFile->getAbsolutePath(), $newWidth, $newHeight, $file_ext);
			if ($status)
				$tempFile->importFile();

			$outpath = $tempFile->getAbsolutePath();
			$outstatus = "processed";
		break;

		case "crop":
			$status = $imageutils->cropImage($file->getAbsolutePath(), $tempFile->getAbsolutePath(), $top, $left, $newWidth, $newHeight, $file_ext);
			if ($status)
				$tempFile->importFile();

			$outpath = $tempFile->getAbsolutePath();
			$outstatus = "processed";
		break;

		case "save":
			// Skip save on demo
			if ($demo == "true")
				break;

			$orgFile =& $fileFactory->getFile($orgpath);
			if ($orgFile->exists())
				$orgFile->delete();

			$file->setTriggerEvents(false);
			$file->renameTo($orgFile);
			$orgFile->importFile();
			$outpath = $orgFile->getAbsolutePath();
			$outstatus = "saved";
		break;

		default :
			die("No action");
	}

header("Location: edit_image.php?path=". $outpath ."&orgpath=". $orgpath ."&action=". $action ."&status=". $outstatus);
?>