<?php
	require_once("config.php");

	// Get rootpath
	$path = $mcImageManagerConfig['filesystem.path'];
	$path_exists = realpath($path);

	$path_canread = ($path_exists == "") ? false : canRead($path_exists);
	$path_canwrite = ($path_exists == "") ? false : canWrite($path_exists);

	$rootpath = $mcImageManagerConfig['filesystem.rootpath'];
	$rootpath_exists = realpath($rootpath);

	$rootpath_canread = ($rootpath_exists == "") ? false : canRead($rootpath_exists);
	$rootpath_canwrite = ($rootpath_exists == "") ? false : canWrite($rootpath_exists);

	$wwwroot = $mcImageManagerConfig['preview.wwwroot'];
	$wwwroot_exists = getWWWRoot($mcImageManagerConfig);
		
	$exif = $mcImageManagerConfig['thumbnail.use_exif'];
	$exif_exists = function_exists("exif_thumbnail");

	$gd_enabled = $mcImageManagerConfig['thumbnail.gd.enabled'];
	$gd_exists = function_exists("gd_info");

	$gd_version = "Undefined";

	if ($gd_exists) {
		$gd_info_data = gd_info();
		$gd_version = $gd_info_data['GD Version'];
		$gd_gif = $gd_info_data['GIF Create Support'];
	}

	$authenticator = $mcImageManagerConfig['authenticator'];
	$authenticator_exists = class_exists($authenticator);


	/**
	 * Returns the wwwroot or null string if it was impossible to get.
	 *
	 * @return String wwwroot or null string if it was impossible to get.
	 */
	function getWWWRoot($config) {
		if (isset($config['preview.wwwroot']) && $config['preview.wwwroot'])
			return realpath($config['preview.wwwroot']);
		
		// Check document root
		if (isset($_SERVER['DOCUMENT_ROOT'])) {
			if (ini_get("magic_quotes_gpc"))
				return stripslashes($_SERVER['DOCUMENT_ROOT']);
			else
				return $_SERVER['DOCUMENT_ROOT'];
		}

		// Try script file
		$path = str_replace(toUnixPath($_SERVER["SCRIPT_NAME"]), "", toUnixPath($_SERVER["SCRIPT_FILENAME"]));
		if (is_dir($path))
			return toOSPath($path);

		return null;
	}


	/**
	 * Converts a Unix path to OS specific path.
	 *
	 * @param String $path Unix path to convert.
	 */
	function toOSPath($path) {
		return str_replace("/", DIRECTORY_SEPARATOR, $path);
	}

	/**
	 * Converts a OS specific path to Unix path.
	 *
	 * @param String $path OS path to convert to Unix style.
	 */
	function toUnixPath($path) {
		return str_replace(DIRECTORY_SEPARATOR, "/", $path);
	}

	function checkBool($str) {
		if ($str === true)
			return true;

		if ($str === false)
			return false;

		$str = strtolower($str);

		if ($str == "true")
			return true;

		return false;
	}

	/**
	 * Check for the GD functions that are beeing used.
	 * @return Bool true or false depending on success or not.
	 */
	function gdCheck() {
		// just make a quick check, we dont need to loop if we can't find GD at all.
		if (!function_exists("gd_info"))
			return false;

		$gdUsedFunctions = array();
		$gdUsedFunctions[] = "ImagecreateFromJpeg";
		$gdUsedFunctions[] = "ImagecreateFromPng";
		$gdUsedFunctions[] = "ImagecreateFromGif";
		$gdUsedFunctions[] = "ImageJpeg";
		$gdUsedFunctions[] = "ImagePng";
		$gdUsedFunctions[] = "ImageGif";
		$gdUsedFunctions[] = "ImageCopyResized";
		$gdUsedFunctions[] = "ImageCreateTrueColor";
		$gdUsedFunctions[] = "ImageSX";
		$gdUsedFunctions[] = "ImageSY";

		foreach($gdUsedFunctions as $function) {
			if (!function_exists($function))
				return false;
		}

		return true;
	}

	/**
	 * Returns true if the files is readable.
	 *
	 * @return boolean true if the files is readable.
	 */
	function canRead($path) {
		return is_readable(toOSPath($path));
	}

	/**
	 * Returns true if the files is writable.
	 *
	 * @return boolean true if the files is writable.
	 */
	function canWrite($path) {
		// Is windows
		if (DIRECTORY_SEPARATOR == "\\") {
			$path = toOSPath($path);

			if (is_file($path)) {
				$fp = @fopen($path,'ab');

				if ($fp) {
					fclose($fp);
					return true;
				}
			} else if (is_dir($path)) {
				$tmpnam = time().md5(uniqid('iswritable'));
				if (@touch($path . '\\' . $tmpnam)) {
					unlink($path . '\\' . $tmpnam);
					return true;
				}
			}

			return false;
		}

		// Other OS:es
		return is_writeable(toOSPath($path));
	}

	function getPHPInfo($part = "") {
		ob_start();
		phpinfo($part);	
		$contents = ob_get_contents();

		// remove body etc
		$contents = str_replace("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"DTD/xhtml1-transitional.dtd\">", "", $contents);

		$contents = str_replace("<html><head>", "", $contents);
		$contents = str_replace("<title>phpinfo()</title></head>", "", $contents);
		$contents = str_replace("body {background-color: #ffffff; color: #000000;}", "", $contents);
		$contents = str_replace("a:link {color: #000099; text-decoration: none; background-color: #ffffff;}", "", $contents);
		$contents = str_replace("<body><div class=\"center\">", "", $contents);
		$contents = str_replace("</div></body></html>", "", $contents);

		ob_end_clean();
		return $contents;
	}

	$info_general = getPHPInfo(1);
	$info_configuration = getPHPInfo(4);
	$info_modules = getPHPInfo(8);
	$info_environment = getPHPInfo(16);
	$info_variables = getPHPInfo(32);
	$info_all = getPHPInfo(-1);

?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Status Check</title>
<style>

	body { background-color: #F0F0EE; margin: 10px; font-family: Verdana, Arial; font-size: 12px; }
	td { font-family: Verdana, Arial; font-size: 12px; }
	table { border-collapse: collapse; }
	legend { font-size: 14px; }
	.tdtitle { font-weight: bold; }
	.note { font-size: 10px; }
	.phpinfo { display: none; }
	a { background-color: #F0F0EE; }
</style>
<script language="Javascript">

	function elementToggle(element_id) {

		var elm = document.getElementById(element_id);
		if (elm.style.display == "block")
			elm.style.display = "none";
		else {
			elementHide();
			elm.style.display = "block";
		}
	}

	function elementHide() {
		elm = document.getElementById("phpinfoGeneral");
		elm.style.display = "none";

		elm = document.getElementById("phpinfoConfiguration");
		elm.style.display = "none";

		elm = document.getElementById("phpinfoModules");
		elm.style.display = "none";

		elm = document.getElementById("phpinfoEnvironment");
		elm.style.display = "none";

		elm = document.getElementById("phpinfoVariables");
		elm.style.display = "none";

		elm = document.getElementById("phpinfoAll");
		elm.style.display = "none";
	}
</script>
</head>
<body>
<fieldset style="width: auto;">
	<legend align="left"><strong>Basic Configuration Check</strong></legend>
	<table border="1" cellspacing="0" cellpadding="3">
		<tr>
			<td class="tdtitle">Name</td>
			<td>filesystem.path</td>
		</tr>
		<tr>
			<td class="tdtitle">Value</td>
			<td><?php echo  $path; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Resolved Value</td>
			<td><?php echo  $path_exists; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Readable</td>
			<td><?php echo  ($path_canread) ? "True" : "False (Check you what users/groups have read access to the folder)"; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Writeable</td>
			<td><?php echo  ($path_canwrite) ? "True" : "False (Check you what users/groups have write access to the folder)"; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Status</td>
			<?php echo  ($path_exists == "") ? "<td>The path could not be found, check you configuration.</td>" : "<td>OK</td>"; ?>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td class="tdtitle">Name</td>
			<td>filesystem.rootpath</td>
		</tr>
		<tr>
			<td class="tdtitle">Value</td>
			<td><?php echo  $rootpath; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Resolved Value</td>
			<td><?php echo  $rootpath_exists; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Readable</td>
			<td><?php echo  ($rootpath_canread) ? "True" : "False (Check you what users/groups have read access to the folder)"; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Writeable</td>
			<td><?php echo  ($rootpath_canwrite) ? "True" : "False (Check you what users/groups have write access to the folder)"; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Status</td>
			<?php echo  ($rootpath_exists == "") ? "<td>The rootpath could not be found, check you configuration.</td>" : "<td>OK</td>"; ?>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td class="tdtitle">Name</td>
			<td>preview.wwwroot</td>
		</tr>
		<tr>
			<td class="tdtitle">Value</td>
			<td><?php echo  $wwwroot; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Resolved Value</td>
			<td><?php echo  $wwwroot_exists; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Status</td>
			<?php echo  ($wwwroot_exists == "") ? "<td>The wwwroot path could not be verified, check you configuration.</td>" : "<td>OK</td>"; ?>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td class="tdtitle">Name</td>
			<td>thumbnail.use_exif</td>
		</tr>
		<tr>
			<td class="tdtitle">Value</td>
			<td><?php echo  $exif ? "True" : "False"; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">Status</td>
			<?php echo  (!$exif_exists) ? "<td>Can not use exif to extract thumbnails from Jpeg files, this is not a fatal error.</td>" : "<td>OK</td>"; ?>
		</tr>
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td class="tdtitle">Name</td>
			<td>thumbnail.gd.enabled</td>
		</tr>
		<tr>
			<td class="tdtitle">Value</td>
			<td><?php echo  $gd_enabled ? "True" : "False"; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">GD Exists</td>
			<td><?php echo  $gd_exists ? "True" : "False (Was not able to find all functions needed by the MCImageManager)"; ?></td>
		</tr>
		<tr>
			<td class="tdtitle">GD Version</td>
			<td><?php echo  $gd_version; ?> (2.0 or higher required)</td>
		</tr>
		<tr>
			<td class="tdtitle">GD GIF Support</td>
			<td><?php echo  $gd_gif ? "True" : "False"; ?> (required)</td>
			
		</tr>
		<tr>
			<td class="tdtitle">Status</td>
			<?php echo  (!gdCheck()) ? "<td>Unable to use GD, check your php.ini file if it is enabled.<br/>You might have the wrong version, try upgrading PHP.</td>" : "<td>OK</td>"; ?>
		</tr>
	</table>
	
</fieldset>
<br />
<a href="javascript:elementToggle('phpinfoAll');">PHPInfo</a>&nbsp;&nbsp;
<a href="javascript:elementToggle('phpinfoGeneral');">General</a>&nbsp;&nbsp;
<a href="javascript:elementToggle('phpinfoConfiguration');">Configuration</a>&nbsp;&nbsp;
<a href="javascript:elementToggle('phpinfoVariables');">Variables</a>&nbsp;&nbsp;
<a href="javascript:elementToggle('phpinfoModules');">Modules</a>&nbsp;&nbsp;
<a href="javascript:elementToggle('phpinfoEnvironment');">Environment</a><br /><br />
<div id="phpinfoAll" class="phpinfo">
<?php echo  $info_all; ?>
</div>

<div id="phpinfoGeneral" class="phpinfo">
<?php echo  $info_general; ?>
</div>

<div id="phpinfoVariables" class="phpinfo">
<?php echo  $info_variables; ?>
</div>

<div id="phpinfoConfiguration" class="phpinfo">
<?php echo  $info_configuration; ?>
</div>

<div id="phpinfoModules" class="phpinfo">
<?php echo  $info_modules; ?>
</div>

<div id="phpinfoEnvironment" class="phpinfo">
<?php echo  $info_environment; ?>
</div>


</body>
</html>