DROP TABLE IF EXISTS p8_fenlei_adminwork;
CREATE TABLE p8_fenlei_adminwork (
  aid mediumint(7) NOT NULL auto_increment,
  type varchar(30) NOT NULL default '',
  id mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  ifpm tinyint(1) NOT NULL default '0',
  fen smallint(4) NOT NULL default '0',
  reason text NOT NULL,
  posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (aid),
  KEY type (type),
  KEY id (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_area;
CREATE TABLE p8_fenlei_area (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  dirname varchar(150) NOT NULL default '',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_buyad;
CREATE TABLE p8_fenlei_buyad (
  aid mediumint(7) NOT NULL auto_increment,
  sortid mediumint(7) NOT NULL default '0',
  cityid mediumint(7) NOT NULL default '0',
  id int(10) NOT NULL default '0',
  mid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (aid),
  KEY sortid (sortid,money,endtime,cityid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_city;
CREATE TABLE p8_fenlei_city (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  hits mediumint(7) NOT NULL default '0',
  letter varchar(5) NOT NULL default '',
  domain varchar(150) NOT NULL default '',
  dirname varchar(50) NOT NULL default '',
  PRIMARY KEY  (fid),
  KEY fup (fup),
  KEY letter (letter),
  KEY list (list)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_collection;
CREATE TABLE p8_fenlei_collection (
  cid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (cid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_comments;
CREATE TABLE p8_fenlei_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id int(10) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  flowers smallint(4) NOT NULL default '0',
  egg smallint(4) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_config;
CREATE TABLE p8_fenlei_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content;
CREATE TABLE p8_fenlei_content (
  id int(10) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  mid smallint(4) NOT NULL default '0',
  spid mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  fid_bak1 mediumint(7) NOT NULL default '0',
  fid_bak2 mediumint(7) NOT NULL default '0',
  fid_bak3 mediumint(7) NOT NULL default '0',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list varchar(10) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  city_id mediumint(7) NOT NULL default '0',
  zone_id mediumint(7) NOT NULL default '0',
  street_id mediumint(7) NOT NULL default '0',
  editpwd varchar(32) NOT NULL default '',
  showday mediumint(4) NOT NULL default '0',
  visit_log text NOT NULL,
  visit_num mediumint(7) unsigned NOT NULL default '0',
  telephone varchar(30) NOT NULL default '',
  mobphone varchar(12) NOT NULL default '',
  email varchar(50) NOT NULL default '',
  oicq varchar(11) NOT NULL default '',
  msn varchar(50) NOT NULL default '',
  linkman varchar(20) NOT NULL default '',
  postcode varchar(6) NOT NULL default '',
  address varchar(250) NOT NULL default '',
  weburl varchar(150) NOT NULL default '',
  fax varchar(30) NOT NULL default '',
  maps varchar(50) NOT NULL default '',
  picnum smallint(4) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY fid (fid),
  KEY ispic (ispic),
  KEY city_id (city_id),
  KEY zone_id (zone_id),
  KEY street_id (street_id),
  KEY list (list,fid,city_id,yz),
  KEY hits (hits)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_1;
CREATE TABLE p8_fenlei_content_1 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  my_bus varchar(50) NOT NULL default '',
  my_station varchar(100) NOT NULL default '',
  my_rooms varchar(30) NOT NULL default '',
  my_price int(8) NOT NULL default '0',
  my_peitao varchar(150) NOT NULL default '',
  my_acreage varchar(12) NOT NULL default '',
  my_fitment varchar(15) NOT NULL default '',
  my_floor varchar(12) NOT NULL default '',
  sortid tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid),
  KEY sortid (sortid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_2;
CREATE TABLE p8_fenlei_content_2 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  sortid tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid),
  KEY sortid (sortid),
  KEY sortid_2 (sortid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_3;
CREATE TABLE p8_fenlei_content_3 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  my_jobs varchar(30) NOT NULL default '',
  my_nums varchar(12) NOT NULL default '',
  my_jobabout mediumtext NOT NULL,
  my_workplace varchar(30) NOT NULL default '',
  wage tinyint(1) NOT NULL default '0',
  sortid char(1) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid),
  KEY my_wage (wage),
  KEY wage (wage),
  KEY sortid (sortid),
  KEY sortid_2 (sortid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_4;
CREATE TABLE p8_fenlei_content_4 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  sortid tinyint(1) NOT NULL default '0',
  my_jobs varchar(30) NOT NULL default '',
  my_schoolage varchar(30) NOT NULL default '',
  my_sex varchar(4) NOT NULL default '',
  my_age varchar(8) NOT NULL default '',
  my_workplace varchar(50) NOT NULL default '',
  my_wage varchar(30) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid),
  KEY sortid (sortid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_5;
CREATE TABLE p8_fenlei_content_5 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  my_age varchar(8) NOT NULL default '',
  my_height varchar(8) NOT NULL default '',
  my_job varchar(30) NOT NULL default '',
  my_weight varchar(15) NOT NULL default '',
  my_interest varchar(100) NOT NULL default '',
  my_sex varchar(4) NOT NULL default '',
  sortid tinyint(1) NOT NULL default '0',
  schoo_age tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid),
  KEY sortid (sortid),
  KEY sortid_2 (sortid),
  KEY schoo_age (schoo_age),
  KEY schoo_age_2 (schoo_age)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_6;
CREATE TABLE p8_fenlei_content_6 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  my_price int(7) NOT NULL default '0',
  my_hownew varchar(12) NOT NULL default '',
  my_outprice int(10) NOT NULL default '0',
  sortid char(1) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid),
  KEY sortid (sortid),
  KEY sortid_2 (sortid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_7;
CREATE TABLE p8_fenlei_content_7 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  my_acreage varchar(12) NOT NULL default '',
  my_price int(10) NOT NULL default '0',
  my_fitment varchar(20) NOT NULL default '',
  my_floor varchar(5) NOT NULL default '',
  my_station varchar(50) NOT NULL default '',
  my_bus varchar(50) NOT NULL default '',
  sortid tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid),
  KEY sortid (sortid),
  KEY sortid_2 (sortid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_db;
CREATE TABLE p8_fenlei_db (
  id int(10) NOT NULL auto_increment,
  fid mediumint(7) NOT NULL default '0',
  city_id mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY fid (fid),
  KEY city_id (city_id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_module;
CREATE TABLE p8_fenlei_module (
  id smallint(4) NOT NULL auto_increment,
  sort_id mediumint(5) NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  list smallint(4) NOT NULL default '0',
  style varchar(50) NOT NULL default '',
  config text NOT NULL,
  config2 text NOT NULL,
  comment_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_module_sort;
CREATE TABLE p8_fenlei_module_sort (
  sort_id mediumint(5) NOT NULL auto_increment,
  sort_name varchar(30) NOT NULL default '',
  PRIMARY KEY  (sort_id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_report;
CREATE TABLE p8_fenlei_report (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  onlineip varchar(15) NOT NULL default '',
  type tinyint(2) NOT NULL default '0',
  content text NOT NULL,
  iftrue tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (rid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_sort;
CREATE TABLE p8_fenlei_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  mid smallint(4) NOT NULL default '0',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config mediumtext NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  contents mediumint(4) NOT NULL default '0',
  tableid varchar(30) NOT NULL default '',
  dir_name varchar(50) NOT NULL default '',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_street;
CREATE TABLE p8_fenlei_street (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  dirname varchar(150) NOT NULL default '',
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_zone;
CREATE TABLE p8_fenlei_zone (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  dirname varchar(150) NOT NULL default '',
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DELETE FROM `p8_label` WHERE module='1';




INSERT INTO `p8_fenlei_adminwork` VALUES ('1','unyz','255','1','111111','0','0','','1242032109');
INSERT INTO `p8_fenlei_adminwork` VALUES ('2','yz','255','1','111111','0','0','','1242032115');
INSERT INTO `p8_fenlei_adminwork` VALUES ('3','del','255','1','111111','0','0','','1242032132');
INSERT INTO `p8_fenlei_area` VALUES ('1','0','ֱϽ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('2','0','㶫','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('3','0','㽭','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('4','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('5','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('6','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('7','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('8','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('9','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('10','0','ӱ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('11','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('12','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('13','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('14','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('15','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('16','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('17','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('18','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('19','0','ɹ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('20','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('21','0','ຣ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('22','0','ɽ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('23','0','ɽ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('24','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('25','0','Ĵ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('26','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('27','0','½','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('28','0','','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_city` VALUES ('1','1','','0','0','0','','0','0','','','','','','','0','','','0','','','','','0','','0','B','','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoListLeng','40','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_PostMaxNum','20','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_TopNum','5','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_GroupCommentYzImg','','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoShowTime','100','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoSortShow','10','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoBigsortShow','15','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_feedbackID','111111','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MakeIndexHtmlTime','0','');
INSERT INTO `p8_fenlei_config` VALUES ('ErrSortMoney','13','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_DelKeyword','\r\n','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_PostMaxLeng','100000','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_RepeatPostNum','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_postCkMob','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_postCkIp','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_YzKeyword','԰\r\n\r\n','');
INSERT INTO `p8_fenlei_config` VALUES ('DelOtherCommentMoney','12','');
INSERT INTO `p8_fenlei_config` VALUES ('otherCardMoney','11','');
INSERT INTO `p8_fenlei_config` VALUES ('permitMoney','10','');
INSERT INTO `p8_fenlei_config` VALUES ('IDcardMoney','9','');
INSERT INTO `p8_fenlei_config` VALUES ('EmailYzMoney','8','');
INSERT INTO `p8_fenlei_config` VALUES ('ReportMoney','7','');
INSERT INTO `p8_fenlei_config` VALUES ('GoodCommentMoney','6','');
INSERT INTO `p8_fenlei_config` VALUES ('PublicizeRegMoney','5','');
INSERT INTO `p8_fenlei_config` VALUES ('ALLInfoMoney','4','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_loginTime','16','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_loginMoney','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_regmoney','1','');
INSERT INTO `p8_fenlei_config` VALUES ('illInfoMoney','14','');
INSERT INTO `p8_fenlei_config` VALUES ('DelReportMoney','15','');
INSERT INTO `p8_fenlei_config` VALUES ('Jump_allcity','0','');
INSERT INTO `p8_fenlei_config` VALUES ('GroupPostInfo','','');
INSERT INTO `p8_fenlei_config` VALUES ('Jump_fromarea','1','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_TopDay','2','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_closeWhy','վά,ͣ','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_areaname','ȫ','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_contact','010-88888888\r\nkefu@gmail.com\r\nkefu@msn.com\r\n88888888','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_weburl','','');
INSERT INTO `p8_fenlei_config` VALUES ('GroupPassYz','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_htmlType','0','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoListRow','10','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_htmlname','html','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_ImgShopContact','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_ForbidGuesViewContact','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_ShowSearchContact','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_Musttelephone','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_Mustmobphone','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MustQQ','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MustEmail','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_TopMoney','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_TopColor','#F70968','');
INSERT INTO `p8_fenlei_config` VALUES ('ForbidPostIp','','');
INSERT INTO `p8_fenlei_config` VALUES ('ForbidPostMember','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_forbidOutPost','1','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoIndexShow','20','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoIndexRow','16','');
INSERT INTO `p8_fenlei_config` VALUES ('Force_Choose_City','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MemberPostRepeat','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_Searchkeyword','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_guide_word','ҳ|index.php\r\n|list.php?fid=1\r\nƷ|list.php?fid=2\r\nְ|list.php?fid=4\r\nҵƸ|list.php?fid=3','');
INSERT INTO `p8_fenlei_config` VALUES ('UpdatePostTime','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_showday','3/10/30/60/90/180','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_allcityType','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_GuestPostRepeat','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MemberPostMoney','2','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MemberDayPostNum','20','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_GuestDayPostNum','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_ClosePostWhy','ϴʱ,ͣ޸Ϣ','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_ClosePost','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MemberChooseCity','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_ShowNoYz','1','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_DelEndtime','1','');
INSERT INTO `p8_fenlei_config` VALUES ('module_id','1','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_UseEndTime','1','');
INSERT INTO `p8_fenlei_config` VALUES ('CollectArticleNum','20','');
INSERT INTO `p8_fenlei_config` VALUES ('PostInfoMoney','2','');
INSERT INTO `p8_fenlei_config` VALUES ('InfoIndexLeng','26','');
INSERT INTO `p8_fenlei_config` VALUES ('InfoIndexRow','8','');
INSERT INTO `p8_fenlei_config` VALUES ('InfoListLeng','30','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_style','default','');
INSERT INTO `p8_fenlei_config` VALUES ('InfoListRow','10','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_allowGuesSearch','1','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_metakeywords','   ҳ','');
INSERT INTO `p8_fenlei_config` VALUES ('module_pre','fenlei_','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_webadmin','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_webOpen','1','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_webname','Ϣϵͳ','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_index_cache','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_list_cache','','');
INSERT INTO `p8_fenlei_module` VALUES ('1','0','סլ','10','','a:6:{s:8:\"field_db\";a:10:{s:6:\"sortid\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:6:\"sortid\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:14:\"1|\r\n2|н\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"1\";s:9:\"orderlist\";s:2:\"10\";s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:8:\"my_price\";a:17:{s:5:\"title\";s:4:\"۸\";s:10:\"field_name\";s:8:\"my_price\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:8;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"Ԫ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:8:\"my_rooms\";a:17:{s:5:\"title\";s:8:\"ڲ\";s:10:\"field_name\";s:8:\"my_rooms\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:72:\"һ\r\n\r\nһ\r\n\r\nһһ\r\nһ\r\n\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:9:\"my_peitao\";a:16:{s:5:\"title\";s:8:\"ʩ\";s:10:\"field_name\";s:9:\"my_peitao\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:150;s:9:\"form_type\";s:8:\"checkbox\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:40:\"ˮ\r\n\r\n绰\r\n\r\nܵú\r\n\r\nҾ\";s:10:\"form_value\";s:5:\"ˮ/\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:10:\"my_acreage\";a:16:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:10:\"my_acreage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"5\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:6:\"ƽ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:10:\"my_fitment\";a:16:{s:5:\"title\";s:8:\"װ\";s:10:\"field_name\";s:10:\"my_fitment\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:34:\"ͨװ\r\nװ\r\nװ\r\në\";s:10:\"form_value\";s:8:\"ͨװ\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:8:\"my_floor\";a:16:{s:5:\"title\";s:8:\"¥\";s:10:\"field_name\";s:8:\"my_floor\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"4\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"¥\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:4;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:10:\"my_station\";a:15:{s:5:\"title\";s:10:\"վ\";s:10:\"field_name\";s:10:\"my_station\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:3;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:6:\"my_bus\";a:18:{s:5:\"title\";s:8:\"·\";s:10:\"field_name\";s:6:\"my_bus\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:2;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"content\";a:16:{s:5:\"title\";s:8:\"עϢ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:1;s:9:\"allowview\";N;s:9:\"allowpost\";N;}}s:7:\"is_html\";a:0:{}s:9:\"search_db\";a:1:{s:6:\"sortid\";s:4:\"\";}s:12:\"IfListSearch\";a:1:{s:6:\"sortid\";s:4:\"\";}s:10:\"IfListShow\";a:3:{s:8:\"my_rooms\";s:8:\"ڲ\";s:8:\"my_price\";s:4:\"۸\";s:6:\"sortid\";s:4:\"\";}s:9:\"moduleSet\";a:1:{s:6:\"useMap\";s:1:\"1\";}}','','1');
INSERT INTO `p8_fenlei_module` VALUES ('2','0','һϢ','4','','a:5:{s:8:\"field_db\";a:2:{s:6:\"sortid\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:6:\"sortid\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:22:\"1|\r\n2|\r\n3|ҵ\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"1\";s:9:\"orderlist\";i:3;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"ϸϢ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"2\";s:9:\"allowview\";N;s:9:\"allowpost\";N;}}s:7:\"is_html\";a:0:{}s:9:\"search_db\";a:1:{s:6:\"sortid\";s:4:\"\";}s:10:\"IfListShow\";a:1:{s:6:\"sortid\";s:4:\"\";}s:12:\"IfListSearch\";a:1:{s:6:\"sortid\";s:4:\"\";}}','','1');
INSERT INTO `p8_fenlei_module` VALUES ('7','0','÷','9','','a:6:{s:8:\"field_db\";a:8:{s:6:\"sortid\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:6:\"sortid\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:14:\"1|\r\n2|н\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"1\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:10:\"my_acreage\";a:16:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:10:\"my_acreage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"5\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:6:\"ƽ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:8:\"my_price\";a:17:{s:5:\"title\";s:4:\"۸\";s:10:\"field_name\";s:8:\"my_price\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"8\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"Ԫ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:10:\"my_fitment\";a:16:{s:5:\"title\";s:8:\"װ\";s:10:\"field_name\";s:10:\"my_fitment\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:34:\"ͨװ\r\nװ\r\nװ\r\në\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:8:\"my_floor\";a:16:{s:5:\"title\";s:8:\"¥\";s:10:\"field_name\";s:8:\"my_floor\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:5;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"3\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"¥\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:10:\"my_station\";a:16:{s:5:\"title\";s:10:\"վ\";s:10:\"field_name\";s:10:\"my_station\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:6:\"my_bus\";a:16:{s:5:\"title\";s:8:\"·\";s:10:\"field_name\";s:6:\"my_bus\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:4;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"content\";a:16:{s:5:\"title\";s:8:\"עϢ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;s:9:\"allowpost\";N;}}s:7:\"is_html\";a:0:{}s:10:\"IfListShow\";a:2:{s:8:\"my_price\";s:4:\"۸\";s:6:\"sortid\";s:4:\"\";}s:9:\"search_db\";a:1:{s:6:\"sortid\";s:4:\"\";}s:12:\"IfListSearch\";a:1:{s:6:\"sortid\";s:4:\"\";}s:9:\"moduleSet\";a:1:{s:6:\"useMap\";s:1:\"1\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('3','0','Ƹ','6','','a:5:{s:8:\"field_db\";a:7:{s:6:\"sortid\";a:17:{s:5:\"title\";s:8:\"Ƹ\";s:10:\"field_name\";s:6:\"sortid\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:22:\"1|ȫְ\r\n2|ְ\r\n3|ʵϰ\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"1\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"my_jobs\";a:16:{s:5:\"title\";s:8:\"Ƹְλ\";s:10:\"field_name\";s:7:\"my_jobs\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"my_nums\";a:16:{s:5:\"title\";s:8:\"Ƹ\";s:10:\"field_name\";s:7:\"my_nums\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"5\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:12:\"my_workplace\";a:16:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:12:\"my_workplace\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:4:\"wage\";a:17:{s:5:\"title\";s:8:\"н\";s:10:\"field_name\";s:4:\"wage\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:102:\"1|\r\n2|1000Ԫ\r\n3|1000Ԫ-2000Ԫ\r\n4|2000Ԫ-3000Ԫ\r\n5|3000Ԫ-4000Ԫ\r\n6|4000Ԫ-5000Ԫ\r\n7|5000Ԫ\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:11:\"my_jobabout\";a:16:{s:5:\"title\";s:12:\"ְλҪ\";s:10:\"field_name\";s:11:\"my_jobabout\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:255;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"content\";a:16:{s:5:\"title\";s:8:\"˾\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;s:9:\"allowpost\";N;}}s:7:\"is_html\";a:0:{}s:12:\"IfListSearch\";a:3:{s:7:\"my_wage\";s:8:\"н\";s:6:\"sortid\";s:8:\"Ƹ\";s:4:\"wage\";s:8:\"н\";}s:10:\"IfListShow\";a:3:{s:7:\"my_wage\";s:8:\"н\";s:6:\"sortid\";s:8:\"Ƹ\";s:4:\"wage\";s:8:\"н\";}s:9:\"search_db\";a:1:{s:6:\"sortid\";s:8:\"Ƹ\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('4','0','ְ','7','','a:4:{s:8:\"field_db\";a:8:{s:7:\"my_jobs\";a:16:{s:5:\"title\";s:12:\"ְҵ\";s:10:\"field_name\";s:7:\"my_jobs\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:2:\"10\";s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:12:\"my_schoolage\";a:16:{s:5:\"title\";s:4:\"ѧ\";s:10:\"field_name\";s:12:\"my_schoolage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:52:\"Сѧ\r\n\r\n\r\nר\r\nר\r\n\r\nо\r\nʿ\";s:10:\"form_value\";s:4:\"ר\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"9\";s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:6:\"my_age\";a:16:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:6:\"my_age\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:8;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:6:\"my_sex\";a:16:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:6:\"my_sex\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:4;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:12:\"\r\nŮ\r\n\";s:10:\"form_value\";s:4:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:6:\"sortid\";a:17:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:6:\"sortid\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:38:\"1|Ӧ\r\n2|һ\r\n3|\r\n4|\r\n\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"6\";s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:12:\"my_workplace\";a:16:{s:5:\"title\";s:12:\"\";s:10:\"field_name\";s:12:\"my_workplace\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"my_wage\";a:16:{s:5:\"title\";s:8:\"н\";s:10:\"field_name\";s:7:\"my_wage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:88:\"\r\n1000Ԫ\r\n1000Ԫ-2000Ԫ\r\n2000Ԫ-3000Ԫ\r\n3000Ԫ-4000Ԫ\r\n4000Ԫ-5000Ԫ\r\n5000Ԫ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:4;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"ҽ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;s:9:\"allowpost\";N;}}s:7:\"is_html\";a:0:{}s:12:\"IfListSearch\";a:2:{s:12:\"my_workyears\";s:8:\"\";s:6:\"sortid\";s:8:\"\";}s:10:\"IfListShow\";a:2:{s:12:\"my_workyears\";s:8:\"\";s:6:\"sortid\";s:8:\"\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('5','0','','5','','a:5:{s:8:\"field_db\";a:9:{s:6:\"my_sex\";a:16:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:6:\"my_sex\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:4;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:12:\"\r\nŮ\r\n\";s:10:\"form_value\";s:4:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:11;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:6:\"my_age\";a:16:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:6:\"my_age\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:8;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:9:\"my_height\";a:16:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:9:\"my_height\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:8;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"3\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"CM\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:9:\"my_weight\";a:16:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:9:\"my_weight\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"3\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:4:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:6:\"my_job\";a:16:{s:5:\"title\";s:8:\"ְҵ\";s:10:\"field_name\";s:6:\"my_job\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:11:\"my_interest\";a:16:{s:5:\"title\";s:8:\"Ȥ\";s:10:\"field_name\";s:11:\"my_interest\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"50\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:6:\"sortid\";a:17:{s:5:\"title\";s:8:\"Ҫ\";s:10:\"field_name\";s:6:\"sortid\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:38:\"1|Ư\r\n2|ͻ\r\n3|Ӣ\r\n4|Ͻ\r\n5|ʵ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"1\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:9:\"schoo_age\";a:17:{s:5:\"title\";s:4:\"ѧ\";s:10:\"field_name\";s:9:\"schoo_age\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:68:\"1|Сѧ\r\n2|\r\n3|\r\n4|ר\r\n5|ר\r\n6|\r\n7|о\r\n8|ʿ\";s:10:\"form_value\";s:1:\"5\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"1\";s:9:\"orderlist\";i:4;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"ҽ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"3\";s:9:\"allowview\";N;s:9:\"allowpost\";N;}}s:7:\"is_html\";a:0:{}s:10:\"IfListShow\";a:2:{s:6:\"sortid\";s:8:\"Ҫ\";s:9:\"schoo_age\";s:4:\"ѧ\";}s:12:\"IfListSearch\";a:2:{s:6:\"sortid\";s:8:\"Ҫ\";s:9:\"schoo_age\";s:4:\"ѧ\";}s:9:\"search_db\";a:2:{s:6:\"sortid\";s:8:\"Ҫ\";s:9:\"schoo_age\";s:4:\"ѧ\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('6','0','','8','','a:4:{s:8:\"field_db\";a:5:{s:6:\"sortid\";a:17:{s:5:\"title\";s:8:\"׷ʽ\";s:10:\"field_name\";s:6:\"sortid\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:22:\"1|潻\r\n2|Ͻ\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:11;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:11:\"my_outprice\";a:17:{s:5:\"title\";s:4:\"ԭ\";s:10:\"field_name\";s:11:\"my_outprice\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"5\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"Ԫ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:8:\"my_price\";a:17:{s:5:\"title\";s:4:\"ּ\";s:10:\"field_name\";s:8:\"my_price\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:7;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"5\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"Ԫ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:9:\"my_hownew\";a:16:{s:5:\"title\";s:8:\"¾ɳ̶\";s:10:\"field_name\";s:9:\"my_hownew\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:67:\"9\r\n8\r\n7\r\n6\r\n5\r\n4\r\n3\r\n2\r\n1\r\nȫ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;s:9:\"allowpost\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"עϢ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:10:\"IfListShow\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"7\";s:9:\"allowview\";N;s:9:\"allowpost\";N;}}s:7:\"is_html\";a:0:{}s:10:\"IfListShow\";a:2:{s:8:\"my_price\";s:4:\"ּ\";s:6:\"sortid\";s:8:\"׷ʽ\";}s:12:\"IfListSearch\";a:1:{s:6:\"sortid\";s:8:\"׷ʽ\";}}','','0');
INSERT INTO `p8_fenlei_sort` VALUES ('1','0','','1','1','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','104','','FangChan');
INSERT INTO `p8_fenlei_sort` VALUES ('2','0','Ʒ','6','1','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','100','','WuPinJiaoYi');
INSERT INTO `p8_fenlei_sort` VALUES ('3','0','ҵƸ','6','1','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','50','','QiYeZhaoPin');
INSERT INTO `p8_fenlei_sort` VALUES ('4','0','ְ','2','1','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','37','','QiuZhiJianLi');
INSERT INTO `p8_fenlei_sort` VALUES ('5','0','ͬǽ','2','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','0','1','','TongChengJiaoYou');
INSERT INTO `p8_fenlei_sort` VALUES ('6','0','ͬǻ','2','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','0','1','','TongChengHuoDong');
INSERT INTO `p8_fenlei_sort` VALUES ('7','0','-','2','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','0','1','','FuWu_ShengHuoLei');
INSERT INTO `p8_fenlei_sort` VALUES ('8','0','-','2','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','0','1','','FuWu_ShangWuLei');
INSERT INTO `p8_fenlei_sort` VALUES ('9','0','','2','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','CheLiangMaiMaiYuFuWu');
INSERT INTO `p8_fenlei_sort` VALUES ('10','0','ѵ','2','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','0','1','','JiaoYuPeiXun');
INSERT INTO `p8_fenlei_sort` VALUES ('11','1','ⷿ','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','1','','ChuZuFang');
INSERT INTO `p8_fenlei_sort` VALUES ('12','1','ַ','1','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ErShouFangChuShou');
INSERT INTO `p8_fenlei_sort` VALUES ('13','1','ⷿ','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','HeZuFang');
INSERT INTO `p8_fenlei_sort` VALUES ('14','1','ⷿ','1','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DuanQiZuFang');
INSERT INTO `p8_fenlei_sort` VALUES ('15','1','ⷿ','1','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QiuZuFang');
INSERT INTO `p8_fenlei_sort` VALUES ('16','1','ַ','1','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ErShouFangQiuGou');
INSERT INTO `p8_fenlei_sort` VALUES ('17','1','̳/','7','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ShangPuChuZu_QiuZu');
INSERT INTO `p8_fenlei_sort` VALUES ('18','1','̳/','7','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ShangPuChuShou_QiuGou');
INSERT INTO `p8_fenlei_sort` VALUES ('19','1','д¥/','7','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','XieZiLouChuZu_QiuZu');
INSERT INTO `p8_fenlei_sort` VALUES ('20','1','д¥/','7','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','XieZiLouChuShou_QiuGou');
INSERT INTO `p8_fenlei_sort` VALUES ('21','2','Ʊ/Ʊ/ȯ/ѿ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','HuoChePiao_MenPiao_GouWuQuan_XiaoFeiKa');
INSERT INTO `p8_fenlei_sort` VALUES ('23','2','/Ʒ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ChongWu_ChongWuYongPin');
INSERT INTO `p8_fenlei_sort` VALUES ('24','2','̨ʽ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ErShouTaiShiDianNao');
INSERT INTO `p8_fenlei_sort` VALUES ('25','2','ֱʼǱ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','1','','ErShouBiJiBen');
INSERT INTO `p8_fenlei_sort` VALUES ('26','2','ֻ/ͨѶ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ShouJi_TongXunXiangGuan');
INSERT INTO `p8_fenlei_sort` VALUES ('27','2','/¼','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ErShouShuMa_SheLu');
INSERT INTO `p8_fenlei_sort` VALUES ('28','2','//Ӱ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','YinXiang_LeQi_YingYin');
INSERT INTO `p8_fenlei_sort` VALUES ('29','2','/ͼ/','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','RuanJian_TuShu_YinXiang');
INSERT INTO `p8_fenlei_sort` VALUES ('30','2','//ղƷ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','YiShu_GongYi_ShouCangPin');
INSERT INTO `p8_fenlei_sort` VALUES ('31','2','ĸӤ/ͯƷ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','MuYing_ErTongYongPin');
INSERT INTO `p8_fenlei_sort` VALUES ('32','2','//Ьñ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','FuShi_XiangBao_XieMao');
INSERT INTO `p8_fenlei_sort` VALUES ('33','2','ױƷ/Ʒ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','HuaZhuangPin_BaoJianPin');
INSERT INTO `p8_fenlei_sort` VALUES ('36','2','칫Ʒ/Ĳ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','BanGongYongPin_HaoCai');
INSERT INTO `p8_fenlei_sort` VALUES ('37','2','˶/','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','YunDong_JianShenQiCai');
INSERT INTO `p8_fenlei_sort` VALUES ('38','2','Ҿ/ðٻ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','JiaJu_RiYongBaiHuo');
INSERT INTO `p8_fenlei_sort` VALUES ('40','2','ּҵ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','ErShouJiaDian');
INSERT INTO `p8_fenlei_sort` VALUES ('42','2','/װ/Ʒ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','WangYou_ZhuangBei_XuNiWuPin');
INSERT INTO `p8_fenlei_sort` VALUES ('43','2','Ʒ','6','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','QiTaWuPin');
INSERT INTO `p8_fenlei_sort` VALUES ('44','9','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ErShouQiCheMaiMai');
INSERT INTO `p8_fenlei_sort` VALUES ('45','9','⳵/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZuChe_DaiJia');
INSERT INTO `p8_fenlei_sort` VALUES ('46','9','ְ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DaiCheQiuZhi');
INSERT INTO `p8_fenlei_sort` VALUES ('47','9','г','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZiXingCheMaiMai');
INSERT INTO `p8_fenlei_sort` VALUES ('48','9','Ħг/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','MoTuoChe_ZhuDongChe');
INSERT INTO `p8_fenlei_sort` VALUES ('49','9','ƴ°','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','PinCheShangXiaBan');
INSERT INTO `p8_fenlei_sort` VALUES ('50','9','У/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiaXiao_PeiLian');
INSERT INTO `p8_fenlei_sort` VALUES ('51','9','޳˾ְ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','WuCheSiJiQiuZhi');
INSERT INTO `p8_fenlei_sort` VALUES ('52','9','/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QiXiu_BaoYang');
INSERT INTO `p8_fenlei_sort` VALUES ('53','9','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','CheLiangPeiJian');
INSERT INTO `p8_fenlei_sort` VALUES ('54','9','³','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XinCheMaiMai');
INSERT INTO `p8_fenlei_sort` VALUES ('55','3','г/Ӫ','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ShiChang_YingXiao55');
INSERT INTO `p8_fenlei_sort` VALUES ('56','3','ְ','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JianZhi');
INSERT INTO `p8_fenlei_sort` VALUES ('57','3','/Ա','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','WenMi_WenYuan57');
INSERT INTO `p8_fenlei_sort` VALUES ('58','3','/һ㹤','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiGong_YiBanGongRen58');
INSERT INTO `p8_fenlei_sort` VALUES ('59','3','/','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DianNao_WangLuoXiangGuan59');
INSERT INTO `p8_fenlei_sort` VALUES ('60','3','/Ƶ','3','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','LvYou_JiuDianCanYin60');
INSERT INTO `p8_fenlei_sort` VALUES ('61','3','/߻','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','SheJi_CeHua61');
INSERT INTO `p8_fenlei_sort` VALUES ('62','3','/','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XingZheng_ZhuLi62');
INSERT INTO `p8_fenlei_sort` VALUES ('63','3','/ƻ/','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JinRong_CaiHui_ChuNa63');
INSERT INTO `p8_fenlei_sort` VALUES ('64','3','Ӫ','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JingYingGuanLi64');
INSERT INTO `p8_fenlei_sort` VALUES ('65','3','/','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','BaoJian_MeiRongMeiFa65');
INSERT INTO `p8_fenlei_sort` VALUES ('66','3','//','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','YinLe_BiaoYan_ZhuChi66');
INSERT INTO `p8_fenlei_sort` VALUES ('67','3','/е/','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DianZi_JiXie_GongCheng67');
INSERT INTO `p8_fenlei_sort` VALUES ('68','3','д/','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XieZuo_FanYi68');
INSERT INTO `p8_fenlei_sort` VALUES ('69','3','/ҵλ','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZhengFu_ShiYeDanWei69');
INSERT INTO `p8_fenlei_sort` VALUES ('70','3','ְλ','3','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QiTaZhiWei70');
INSERT INTO `p8_fenlei_sort` VALUES ('71','7','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiaZheng');
INSERT INTO `p8_fenlei_sort` VALUES ('72','7','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','BaoJie');
INSERT INTO `p8_fenlei_sort` VALUES ('73','7','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','BanJia');
INSERT INTO `p8_fenlei_sort` VALUES ('74','7','װ/װ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZhuangXiu_ZhuangShi');
INSERT INTO `p8_fenlei_sort` VALUES ('75','7','ܵͨ/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','GuanDaoShuTong_DaKong');
INSERT INTO `p8_fenlei_sort` VALUES ('76','7','ά','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DianNaoWeiXiu');
INSERT INTO `p8_fenlei_sort` VALUES ('77','7','ҵά','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiaDianWeiXiu');
INSERT INTO `p8_fenlei_sort` VALUES ('78','7','칫豸ά','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','BanGongSheBeiWeiXiu');
INSERT INTO `p8_fenlei_sort` VALUES ('79','7','ǻ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','LiYiHunQing');
INSERT INTO `p8_fenlei_sort` VALUES ('80','7','д/ɴӰ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XieZhen_HunShaSheYing');
INSERT INTO `p8_fenlei_sort` VALUES ('81','7','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','MeiRongMeiTi');
INSERT INTO `p8_fenlei_sort` VALUES ('82','7','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','YangShengBaoJian');
INSERT INTO `p8_fenlei_sort` VALUES ('83','7','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','LvYou');
INSERT INTO `p8_fenlei_sort` VALUES ('84','7','Ʊ/ؼۻƱ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DingPiao_TeJiaJiPiao');
INSERT INTO `p8_fenlei_sort` VALUES ('85','7','ˮ/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','SongShui_SongQi');
INSERT INTO `p8_fenlei_sort` VALUES ('86','7','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','PeiLian');
INSERT INTO `p8_fenlei_sort` VALUES ('87','4','г/Ӫ','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ShiChang_YingXiao');
INSERT INTO `p8_fenlei_sort` VALUES ('88','4','ְ','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QiuJianZhi');
INSERT INTO `p8_fenlei_sort` VALUES ('89','4','/Ա','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','WenMi_WenYuan');
INSERT INTO `p8_fenlei_sort` VALUES ('90','4','/һ㹤','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiGong_YiBanGongRen');
INSERT INTO `p8_fenlei_sort` VALUES ('91','4','/','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DianNao_WangLuoXiangGuan');
INSERT INTO `p8_fenlei_sort` VALUES ('92','4','/Ƶ','4','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','LvYou_JiuDianCanYin');
INSERT INTO `p8_fenlei_sort` VALUES ('93','4','/߻','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','SheJi_CeHua');
INSERT INTO `p8_fenlei_sort` VALUES ('94','4','/','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XingZheng_ZhuLi');
INSERT INTO `p8_fenlei_sort` VALUES ('95','4','/ƻ/','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JinRong_CaiHui_ChuNa');
INSERT INTO `p8_fenlei_sort` VALUES ('96','4','Ӫ','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JingYingGuanLi');
INSERT INTO `p8_fenlei_sort` VALUES ('97','4','/','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','BaoJian_MeiRongMeiFa');
INSERT INTO `p8_fenlei_sort` VALUES ('98','4','//','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','YinLe_BiaoYan_ZhuChi');
INSERT INTO `p8_fenlei_sort` VALUES ('99','4','/е/','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DianZi_JiXie_GongCheng');
INSERT INTO `p8_fenlei_sort` VALUES ('100','4','д/','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XieZuo_FanYi');
INSERT INTO `p8_fenlei_sort` VALUES ('101','4','/ҵλ','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZhengFu_ShiYeDanWei');
INSERT INTO `p8_fenlei_sort` VALUES ('102','4','ְλ','4','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QiTaZhiWei');
INSERT INTO `p8_fenlei_sort` VALUES ('103','8','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','KuaiDi');
INSERT INTO `p8_fenlei_sort` VALUES ('104','8','/վ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','SheJi_WangZhanJianShe');
INSERT INTO `p8_fenlei_sort` VALUES ('105','8','ӡˢ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','YinShua');
INSERT INTO `p8_fenlei_sort` VALUES ('106','8','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','PenHuiZhaoPai');
INSERT INTO `p8_fenlei_sort` VALUES ('107','8','̼','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZhaoShangJiaMeng');
INSERT INTO `p8_fenlei_sort` VALUES ('108','8','˾ע/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','GongSiZhuCe_NianJian');
INSERT INTO `p8_fenlei_sort` VALUES ('109','8','//','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','HuiJi_ShenJi_PingGu');
INSERT INTO `p8_fenlei_sort` VALUES ('110','8','/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JinRong_DanBaoDaiKuan');
INSERT INTO `p8_fenlei_sort` VALUES ('111','8','ʦ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','LvShi');
INSERT INTO `p8_fenlei_sort` VALUES ('112','8','Ƿ/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QingQian_ShangWuDiaoCha');
INSERT INTO `p8_fenlei_sort` VALUES ('113','8','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','FanYi');
INSERT INTO `p8_fenlei_sort` VALUES ('114','8','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','KuaiCanWaiMai');
INSERT INTO `p8_fenlei_sort` VALUES ('116','8','/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','WuLiu_HuoYun');
INSERT INTO `p8_fenlei_sort` VALUES ('117','8','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QiTa117');
INSERT INTO `p8_fenlei_sort` VALUES ('118','10','ҽ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiaJiao');
INSERT INTO `p8_fenlei_sort` VALUES ('119','10','ѵ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','WaiYuPeiXun');
INSERT INTO `p8_fenlei_sort` VALUES ('120','10','ְҵѵ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZhiYePeiXun');
INSERT INTO `p8_fenlei_sort` VALUES ('121','10','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiXuJiaoYu');
INSERT INTO `p8_fenlei_sort` VALUES ('122','10','/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','WenYi_TiYu');
INSERT INTO `p8_fenlei_sort` VALUES ('123','10','ѧ/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','LiuXue_YiMin');
INSERT INTO `p8_fenlei_sort` VALUES ('124','10','/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','DianNao_WangLuo');
INSERT INTO `p8_fenlei_sort` VALUES ('125','10','Сѧ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZhongXiaoXueJiaoYu');
INSERT INTO `p8_fenlei_sort` VALUES ('126','10','/Ա','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','KaoYan_GongWuYuan');
INSERT INTO `p8_fenlei_sort` VALUES ('127','10','','2','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','','QiTa127');
INSERT INTO `p8_fenlei_sort` VALUES ('128','5','Ů','5','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','0','','ZhaoNvYou');
INSERT INTO `p8_fenlei_sort` VALUES ('129','5','','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZhaoNanYou');
INSERT INTO `p8_fenlei_sort` VALUES ('130','5','ʿ','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','NanShiZhengHun');
INSERT INTO `p8_fenlei_sort` VALUES ('131','5','Ůʿ','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','NvShiZhengHun');
INSERT INTO `p8_fenlei_sort` VALUES ('132','5','ͬ','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','TongXiangHui');
INSERT INTO `p8_fenlei_sort` VALUES ('133','5','Ȥ','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XingQuJiaoYou');
INSERT INTO `p8_fenlei_sort` VALUES ('134','5','/ף','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','ZhenQingGaoBai_ZhuFu');
INSERT INTO `p8_fenlei_sort` VALUES ('135','5','ѰѰ','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XunRenXunYou');
INSERT INTO `p8_fenlei_sort` VALUES ('136','5','ܽ','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiNengJiaoHuan');
INSERT INTO `p8_fenlei_sort` VALUES ('137','5','','5','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QiTa137');
INSERT INTO `p8_fenlei_sort` VALUES ('138','6','ټ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','HuoDongZhaoJi');
INSERT INTO `p8_fenlei_sort` VALUES ('139','6','Ź/','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','TuanGou_DaZhe');
INSERT INTO `p8_fenlei_sort` VALUES ('140','6','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JieBanChuYou');
INSERT INTO `p8_fenlei_sort` VALUES ('141','6','Լ˶','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','XiangYueYunDong');
INSERT INTO `p8_fenlei_sort` VALUES ('142','6','/־Ը','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','GongYiHuoDong_ZhiYuanZhe');
INSERT INTO `p8_fenlei_sort` VALUES ('143','6','/ֻ/Ƹ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','JiangZuo_YanTaoHui_ZhaoPinHui');
INSERT INTO `p8_fenlei_sort` VALUES ('144','6','ݳ/չ','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','YanChu_ZhanLan');
INSERT INTO `p8_fenlei_sort` VALUES ('145','6','','2','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','','QiTa');
INSERT INTO `p8_fenlei_street` VALUES ('1','1','̫ƽׯ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','BeiTaiPingZhuang');
INSERT INTO `p8_fenlei_street` VALUES ('2','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DaZhongSi');
INSERT INTO `p8_fenlei_street` VALUES ('3','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DingHuiSi');
INSERT INTO `p8_fenlei_street` VALUES ('4','1','ʼҿ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','GanJiaKou');
INSERT INTO `p8_fenlei_street` VALUES ('5','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','GongZhuFen');
INSERT INTO `p8_fenlei_street` VALUES ('6','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HangTianQiao');
INSERT INTO `p8_fenlei_street` VALUES ('7','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','JianXiangQiao');
INSERT INTO `p8_fenlei_street` VALUES ('8','1','峧','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','LanDianChang');
INSERT INTO `p8_fenlei_street` VALUES ('9','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MaDian');
INSERT INTO `p8_fenlei_street` VALUES ('10','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','QingHe');
INSERT INTO `p8_fenlei_street` VALUES ('11','1','ϵ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShangDi');
INSERT INTO `p8_fenlei_street` VALUES ('12','1','ׯ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShangZhuang');
INSERT INTO `p8_fenlei_street` VALUES ('13','1','ļ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','SiJiQing');
INSERT INTO `p8_fenlei_street` VALUES ('14','1','κ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WeiGongCun');
INSERT INTO `p8_fenlei_street` VALUES ('15','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiErQi');
INSERT INTO `p8_fenlei_street` VALUES ('16','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WuDaoKou');
INSERT INTO `p8_fenlei_street` VALUES ('17','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiSanQi');
INSERT INTO `p8_fenlei_street` VALUES ('18','1','ֱ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiZhiMen');
INSERT INTO `p8_fenlei_street` VALUES ('19','1','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','WaiXiangShan');
INSERT INTO `p8_fenlei_street` VALUES ('20','1','ѧԺ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XueYuanLu');
INSERT INTO `p8_fenlei_street` VALUES ('21','1','Ȫ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YuQuanLu');
INSERT INTO `p8_fenlei_street` VALUES ('22','1','Բ԰','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YuanMingYuan');
INSERT INTO `p8_fenlei_street` VALUES ('23','1','йش','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ZhongGuanCun');
INSERT INTO `p8_fenlei_zone` VALUES ('1','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HaiDian');
INSERT INTO `p8_fenlei_zone` VALUES ('2','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChaoYang');
INSERT INTO `p8_fenlei_zone` VALUES ('3','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DongCheng');
INSERT INTO `p8_fenlei_zone` VALUES ('4','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XiCheng');
INSERT INTO `p8_fenlei_zone` VALUES ('5','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChongWen');
INSERT INTO `p8_fenlei_zone` VALUES ('6','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','XuanWu');
INSERT INTO `p8_fenlei_zone` VALUES ('7','1','̨','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','FengTai');
INSERT INTO `p8_fenlei_zone` VALUES ('8','1','ʯɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShiJingShan');
INSERT INTO `p8_fenlei_zone` VALUES ('9','1','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','FangShan');
INSERT INTO `p8_fenlei_zone` VALUES ('10','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','DaXing');
INSERT INTO `p8_fenlei_zone` VALUES ('11','1','ͨ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','TongZhou');
INSERT INTO `p8_fenlei_zone` VALUES ('12','1','˳','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ShunYi');
INSERT INTO `p8_fenlei_zone` VALUES ('13','1','ƽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','ChangPing');
INSERT INTO `p8_fenlei_zone` VALUES ('14','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MiYun');
INSERT INTO `p8_fenlei_zone` VALUES ('15','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','HuaiRou');
INSERT INTO `p8_fenlei_zone` VALUES ('16','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','YanQing');
INSERT INTO `p8_fenlei_zone` VALUES ('17','1','ƽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','PingGu');
INSERT INTO `p8_fenlei_zone` VALUES ('18','1','ͷ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','MenTouGou');
