DROP TABLE IF EXISTS `aijuhe_buddys`;
CREATE TABLE `aijuhe_buddys` (
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `buddyid` mediumint(8) unsigned NOT NULL default '0',
  `grade` tinyint(3) unsigned NOT NULL default '1',
  `dateline` int(10) unsigned NOT NULL default '0',
  `description` char(255) NOT NULL default '',
  KEY `uid` (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_failedlogins`;
CREATE TABLE `aijuhe_failedlogins` (
  `ip` char(15) NOT NULL default '',
  `count` tinyint(1) unsigned NOT NULL default '0',
  `lastupdate` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ip`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_form_cache`;
CREATE TABLE `aijuhe_form_cache` (
  `sid` varchar(6) NOT NULL default '',
  `method` varchar(4) NOT NULL default '',
  `action` varchar(255) NOT NULL default '',
  `referer` varchar(255) NOT NULL default '',
  `data` text,
  `expire` int(10) unsigned NOT NULL default '0',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group`;
CREATE TABLE `aijuhe_group` (
  `id` mediumint(10) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `photo` varchar(100) NOT NULL default '',
  `describe` varchar(160) NOT NULL default '',
  `class_id` smallint(5) unsigned NOT NULL default '0',
  `tag` varchar(50) NOT NULL default '',
  `allow_join` tinyint(1) NOT NULL default '1',
  `allow_browse` tinyint(1) unsigned NOT NULL default '0',
  `allow_new_thread` tinyint(1) unsigned NOT NULL default '0',
  `allow_new_post` tinyint(1) unsigned NOT NULL default '0',
  `allow_view_member` tinyint(1) unsigned NOT NULL default '0',
  `member_count` smallint(5) unsigned NOT NULL default '0',
  `invalid_member_count` smallint(5) unsigned NOT NULL default '0',
  `thread_count` smallint(5) unsigned NOT NULL default '0',
  `view_count` int(10) unsigned NOT NULL default '0',
  `creater_id` mediumint(5) unsigned NOT NULL default '0',
  `creater_username` varchar(15) NOT NULL default '',
  `is_system` tinyint(1) NOT NULL default '0',
  `recommend` int(10) unsigned NOT NULL default '0',
  `digest` tinyint(3) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  `tag_count` smallint(4) unsigned NOT NULL default '0',
  `group_favorite_count` int(10) unsigned NOT NULL default '0',
  `last_favorite` int(10) unsigned NOT NULL default '0',
  `item` varchar(15) NOT NULL default '',
  `item_id` int(10) unsigned NOT NULL default '0',
  `dig_count` int(10) unsigned NOT NULL default '0',
  `bury_count` int(10) unsigned NOT NULL default '0',
  `image_count` int(10) unsigned NOT NULL default '0',
  `rss_read_time` int(10) unsigned NOT NULL default '0',
  `rss_read_count` int(10) unsigned NOT NULL default '0',
  `news_count` int(10) unsigned NOT NULL default '0',
  `auto_read` tinyint(1) unsigned NOT NULL default '1',
  `image_read_time` int(10) unsigned NOT NULL default '0',
  `last_month_view_count_rank` int(10) unsigned NOT NULL default '0',
  `this_month_view_count_rank` int(10) unsigned NOT NULL default '0',
  `last_month_view_count` int(10) unsigned NOT NULL default '0',
  `this_month_view_count` int(10) unsigned NOT NULL default '0',
  `last_week_view_count_rank` int(10) unsigned NOT NULL default '0',
  `this_week_view_count_rank` int(10) unsigned NOT NULL default '0',
  `last_week_view_count` int(10) unsigned NOT NULL default '0',
  `this_week_view_count` int(10) unsigned NOT NULL default '0',
  `last_day_view_count_rank` int(10) unsigned NOT NULL default '0',
  `this_day_view_count_rank` int(10) unsigned NOT NULL default '0',
  `last_day_view_count` int(10) unsigned NOT NULL default '0',
  `this_day_view_count` int(10) unsigned NOT NULL default '0',
  `thread_read_time` int(10) unsigned NOT NULL default '0',
  `thread_read_count` int(10) unsigned NOT NULL default '0',
  `video_count` int(10) unsigned NOT NULL default '0',
  `video_read_time` int(10) unsigned NOT NULL default '0',
PRIMARY KEY  (`id`),                                                 
KEY `uid` (`creater_id`),                                            
KEY `item` (`item`,`item_id`),                                       
KEY `recommend` (`recommend`),                                       
KEY `name` (`name`),                                                 
KEY `dateline` (`dateline`),                                         
KEY `view_count` (`view_count`),                                     
KEY `member_count` (`member_count`),                                 
KEY `class_id` (`class_id`) 
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_group_class`;
CREATE TABLE `aijuhe_group_class` (                    
                      `id` smallint(4) unsigned NOT NULL auto_increment,   
                      `name` char(30) NOT NULL,                            
                      `path` char(30) NOT NULL,                            
                      `child_count` smallint(4) unsigned NOT NULL,         
                      `display_order` smallint(4) unsigned NOT NULL,   
		      `display_in_home` tinyint(1) NOT NULL default '1',
                      PRIMARY KEY  (`id`),                                 
                      KEY `path` (`path`)                  
                    ) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_group_diglog`;
CREATE TABLE `aijuhe_group_diglog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item_id` int(10) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `type_value` tinyint(1) NOT NULL default '1',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item_id` (`item_id`,`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_favorite`;
CREATE TABLE `aijuhe_group_favorite` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item` varchar(25) NOT NULL default '',
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `item_name` varchar(255) NOT NULL default '',
  `favoriter_id` mediumint(8) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `count` int(10) unsigned NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `anonymous` tinyint(1) unsigned NOT NULL default '0',
  `tag` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item` (`item`,`item_id`,`favoriter_id`),
  KEY `favoriter_id` (`favoriter_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_image`;
CREATE TABLE `aijuhe_group_image` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `image_id` int(10) unsigned NOT NULL default '0',
  `item_id` int(10) unsigned NOT NULL default '0',
  `class_id` int(10) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item_id` (`item_id`,`image_id`),
  KEY `image_id` (`image_id`),
  KEY `class_id` (`class_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_invite`;
CREATE TABLE `aijuhe_group_invite` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `group_id` smallint(5) unsigned NOT NULL default '0',
  `group_name` varchar(50) NOT NULL default '',
  `to_uid` mediumint(8) unsigned NOT NULL default '0',
  `to_username` varchar(15) NOT NULL default '',
  `from_uid` mediumint(8) unsigned NOT NULL default '0',
  `from_username` varchar(15) NOT NULL default '',
  `is_accept` tinyint(1) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `groups` (`group_id`,`to_uid`,`from_uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_keyword`;
CREATE TABLE `aijuhe_group_keyword` (                     
	`id` mediumint(10) unsigned NOT NULL auto_increment,    
	`keyword` varchar(100) NOT NULL default '',             
	`group_id` int(10) unsigned NOT NULL default '0',       
	`class_id` mediumint(5) unsigned NOT NULL default '0',  
	`dateline` int(10) unsigned NOT NULL default '0',       
	PRIMARY KEY  (`id`),                                    
	UNIQUE KEY `name` (`keyword`),                          
	KEY `group_id` (`group_id`),                            
	KEY `class_id` (`class_id`)                             
      ) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_link`;
CREATE TABLE `aijuhe_group_link` (
  `group_id` int(10) unsigned NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `link` varchar(100) NOT NULL default '',
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_member`;
CREATE TABLE `aijuhe_group_member` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `group_id` smallint(5) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `is_admin` tinyint(1) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  `validate` tinyint(1) unsigned NOT NULL default '1',
  `visit_times` int(10) unsigned NOT NULL default '0',
  `last_visit` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `group_member` (`group_id`,`uid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_msg`;
CREATE TABLE `aijuhe_group_msg` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `group_id` mediumint(8) unsigned NOT NULL default '0',
  `group_name` varchar(50) NOT NULL default '',
  `subject` varchar(255) NOT NULL default '',
  `message` text,
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_msg_member`;
CREATE TABLE `aijuhe_group_msg_member` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `group_msg_id` mediumint(8) unsigned NOT NULL default '0',
  `to_uid` mediumint(8) unsigned NOT NULL default '0',
  `is_read` tinyint(1) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `group_msg_id` (`group_msg_id`,`to_uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_post`;
CREATE TABLE `aijuhe_group_post` (
  `pid` int(10) unsigned NOT NULL auto_increment,
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `first` tinyint(1) unsigned NOT NULL default '0',
  `tid` int(10) unsigned NOT NULL default '0',
  `group_id` mediumint(8) unsigned NOT NULL default '0',
  `subject` varchar(255) NOT NULL default '',
  `tag` varchar(50) default NULL,
  `body` text,
  `dateline` int(10) unsigned NOT NULL default '0',
  `useful_count` smallint(5) unsigned NOT NULL default '0',
  `unuseful_count` smallint(5) unsigned NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`pid`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`),
  KEY `first` (`first`),
  KEY `tid` (`tid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_tag`;
CREATE TABLE `aijuhe_group_tag` (
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL auto_increment,
  `count` smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`item_id`,`tag_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_thread`;
CREATE TABLE `aijuhe_group_thread` (
  `tid` int(10) unsigned NOT NULL auto_increment,
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `group_id` smallint(5) unsigned NOT NULL default '0',
  `subject` varchar(255) NOT NULL default '',
  `body` text NOT NULL,
  `tag` varchar(255) NOT NULL default '',
  `post_count` smallint(5) unsigned NOT NULL default '0',
  `last_post_time` int(10) unsigned NOT NULL default '0',
  `last_poster_id` mediumint(8) unsigned NOT NULL default '0',
  `last_poster` varchar(15) NOT NULL default '',
  `commend` tinyint(3) unsigned NOT NULL default '0',
  `digest` tinyint(3) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  `rate` int(10) unsigned NOT NULL default '0',
  `view_count` int(10) unsigned NOT NULL default '0',
  `tag_count` smallint(4) unsigned NOT NULL default '0',
  `favorite_id` int(10) unsigned NOT NULL default '0',
  `item` varchar(15) NOT NULL default '',
  `item_id` int(10) unsigned NOT NULL default '0',
  `member_favorite_count` int(10) unsigned NOT NULL default '0',
  `last_favorite` int(10) unsigned NOT NULL default '0',
  `image_count` int(10) unsigned NOT NULL default '0',
  `old_group_id` int(10) unsigned NOT NULL default '0',
  `url` varchar(255) NOT NULL default '',
  `remote` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`tid`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`),
  KEY `item` (`item`,`item_id`),
  KEY `dateline` (`dateline`),                                    
  KEY `last_post_time` (`last_post_time`)      
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_group_thread_statistic`;
CREATE TABLE `aijuhe_group_thread_statistic` (             
 `tid` int(10) unsigned NOT NULL,                         
 `density` double NOT NULL default '-1',                  
 `title_length` int(10) unsigned NOT NULL default '0',    
 `content_length` int(10) unsigned NOT NULL default '0',  
 `ch_num` int(10) NOT NULL default '-1',                  
 `en_num` int(10) NOT NULL default '-1',                  
 `illegal_keyword` char(50) NOT NULL,                     
 `dateline` int(10) unsigned NOT NULL default '0',        
 `keywords_crc32` int(10) NOT NULL default '0',           
 PRIMARY KEY  (`tid`)                                     
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_thread_image`;
CREATE TABLE `aijuhe_group_thread_image` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `image_id` int(10) unsigned NOT NULL default '0',
  `item_id` int(10) unsigned NOT NULL default '0',
  `class_id` int(10) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `image_id` (`image_id`),
  KEY `item_id` (`item_id`),
  KEY `class_id` (`class_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_thread_read_log`;
CREATE TABLE `aijuhe_group_thread_read_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `url_hash` char(32) NOT NULL default '',
  `url` char(150) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `url_hash` (`url_hash`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_thread_tag`;
CREATE TABLE `aijuhe_group_thread_tag` (
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL default '0',
  `count` smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`item_id`,`tag_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_url_share`;
CREATE TABLE `aijuhe_group_url_share` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `to_group_id` mediumint(8) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `url_id` int(10) unsigned NOT NULL default '0',
  `describe` text,
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `group_id` (`to_group_id`),
  KEY `url_id` (`url_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_group_video`;
CREATE TABLE `aijuhe_group_video` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `video_id` int(10) unsigned NOT NULL default '0',
  `item_id` int(10) unsigned NOT NULL default '0',
  `class_id` int(10) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item_id` (`item_id`,`video_id`),
  KEY `video_id` (`video_id`),
  KEY `class_id` (`class_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_image`;
CREATE TABLE `aijuhe_image` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `item` char(30) NOT NULL default '0',
  `item_id` int(10) unsigned NOT NULL default '0',
  `class_id` int(10) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default '',
  `file` char(100) NOT NULL default '',
  `description` char(100) NOT NULL default '',
  `thumb` tinyint(1) unsigned NOT NULL default '0',
  `remote` tinyint(1) unsigned NOT NULL default '0',
  `view_count` int(10) unsigned NOT NULL default '0',
  `use_count` smallint(5) unsigned NOT NULL default '1',
  `dateline` int(10) unsigned NOT NULL default '0',
  `filename` char(100) NOT NULL default '',
  `filetype` char(50) NOT NULL default '',
  `filesize` int(10) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  `watermark` tinyint(1) unsigned NOT NULL default '0',
  `comment_count` int(10) unsigned NOT NULL default '0',
  `last_comment` int(10) unsigned NOT NULL default '0',
  `width` smallint(6) unsigned NOT NULL default '0',
  `height` smallint(6) unsigned NOT NULL default '0',
  `hash` char(32) NOT NULL default '',
  `show_error_count` smallint(5) unsigned NOT NULL default '0',
  `from` char(100) NOT NULL default '',
  `tag` char(255) NOT NULL default '',                           
  `tag_count` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `class_id` (`class_id`),
  KEY `uid` (`uid`),
  KEY `item` (`item`,`item_id`),
  KEY `hash` (`hash`),
  KEY `view_count` (`view_count`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_image_comment`;
CREATE TABLE `aijuhe_image_comment` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `subject` varchar(255) NOT NULL default '',
  `content` text NOT NULL,
  `dateline` int(10) unsigned NOT NULL default '0',
  `view_count` int(10) unsigned NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `item_id` (`item_id`,`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_image_keyword`;
CREATE TABLE `aijuhe_image_keyword` (
  `keyword` varchar(100) NOT NULL default '',
  `image_count` int(10) unsigned NOT NULL default '0',
  `search_times` int(10) unsigned NOT NULL default '0',
  `page_views` int(10) unsigned NOT NULL default '0',
  `last_search` int(10) unsigned NOT NULL default '0',
  `cache_time` int(10) unsigned NOT NULL default '0',
  `image_ids` text NOT NULL,
  PRIMARY KEY  (`keyword`),
  KEY `page_views` (`page_views`),
  KEY `search_times` (`search_times`),
  KEY `last_search` (`last_search`),
  KEY `image_count` (`image_count`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_ip_banned`;
CREATE TABLE `aijuhe_ip_banned` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `ip_start` int(10) unsigned NOT NULL default '0',
  `ip_end` int(10) unsigned NOT NULL default '0',
  `reason` char(255) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `expire` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ip_start` (`ip_start`,`ip_end`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_log`;
CREATE TABLE `aijuhe_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uid` int(10) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default 'ο',
  `action_id` smallint(5) unsigned NOT NULL default '0',
  `module` char(20) NOT NULL default 'index',
  `action` char(20) NOT NULL default '',
  `item_id` int(10) unsigned default NULL,
  `item_title` char(30) NOT NULL default '',
  `ip` char(15) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `uri` char(100) NOT NULL default '',
  `extcredits1` smallint(4) NOT NULL default '0',
  `extcredits2` smallint(4) NOT NULL default '0',
  `extcredits3` smallint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `action_id` (`action_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_log_blame`;
CREATE TABLE `aijuhe_log_blame` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item` char(30) NOT NULL default '',
  `item_id` int(10) unsigned NOT NULL default '0',
  `from_uid` int(10) unsigned NOT NULL default '0',
  `to_uid` int(10) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item` (`item`,`item_id`,`from_uid`,`to_uid`),
  KEY `from_uid` (`from_uid`),
  KEY `to_uid` (`to_uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_log_thank`;
CREATE TABLE `aijuhe_log_thank` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item` char(30) NOT NULL default '',
  `item_id` int(10) unsigned NOT NULL default '0',
  `from_uid` int(10) unsigned NOT NULL default '0',
  `to_uid` int(10) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item` (`item`,`item_id`,`from_uid`,`to_uid`),
  KEY `from_uid` (`from_uid`),
  KEY `to_uid` (`to_uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_memberfields`;
CREATE TABLE `aijuhe_memberfields` (
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `nickname` varchar(30) NOT NULL default '',
  `site` varchar(75) NOT NULL default '',
  `alipay` varchar(50) NOT NULL default '',
  `icq` varchar(12) NOT NULL default '',
  `qq` varchar(12) NOT NULL default '',
  `yahoo` varchar(40) NOT NULL default '',
  `msn` varchar(40) NOT NULL default '',
  `taobao` varchar(40) NOT NULL default '',
  `location` varchar(30) NOT NULL default '',
  `customstatus` varchar(30) NOT NULL default '',
  `medals` varchar(255) NOT NULL default '',
  `avatar` varchar(255) NOT NULL default '',
  `avatarwidth` tinyint(3) unsigned NOT NULL default '0',
  `avatarheight` tinyint(3) unsigned NOT NULL default '0',
  `bio` text NOT NULL,
  `signature` text NOT NULL,
  `sightml` text NOT NULL,
  `ignorepm` text NOT NULL,
  `groupterms` text NOT NULL,
  `authstr` varchar(20) NOT NULL default '',
  `question` varchar(255) NOT NULL default '',
  `answer` varchar(255) NOT NULL default '',
  `address` varchar(40) NOT NULL default '',
  `postcode` varchar(6) NOT NULL default '',
  PRIMARY KEY  (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_members`;
CREATE TABLE `aijuhe_members` (
  `uid` mediumint(8) unsigned NOT NULL auto_increment,
  `username` char(15) NOT NULL default '',
  `nickname` char(16) NOT NULL default '',
  `password` char(32) NOT NULL default '',
  `secques` char(8) NOT NULL default '',
  `gender` tinyint(1) NOT NULL default '0',
  `adminid` tinyint(1) NOT NULL default '0',
  `groupid` smallint(6) unsigned NOT NULL default '0',
  `groupexpiry` int(10) unsigned NOT NULL default '0',
  `extgroupids` char(60) NOT NULL default '',
  `regip` char(15) NOT NULL default '',
  `regdate` int(10) unsigned NOT NULL default '0',
  `lastip` char(15) NOT NULL default '',
  `lastvisit` int(10) unsigned NOT NULL default '0',
  `lastactivity` int(10) unsigned NOT NULL default '0',
  `lastpost` int(10) unsigned NOT NULL default '0',
  `posts` mediumint(8) unsigned NOT NULL default '0',
  `digestposts` smallint(6) unsigned NOT NULL default '0',
  `oltime` smallint(6) unsigned NOT NULL default '0',
  `pageviews` mediumint(8) unsigned NOT NULL default '0',
  `credits` int(10) NOT NULL default '0',
  `extcredits1` int(10) NOT NULL default '0',
  `extcredits2` int(10) NOT NULL default '0',
  `extcredits3` int(10) NOT NULL default '0',
  `extcredits4` int(10) NOT NULL default '0',
  `extcredits5` int(10) NOT NULL default '0',
  `extcredits6` int(10) NOT NULL default '0',
  `extcredits7` int(10) NOT NULL default '0',
  `extcredits8` int(10) NOT NULL default '0',
  `avatarshowid` int(10) unsigned NOT NULL default '0',
  `email` char(50) NOT NULL default '',
  `bday` date NOT NULL default '0000-00-00',
  `sigstatus` tinyint(1) NOT NULL default '0',
  `tpp` tinyint(3) unsigned NOT NULL default '0',
  `ppp` tinyint(3) unsigned NOT NULL default '0',
  `styleid` smallint(6) unsigned NOT NULL default '0',
  `dateformat` char(10) NOT NULL default '',
  `timeformat` tinyint(1) NOT NULL default '0',
  `pmsound` tinyint(1) NOT NULL default '0',
  `showemail` tinyint(1) NOT NULL default '0',
  `newsletter` tinyint(1) NOT NULL default '0',
  `invisible` tinyint(1) NOT NULL default '0',
  `timeoffset` char(4) NOT NULL default '',
  `newpm` tinyint(1) NOT NULL default '0',
  `accessmasks` tinyint(1) NOT NULL default '0',
  `face` char(60) default NULL,
  `tag_count` mediumint(6) default '0',
  `role_id` tinyint(3) NOT NULL default '0',
  `role_type` enum('admin','normal') NOT NULL default 'normal',
  `new_msg_count` tinyint(3) unsigned NOT NULL default '0',
  `group_count` tinyint(2) unsigned NOT NULL default '0',
  `group_ids` char(255) NOT NULL,
  `groups` char(1) default NULL,
  `tag` char(255) NOT NULL default '',
  `own_tags` int(10) unsigned default '0',
  `area_id` mediumint(10) unsigned NOT NULL default '0',
  `login_count` mediumint(8) unsigned NOT NULL default '0',
  `answer_count` mediumint(6) unsigned NOT NULL default '0',
  `correct_answer_count` mediumint(4) unsigned NOT NULL default '0',
  `truename` char(16) NOT NULL default '',
  `phone` char(15) NOT NULL default '',
  `major_id` smallint(5) unsigned NOT NULL default '0',
  `last_year_rank` int(10) unsigned NOT NULL default '0',
  `last_month_rank` int(10) unsigned NOT NULL default '0',
  `last_week_rank` int(10) unsigned NOT NULL default '0',
  `this_year_rank` int(10) unsigned NOT NULL default '0',
  `this_month_rank` int(10) unsigned NOT NULL default '0',
  `this_week_rank` int(10) unsigned NOT NULL default '0',
  `last_year_credit` int(10) unsigned NOT NULL default '0',
  `last_month_credit` int(10) unsigned NOT NULL default '0',
  `last_week_credit` int(10) unsigned NOT NULL default '0',
  `this_year_credit` int(10) unsigned NOT NULL default '0',
  `this_month_credit` int(10) unsigned NOT NULL default '0',
  `this_week_credit` int(10) unsigned NOT NULL default '0',
  `editormode` tinyint(1) unsigned NOT NULL default '2',
  `customshow` tinyint(1) unsigned NOT NULL default '26',
  `xspacestatus` tinyint(1) NOT NULL default '0',
  `view_times` int(10) unsigned NOT NULL default '0',
  `use_tag_count` mediumint(8) unsigned NOT NULL default '0',
  `create_tag_count` smallint(4) unsigned NOT NULL default '0',
  `image_count` int(10) unsigned NOT NULL default '0',
  `noticenum` smallint(4) unsigned NOT NULL,
  `ucuid` mediumint(8) NOT NULL, 
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `ucuid` (`ucuid`)
) ENGINE=MyISAM ;


DROP TABLE IF EXISTS `aijuhe_members_favorite`;
CREATE TABLE `aijuhe_members_favorite` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item` varchar(25) NOT NULL default '',
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `item_name` varchar(255) NOT NULL default '',
  `anonymous` tinyint(1) unsigned NOT NULL default '0',
  `favoriter_id` mediumint(8) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `count` int(10) unsigned NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `tag` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item` (`item`,`item_id`,`favoriter_id`),
  KEY `favoriter_id` (`favoriter_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_member_favorite_tag`;
CREATE TABLE `aijuhe_member_favorite_tag` (
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL default '0',
  `count` smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`item_id`,`tag_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_member_friend`;
CREATE TABLE `aijuhe_member_friend` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `friend_uid` mediumint(8) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uid` (`uid`,`friend_uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_member_validate`;
CREATE TABLE `aijuhe_member_validate` (
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `role_id` smallint(5) unsigned NOT NULL default '0',
  `key` char(16) NOT NULL default '',
  `status` tinyint(1) unsigned NOT NULL default '0',
  `verify_time` int(10) unsigned NOT NULL default '0',
  `regdate` int(10) unsigned NOT NULL default '0',
  `type` enum('email','admin') NOT NULL default 'email',
  UNIQUE KEY `key` (`key`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_my_group_tag`;
CREATE TABLE `aijuhe_my_group_tag` (
  `user_id` mediumint(8) unsigned NOT NULL default '0',
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL default '0',
  `count` smallint(4) unsigned NOT NULL default '1',
  PRIMARY KEY  (`user_id`,`item_id`,`tag_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_my_group_thread_tag`;
CREATE TABLE `aijuhe_my_group_thread_tag` (
  `user_id` mediumint(8) unsigned NOT NULL default '0',
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL default '0',
  `count` smallint(4) unsigned NOT NULL default '1',
  PRIMARY KEY  (`user_id`,`item_id`,`tag_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_my_aijuhe_news`;
CREATE TABLE `aijuhe_my_aijuhe_news` (
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `item_id` int(10) unsigned NOT NULL default '0',
  `new` mediumint(6) unsigned NOT NULL default '0',
  `anonymous` tinyint(1) unsigned NOT NULL default '0',
  `dateline` int(10) unsigned NOT NULL default '0',
  `last_update` int(10) unsigned NOT NULL default '0',
  `last_notify` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`uid`,`item_id`),
  KEY `item_id` (`item_id`,`dateline`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_my_news_tag`;
CREATE TABLE `aijuhe_my_news_tag` (
  `user_id` mediumint(8) unsigned NOT NULL default '0',
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL default '0',
  `count` smallint(4) unsigned NOT NULL default '1',
  PRIMARY KEY  (`user_id`,`item_id`,`tag_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_my_tag`;
CREATE TABLE `aijuhe_my_tag` (
  `user_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL default '0',
  `total_count` mediumint(8) unsigned NOT NULL default '0',
  `group_count` smallint(6) unsigned NOT NULL default '0',
  `news_count` smallint(6) unsigned NOT NULL default '0',
  `group_thread_count` smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`user_id`,`tag_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_news`;
CREATE TABLE `aijuhe_news` (                                      
               `id` int(10) unsigned NOT NULL auto_increment,                  
               `uid` mediumint(8) NOT NULL default '0',                        
               `username` char(15) NOT NULL,                                   
               `url` char(200) NOT NULL,                                       
               `subject` char(100) NOT NULL,                                   
               `dateline` int(10) NOT NULL,                                    
               `last_post` int(10) NOT NULL,                                   
               `dig_count` mediumint(6) NOT NULL default '1',                  
               `dig_show` int(10) NOT NULL default '0',                        
               `bury_count` mediumint(6) NOT NULL default '0',                 
               `visit_count` mediumint(8) NOT NULL default '1',                
               `last_visit_time` int(10) NOT NULL,                             
               `tag` char(200) NOT NULL,                                       
               `tag_count` smallint(4) unsigned NOT NULL default '0',          
               `member_favorite_count` int(10) unsigned NOT NULL default '0',  
               `last_favorite` int(10) unsigned NOT NULL default '0',          
               `group_favorite_count` int(10) unsigned NOT NULL default '0',   
               `item` char(20) NOT NULL,                                       
               `item_id` int(10) unsigned NOT NULL default '0',                
               `comment_count` int(10) unsigned NOT NULL default '0',          
               `last_comment` int(10) unsigned NOT NULL default '0',           
               `from_rss` tinyint(1) unsigned NOT NULL default '0',            
               `image_count` int(10) unsigned NOT NULL default '0',            
               PRIMARY KEY  (`id`),                                            
               KEY `last_post` (`last_post`),                                  
               KEY `user_id` (`uid`),                                          
               KEY `hot_date` (`dig_show`),                                    
               KEY `subject` (`subject`),                                      
               KEY `url` (`url`),                                              
               KEY `item` (`item`,`item_id`),                                  
               KEY `visit_count` (`visit_count`),                              
               KEY `dateline` (`dateline`)                             
             ) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_news_content`;
CREATE TABLE `aijuhe_news_content` (  
                       `news_id` int(10) NOT NULL,         
                       `content` text,   
                       `last_read_time` int(10) default NULL,                  
                       PRIMARY KEY  (`news_id`)            
                     ) ENGINE=MyISAM;
DROP TABLE IF EXISTS `aijuhe_news_search`;

CREATE TABLE `aijuhe_news_search` (                                              
                      `id` int(10) NOT NULL auto_increment,                                          
                      `keyword` varchar(100) NOT NULL default '',  
                      `dateline` int(10) NOT NULL default '0',                                       
                      `search_times` mediumint(8) NOT NULL default '1',                              
                      `item_count` int(10) NOT NULL default '0',                                     
                      `item_ids` text NOT NULL,                                                      
                      PRIMARY KEY  (`id`),                                                           
                      UNIQUE KEY `keyword` (`keyword`)                                               
                    ) ENGINE=MyISAM;



DROP TABLE IF EXISTS `aijuhe_news_comment`;
CREATE TABLE `aijuhe_news_comment` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `subject` varchar(255) NOT NULL default '',
  `content` text NOT NULL,
  `dateline` int(10) unsigned NOT NULL default '0',
  `view_count` int(10) unsigned NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `item_id` (`item_id`,`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_news_diglog`;
CREATE TABLE `aijuhe_news_diglog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item_id` int(10) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `type_value` tinyint(1) NOT NULL default '1',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item_id` (`item_id`,`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_news_group_rss_log`;
CREATE TABLE `aijuhe_news_group_rss_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `url_hash` char(32) NOT NULL default '',
  `url` char(150) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `url_hash` (`url_hash`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_news_image`;
CREATE TABLE `aijuhe_news_image` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `image_id` int(10) unsigned NOT NULL default '0',
  `item_id` int(10) unsigned NOT NULL default '0',
  `class_id` int(10) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `item_id` (`item_id`,`image_id`),
  KEY `image_id` (`image_id`),
  KEY `class_id` (`class_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_news_news_rss_log`;
CREATE TABLE `aijuhe_news_news_rss_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `url_hash` char(32) NOT NULL default '',
  `url` char(150) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `url_hash` (`url_hash`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_news_tag`;
CREATE TABLE `aijuhe_news_tag` (
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL auto_increment,
  `count` smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`item_id`,`tag_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_onlinetime`;
CREATE TABLE `aijuhe_onlinetime` (
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `thismonth` smallint(6) unsigned NOT NULL default '0',
  `total` mediumint(8) unsigned NOT NULL default '0',
  `lastupdate` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`uid`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_pms`;
CREATE TABLE `aijuhe_pms` (
  `pmid` int(10) unsigned NOT NULL auto_increment,
  `msgfrom` varchar(15) NOT NULL default '',
  `msgfromid` mediumint(8) unsigned NOT NULL default '0',
  `msgtoid` mediumint(8) unsigned NOT NULL default '0',
  `folder` enum('inbox','outbox') NOT NULL default 'inbox',
  `new` tinyint(1) NOT NULL default '0',
  `subject` varchar(75) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `message` text NOT NULL,
  `delstatus` tinyint(1) unsigned NOT NULL default '0',
  `is_hi` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`pmid`),
  KEY `msgtoid` (`msgtoid`,`folder`,`dateline`),
  KEY `msgfromid` (`msgfromid`,`folder`,`dateline`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS aijuhe_role;
CREATE TABLE `aijuhe_role` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `creditshigher` int(10) NOT NULL default '0',
  `creditslower` int(10) NOT NULL default '0',
  `privilege` mediumtext NOT NULL,
  `type` enum('normal','admin') NOT NULL default 'normal',
  `rank` tinyint(1) unsigned NOT NULL default '0',
  `discuz_group_id` tinyint(3) unsigned NOT NULL default '10',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

INSERT INTO aijuhe_role VALUES  ('1',0xd3cebfcd,'0','0',0x32302c32352c32372c33312c33352c33382c34352c34372c34382c35302c35312c35322c35332c35342c35352c35362c35382c3738,'normal','2','7'), ('2',0xb9dcc0edd4b1,'0','0',0x372c382c392c31302c31312c31322c31332c32302c32312c32322c32332c32342c32352c32362c32372c32392c33302c33312c33322c33332c33342c33352c33362c33372c33382c33392c34302c34312c34322c34332c34342c34352c34362c34372c34382c35302c35312c35322c35332c35342c35352c35362c35372c35382c36372c36382c37342c37362c37382c37392c38302c38342c38382c38392c39302c39312c39322c39332c39342c39352c39362c3130302c3130312c3130322c3130332c3130352c3130362c3130372c3130382c3131302c3131312c3131322c3131332c3131342c3131352c3131362c3131372c3131382c3131392c3132312c3132332c3132342c3132352c3132362c3132372c3132382c3132392c3133302c3133312c3133322c3133332c3133342c3133352c3133362c3133372c3133382c3133392c3134302c3134312c3134322c3134332c3134342c3134352c3134362c3134372c3134382c3134392c3135302c3135312c3135322c3135332c3135342c3135352c3135362c3135372c3135382c3135392c3136302c3136312c313632,'admin','1','1'), ('3',0xc6d5cda8bbe1d4b1,'0','1000',0x32302c32312c32322c32332c32342c32352c32362c32372c32392c33302c33312c33322c33332c33342c33352c33362c33372c33382c33392c34302c34312c34322c34332c34342c34352c34372c34382c35302c35312c35322c35332c35342c35352c35372c35382c37382c3132342c3134382c3134392c313536,'normal','2','10'), ('4',0xbdfbd6b9bbe1d4b1,'0','0',0x32302c32352c33312c33352c34302c34352c34382c35302c35312c35322c35332c35342c35362c35382c3738,'normal','3','5'), ('9',0xbdfbd1d4d7e9,'0','0',0x32302c32352c34352c34382c35302c35312c35322c35332c35362c35382c3738,'normal','0','10'), ('14',0xb5c8d1e9d6a4bbe1d4b1,'0','0',0x32302c32352c32372c33312c33352c33382c34352c34382c35302c35312c35322c35332c35362c35382c3738,'normal','0','8'), ('17',0xcfb5cdb3ceacbba4c8cbd4b1,'0','0',0x382c31312c31332c32302c32312c32322c32332c32342c32352c32362c32372c32392c33302c33312c33322c33332c33342c33352c33362c33372c33382c33392c34302c34312c34322c34332c34342c34352c34362c34372c34382c35302c35312c35322c35332c35342c35352c35362c35372c35382c37342c37362c37382c38382c38392c39322c39342c3132342c3132352c3132362c3133332c3133352c3133372c3133382c3133392c3134302c3134312c3134382c3134392c3135302c3135362c3135372c3135382c313539,'admin','0','10');

DROP TABLE IF EXISTS aijuhe_role_action;
CREATE TABLE `aijuhe_role_action` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `module` varchar(20) NOT NULL default 'index',
  `action` varchar(20) NOT NULL,
  `describe` varchar(255) NOT NULL,
  `message` varchar(255) NOT NULL,
  `allow_all` tinyint(1) NOT NULL default '0',
  `credit_require` varchar(255) NOT NULL,
  `credit_update` varchar(255) NOT NULL,
  `php_code` text NOT NULL,
  `log` tinyint(1) unsigned NOT NULL default '0',
  `is_admin` tinyint(1) unsigned default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `action` (`module`,`name`,`is_admin`)
) ENGINE=MyISAM;
INSERT INTO aijuhe_role_action VALUES  ('88',0xbdf8c8ebbaf3cca8,0x696e646578,0x2a,'','','0','','','','0','1'), ('92',0xb2e9bfb455524cb5d8d6b7c9e8d6c3,0x73657474696e67,0x6d6f646966795f72657772697465,'','','0','','','','0','1'), ('7',0xccedbcd3d0c2bdc7c9ab,0x726f6c65,0x646f616464,'','','0','','','','0','1'), ('8',0xb2e9bfb4bdc7c9abc1d0b1ed,0x726f6c65,0x6c697374,'','','0','','','','0','1'), ('9',0xd0deb8c4bdc7c9abc8a8cfde,0x726f6c65,0x646f6d6f64696679,'','','0','','','','0','1'), ('10',0xccedbcd3d0c2b6afd7f7,0x726f6c655f616374696f6e,0x646f616464,'','','0','','','','0','1'), ('11',0xcbf9d3d0b6afd7f7c1d0b1ed,0x726f6c655f616374696f6e,0x6c697374,'','','0','','','','0','1'), ('12',0xd0deb8c4bbfdb7d6c9e8d6c3,0x73657474696e67,0x646f6d6f646966795f63726564697473,'','','0','','','','0','1'), ('13',0xb2e9bfb4bacbd0c4c9e8d6c3,0x73657474696e67,0x6d6f646966795f6e6f726d616c,'','','0','','','','0','1'), ('20',0xd7a8cce2cad7d2b3,0x67726f7570,'','','','1','','','','0','0'), ('21',0xb4b4bda8d7a8cce2,0x67726f7570,0x6164647c6372656174657c646f616464,'','','0','','','','0','0'), ('22',0xc7b0cca8c9beb3fdd7a8cce2,0x67726f7570,0x64697362616e64,'','','0','','','','0','0'), ('23',0xcdcbb3f6d7a8cce2,0x67726f7570,0x64726f706f7574,'','','0','','','','0','0'), ('24',0xbcd3c8ebd7a8cce2,0x67726f7570,0x6a6f696e,'','','0','','','','1','0'), ('25',0xd7a8cce2c1d0b1ed,0x67726f7570,0x6c697374,'','','1','','','','0','0'), ('26',0xd0deb8c4d7a8cce2c9e8d6c3,0x67726f7570,0x6d6f646966797c646f6d6f64696679,'','','0','','','','1','0'), ('27',0xcbd1cbf7d7a8cce2,0x67726f7570,0x736561726368,'','','1','','','','0','0'), ('79',0xd0deb8c4b6afd7f7b5c4c4a3bfe9,0x726f6c655f6d6f64756c65,0x646f6d6f64696679,'','','0','','','','0','1'), ('29',0xccedbcd3d7a8cce2cad5b2d8,0x67726f75705f6661766f72697465,0x6164647c646f616464,'','','0','','','','0','0'), ('30',0xc9beb3fdd7a8cce2cad5b2d8,0x67726f75705f6661766f72697465,0x64656c657465,'','','0','','','','0','0'), ('31',0xc1d0b1edd7a8cce2cad5b2d8,0x67726f75705f6661766f72697465,0x6c697374,'','','1','','','','0','0'), ('32',0xbdd3cadcd7a8cce2d1fbc7eb,0x67726f75705f696e76697465,0x616363657074,'','','0','','','','0','0'), ('33',0xb7a2cbcdd7a8cce2d1fbc7eb,0x67726f75705f696e76697465,0x6164647c646f616464,'','','0','','','','0','0'), ('34',0xc9beb3fdd7a8cce2d1fbc7eb,0x67726f75705f696e76697465,0x64656c657465,'','','0','','','','0','0'), ('35',0xb2e9bfb4d7a8cce2d1fbc7eb,0x67726f75705f696e76697465,0x6c697374,'','','1','','','','0','0'), ('36',0xbdb5bcb6d7a8cce2bbe1d4b1,0x67726f75705f6d656d626572,0x64656772616465,'','','0','','','','0','0'), ('37',0xc9beb3fdd7a8cce2bbe1d4b1,0x67726f75705f6d656d626572,0x64656c657465,'','','0','','','','0','0'), ('38',0xc1d0b1edd7a8cce2bbe1d4b1,0x67726f75705f6d656d626572,0x6c697374,'','','1','','','','0','0'), ('39',0xc9fdbcb6d7a8cce2bbe1d4b1,0x67726f75705f6d656d626572,0x75706772616465,'','','0','','','','0','0'), ('40',0xc7b0cca8c9beb3fdbbd8b8b4,0x67726f75705f706f7374,0x64656c657465,'','','0','','','','0','0'), ('41',0xccedbcd3bbb0cce2bbd8b8b4,0x67726f75705f706f7374,0x646f616464,'','','0','','','','0','0'), ('42',0xb7a2b2bcbbb0cce2,0x67726f75705f746872656164,0x6164647c646f616464,'','','0','','','','0','0'), ('43',0xd6c3b6a5bbb0cce2,0x67726f75705f746872656164,0x6465676973747c756e646567697374,'','','0','','','','0','0'), ('44',0xc7b0cca8c9beb3fdbbb0cce2,0x67726f75705f746872656164,0x64656c657465,'','','0','','','','0','0'), ('45',0xc1d0b1edbbb0cce2,0x67726f75705f746872656164,0x6c697374,'','','1','','','','0','0'), ('46',0xd0deb8c4bbb0cce2,0x67726f75705f746872656164,0x6d6f646966797c646f6d6f64696679,'','','0','','','','0','0'), ('47',0xcbd1cbf7bbb0cce2,0x67726f75705f746872656164,0x736561726368,'','','0','','','','0','0'), ('48',0xb2e9bfb4bbb0cce2,0x67726f75705f746872656164,0x76696577,'','','1','','','','0','0'), ('50',0xb5c7c2bdcfb5cdb3,0x6c6f67696e,0x646f6c6f67696e7c,'','','1','','','','0','0'), ('51',0xcdcbb3f6cfb5cdb3,0x6c6f67696e,0x6c6f676f7574,'','','1','','','','0','0'), ('52',0xc1d0b1edbbe1d4b1,0x6d656d626572,0x6c697374,'','','1','','','','0','0'), ('53',0xc7b0cca8d0deb8c4b8f6c8cbd0c5cfa2,0x6d656d626572,0x6d6f646966797c646f6d6f64696679,'','','1','','','','0','0'), ('54',0xd7a2b2e1bbe1d4b1,0x6d656d626572,0x72656769737465727c646f72656769,'','','0','','','','0','0'), ('55',0xcbd1cbf7bbe1d4b1,0x6d656d626572,0x736561726368,'','','0','','','','0','0'), ('56',0xc7b0cca8b2e9bfb4bbe1d4b1,0x6d656d626572,0x76696577,'','','1','','','','0','0'), ('57',0xccedbcd3d0c2cec5,0x6e657773,0x6164647c646f616464,'','','-1','','','','1','0'), ('58',0xb2e9bfb4d0c2cec5,0x6e657773,0x76696577,'','','1','','','','0','0'), ('67',0xc7b0cca8d7cad1b6b9dcc0ed,0x6e657773,0x61646d696e7c646f5f61646d696e,'','','0','','','','0','0'), ('68',0xbaf3cca8b1e0bcadbbe1d4b1d0c5cfa2,0x6d656d626572,0x646f6d6f64696679,'','','0','','','','0','1'), ('74',0xc7b0cca8d7a8cce2b9dcc0ed,0x67726f7570,0x61646d696e6973747261746f72,'','','0','','','','0','0'), ('76',0xb2e9bfb4b6a5b2bfb5bcbabdc9e8d6c3,0x6e61766967617465,0x6d6f64696679,'','','0','','','','0','1'), ('78',0xb2e9bfb4d7a8cce2,0x67726f7570,0x76696577,'','','1','','','','0','0'), ('80',0xd0deb8c4bcc6bbaec8cecef1c1d0b1ed,0x7461736b,0x646f62617463686d6f64696679,'','','0','','','','0','1'), ('138',0xb7d6c4a3bfe9b6afd7f7c1d0b1ed,0x726f6c655f616374696f6e,0x6c6973745f616374696f6e,'','','0','','','','0','1'), ('100',0xd0deb8c4cdf8d5beb9e3b8e6,0x696e636f6d65,0x646f6d6f64696679,'','','0','','','','0','1'), ('84',0xb1e0bcadd3d1c7e9c1b4bdd3,0x6c696e6b,0x646f6d6f64696679,'','','0','','','','0','1'), ('89',0xb6afd7f7b5c4c4a3bfe9c1d0b1ed,0x726f6c655f6d6f64756c65,0x6d6f64696679,'','','0','','','','0','1'), ('90',0xcce1bdbbcafdbeddbfe2b1b8b7dd,0x6462,0x646f6578706f7274,'',0xb1a7c7b8a3ac64656d6fb9dcc0edd4b1bdfbd6b9b6d4cafdbeddbfe2bdf8d0d0b1b8b7ddb2d9d7f7,'0','','','','0','1'), ('91',0xd0deb8c4bacbd0c4c9e8d6c3,0x73657474696e67,0x646f6d6f646966795f6e6f726d616c,'','','0','','','','0','1'), ('93',0xd0deb8c455524cb5d8d6b7c9e8d6c3,0x73657474696e67,0x646f6d6f646966795f72657772697465,'','','0','','','','0','1'), ('94',0xb2e9bfb4c4dac8ddbedbbacfc9e8d6c3,0x73657474696e67,0x6d6f646966795f72656d6f7465,'','','0','','','','0','1'), ('95',0xd0deb8c4c4dac8ddbedbbacfc9e8d6c3,0x73657474696e67,0x646f6d6f646966795f72656d6f7465,'','','0','','','','0','1'), ('96',0xd0deb8c4b6a5b2bfb5bcbabdc9e8d6c3,0x6e61766967617465,0x646f6d6f64696679,'','','0','','','','0','1'), ('124',0xc7b0cca8b7a2b1edc6c0c2db,0x636f6d6d656e74,0x646f616464,'','','-1','','','','0','0'), ('101',0xd0deb8c4b6afd7f7c9e8d6c3,0x726f6c655f616374696f6e,0x646f6d6f64696679,'','','0','','','','0','1'), ('102',0xc9beb3fdb6afd7f7,0x726f6c655f616374696f6e,0x64656c657465,'','','0','','','','0','1'), ('103',0xbaf3cca8ccedbcd3d0c2d3c3bba7,0x6d656d626572,0x646f616464,'','','0','','','','0','1'), ('105',0xbaf3cca8c9beb3fdd3c3bba7,0x6d656d626572,0x64656c6574657c646f64656c657465,'','','0','','','','0','1'), ('106',0xd0deb8c4bde7c3e6cfd4cabec9e8b6a8,0x73686f77,0x646f6d6f64696679,'','','0','','','','0','1'), ('107',0xbde2d1b9cbf5cafdbeddb1b8b7ddb0fc,0x6462,0x696d706f72747a6970,'','','0','','','','0','1'), ('108',0xbfaab9d8d6a9d6ebcdb3bcc6,0x726f626f74,0x646f6d6f64696679,'','','0','','','','0','1'), ('110',0xc9beb3fd544147,0x746167,0x64656c657465,'','','0','','','','0','1'), ('111',0xd0deb8c4c4dac8ddb9fdc2cbc9e8d6c3,0x73657474696e67,0x646f6d6f646966795f66696c746572,'','','0','','','','0','1'), ('112',0xbaf3cca8c9beb3fdcdbcc6ac,0x696d616765,0x64656c657465,'','','0','','','','0','1'), ('113',0xbaf3cca8c9beb3fdcad3c6b5,0x766964656f,0x64656c657465,'','','0','','','','0','1'), ('114',0xd0deb8c4b8bdbcfec9e8d6c3,0x6174746163686d656e74,0x646f73657474696e67,'','','0','','','','0','1'), ('115',0xd0deb8c44950b7c3cecabfd8d6c6,0x73657474696e67,0x646f6d6f646966795f616363657373,'','','0','','','','0','1'), ('116',0xbaf3cca8c9beb3fdc6c0c2db,0x636f6d6d656e74,0x64656c657465,'','','0','','','','0','1'), ('117',0xbaf3cca8c9beb3fdd7a8cce2,0x67726f7570,0x64656c657465,'','','0','','','','0','1'), ('118',0xd0deb8c4b7d6c0e0c9e8d6c3,0x636c617373,0x646f5f6d6f64696679,'','','0','','','','0','1'), ('119',0xc9beb3fdd7eebdfccbd1cbf7,0x736561726368,0x64656c657465,'','','0','','','','0','1'), ('121',0xbaf3cca8c9beb3fdbbd8b8b420,0x67726f75705f706f7374,0x64656c657465,'','','0','','','','0','1'), ('123',0xd6b4d0d0cafdbeddbfe2d3c5bbaf,0x6462,0x646f6f7074696d697a65,'','','0','','','','0','1'), ('125',0xb2e9bfb4c4dac8ddb9fdc2cbc9e8d6c3,0x73657474696e67,0x6d6f646966795f66696c746572,'','','0','','','','0','1'), ('126',0xb2e9bfb44950b7c3cecabfd8d6c6,0x73657474696e67,0x6d6f646966795f616363657373,'','','0','','','','0','1'), ('127',0xd0deb8c4b9d8d3daced2c3c7,0x61626f7574,0x646f6d6f64696679,'','','0','','','','0','1'), ('128',0xbfaab9d8c4dac8ddc9f3bacb,0x76616c69646174696e67,0x73657474696e67,'','','0','','','','0','1'), ('129',0xc5fac1bfb4a6c0edd7a8cce2,0x67726f7570,0x646f62617463686d6f64696679,'','','0','','','','0','1'), ('130',0xbaf3cca8c5fac1bfc9f3bacbbbb0cce2,0x67726f75705f746872656164,0x737461746973746963,'','','0','','','','0','1'), ('131',0xbaf3cca8c9beb3fdd7cad1b6,0x6e657773,0x64656c7c64656c657465,'','','0','','','','0','1'), ('132',0xb5bcc8ebcafdbeddbbd6b8b4,0x6462,0x646f696d706f7274,'','','0','','','','0','1'), ('133',0xb2e9bfb4cafdbeddbfe2b1b8b7dd,0x6462,0x696d706f7274,'','','0','','','','0','1'), ('134',0xc9beb3fdcafdbeddbfe2b1b8b7dd,0x6462,0x646f64656c657465,'','','0','','','','0','1'), ('135',0xb2e9bfb45543d5fbbacfc5e4d6c3,0x7563656e746572,0x7563656e746572,'','','0','','','','0','1'), ('136',0xbfaac6f4c9e8d6c35563656e746572,0x7563656e746572,0x646f5f73657474696e67,'','','0','','','','0','1'), ('137',0xb2e9bfb4bdc7c9abc8a8cfde,0x726f6c65,0x6d6f64696679,'','','0','','','','0','1'), ('139',0xb2e9bfb4b6afd7f7c9e8d6c3,0x726f6c655f616374696f6e,0x6d6f64696679,'','','0','','','','0','1'), ('140',0xb2e9bfb4bcc6bbaec8cfceaac1d0b1ed,0x7461736b,0x6c697374,'','','0','','','','0','1'), ('141',0xb2e9bfb4c4b3c8cecef1c9e8d6c3,0x7461736b,0x6d6f64696679,'','','0','','','','0','1'), ('142',0xd0deb8c4c4b3c8cecef1c9e8d6c3,0x7461736b,0x646f6d6f64696679,'','','0','','','','0','1'), ('143',0xc5fac1bfc4dac8ddc9f3bacb,0x76616c69646174696e67,0x646f,'','','0','','','','0','1'), ('144',0xbaf3cca8c9fab3c9d7a8cce2,0x67726f7570,0x6372656174655f67726f7570,'','','0','','','','0','1'), ('145',0xbaf3cca8cdc6bcf6d7a8cce2,0x67726f7570,0x7265636f6d6d656e64,'','','0','','','','0','1'), ('146',0xc5fac1bfd7a8cce2b7d6c0e0,0x67726f7570,0x646f62617463685f636c617373,'','','0','','','','0','1'), ('147',0xbaf3cca8c9beb3fdbbb0cce2,0x67726f75705f746872656164,0x64656c657465,'','','0','','','','0','1'), ('148',0xc7b0cca8c9beb3fdcdbcc6ac,0x696d616765,0x64656c657465,'','','0','','','','0','0'), ('149',0xc7b0cca8c9beb3fdcad3c6b5,0x766964656f,0x64656c657465,'','','0','','','','0','0'), ('150',0xb2e9bfb4bcc6bbaec8cecef16c6f67,0x7461736b,0x6c6f675f6c697374,'','','0','','','','0','1'), ('151',0xc9beb3fdbcc6bbaec8cecef16c6f67,0x7461736b,0x6c6f675f64656c657465,'','','0','','','','0','1'), ('152',0xc9beb3fdb7d6c0e0,0x636c617373,0x64656c657465,'','','0','','','','0','1'), ('153',0xbfaac6f4b9d8b1d5b7d6c0e0,0x636c617373,0x73657474696e67,'','','0','','','','0','1'), ('154',0xc9e8d6c3534d5450,0x73657474696e67,0x646f5f6d6f646966795f736d7470,'','','0','','','','0','1'), ('155',0xbfaac6f4d1e9d6a4c2eb,0x73657474696e67,0x646f5f6d6f646966795f736563636f6465,'','','0','','','','0','1'), ('156',0xccedbcd3cdbcc6ac,0x696d616765,0x646f6164647c646f5f616464,'','','0','','','','0','0'), ('157',0xc5fac1bfccedbcd3d7a8cce2,0x67726f7570,0x646f6164645f6b6579776f7264,'','','0','','','','0','1'), ('158',0xc7e5bfd5bbbab4e6,0x6361636865,0x2a,'','','0','','','','0','1'), ('159',0xcfb5cdb3c9fdbcb6,0x75706772616465,0x2a,'','','0','','','','0','1'), ('160',0xc9beb3fdcdf8d5beb6afccac,0x66656564,0x64656c7c64656c657465,'','','0','','','','0','1'), ('161',0xc9e8d6c3baf3cca8bfecbdddb7bdcabd,0x73657474696e67,0x646f5f6d6f646966795f73686f7274637574,'','','0','','','','0','1'), ('162',0xc9e8d6c341694a756865b0e6c8a8,0x73657474696e67,0x646f5f6d6f646966795f636f70797269676874,'','','0','','','','0','1');

DROP TABLE IF EXISTS aijuhe_role_module;
CREATE TABLE `aijuhe_role_module` (
  `module` varchar(30) NOT NULL,
  `name` varchar(20) NOT NULL,
  UNIQUE KEY `module` (`module`)
) ENGINE=MyISAM;

INSERT INTO aijuhe_role_module VALUES  (0x67726f7570,0xd7a8cce2), (0x726f6c655f616374696f6e,0xb6afd7f7c8a8cfdeb9dcc0ed), (0x726f6c65,0xbdc7c9abc9e8d6c3), (0x6e61766967617465,0xb6a5b2bfb5bcbabdc9e8d6c3), (0x67726f75705f6661766f72697465,0xd7a8cce2cad5b2d8), (0x67726f75705f696e76697465,0xd7a8cce2d1fbc7eb), (0x67726f75705f706f7374,0xbbb0cce2bbd8b8b4), (0x67726f75705f6d656d626572,0xd7a8cce2bbe1d4b1), (0x67726f75705f746872656164,0xbbb0cce2), (0x6e657773,0xd7cad1b6), (0x766964656f,0xcad3c6b5), (0x6c6f67696e,0xb5c7c2bd), (0x696e646578,0xcad7d2b3), (0x696d616765,0xcdbcc6ac), (0x6d656d626572,0xbbe1d4b1), (0x73657474696e67,0xcfb5cdb3c9e8d6c3), (0x696e636f6d65,0xd5bec4dab9e3b8e6b9dcc0ed), (0x6c696e6b,0xd3d1c7e9c1b4bdd3c9e8d6c3), (0x7461736b,0xbcc6bbaec8cecef1), (0x726f6c655f6d6f64756c65,0xb6afd7f7c4a3bfe9c9e8d6c3), (0x6462,0xcafdbeddbfe2b9dcc0ed), (0x73686f77,0xbde7c3e6d3ebcfd4cabec9e8d6c3), (0x726f626f74,0xd6a9d6ebc5c0d0d0bcc7c2bc), (0x746167,0x544147b9dcc0ed), (0x6174746163686d656e74,0xbbb0cce2b8bdbcfec9e8d6c3), (0x636f6d6d656e74,0xc6c0c2dbb9a6c4dc), (0x636c617373,0xb7d6c0e0b9dcc0ed), (0x736561726368,0xd7eebdfccbd1cbf7b9dcc0ed), (0x76616c69646174696e67,0xc4dac8ddc9f3bacbc9e8d6c3), (0x7563656e746572,0x5563656e746572d5fbbacf), (0x61626f7574,0xb9d8d3daced2c3c7c9e8d6c3), (0x6361636865,0xbbbab4e6b9dcc0ed), (0x75706772616465,0xcfb5cdb3c9fdbcb6), (0x66656564,0xcdf8d5beb6afccac);



DROP TABLE IF EXISTS `aijuhe_sessions`;
CREATE TABLE `aijuhe_sessions` (
  `sid` char(6) NOT NULL default '',
  `ip1` tinyint(3) unsigned NOT NULL default '0',
  `ip2` tinyint(3) unsigned NOT NULL default '0',
  `ip3` tinyint(3) unsigned NOT NULL default '0',
  `ip4` tinyint(3) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default '',
  `groupid` smallint(6) unsigned NOT NULL default '0',
  `styleid` smallint(6) unsigned NOT NULL default '0',
  `invisible` tinyint(1) NOT NULL default '0',
  `action` tinyint(1) unsigned NOT NULL default '0',
  `lastactivity` int(10) unsigned NOT NULL default '0',
  `lastolupdate` int(10) unsigned NOT NULL default '0',
  `pageviews` smallint(6) unsigned NOT NULL default '0',
  `seccode` mediumint(6) unsigned NOT NULL default '0',
  `fid` smallint(6) unsigned NOT NULL default '0',
  `tid` mediumint(8) unsigned NOT NULL default '0',
  `bloguid` mediumint(8) unsigned NOT NULL default '0',
  UNIQUE KEY `sid` (`sid`),
  KEY `uid` (`uid`),
  KEY `bloguid` (`bloguid`)
) ENGINE=MEMORY MAX_ROWS=1;


DROP TABLE IF EXISTS `aijuhe_tag`;
CREATE TABLE `aijuhe_tag` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(15) NOT NULL default '',
  `pinyin` char(50) NOT NULL default '',
  `py` char(15) NOT NULL default '',
  `user_id` mediumint(8) unsigned NOT NULL default '0',
  `username` char(15) NOT NULL default '',
  `dateline` int(10) unsigned NOT NULL default '0',
  `last_post` int(10) unsigned NOT NULL default '0',
  `total_count` int(10) unsigned NOT NULL default '0',
  `user_count` mediumint(8) unsigned NOT NULL default '0',
  `news_count` mediumint(8) unsigned NOT NULL default '0',
  `group_count` mediumint(8) unsigned NOT NULL default '0',
  `thread_count` mediumint(8) unsigned NOT NULL default '0',
  `test_count` mediumint(8) unsigned NOT NULL default '0',
  `group_thread_count` mediumint(8) unsigned NOT NULL default '0',
  `video_count` mediumint(8) unsigned NOT NULL default '0',
  `image_count` mediumint(8) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `pinyin` (`pinyin`),
  KEY `total_count` (`total_count`),
  KEY `last_post` (`last_post`),
  KEY `py` (`py`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_task`;
CREATE TABLE `aijuhe_task` (
  `id` smallint(6) unsigned NOT NULL auto_increment,
  `available` tinyint(1) NOT NULL default '0',
  `type` enum('user','system') NOT NULL default 'user',
  `name` char(50) NOT NULL default '',
  `filename` char(50) NOT NULL default '',
  `lastrun` int(10) unsigned NOT NULL default '0',
  `nextrun` int(10) unsigned NOT NULL default '0',
  `weekday` tinyint(1) NOT NULL default '0',
  `day` tinyint(2) NOT NULL default '0',
  `hour` tinyint(2) NOT NULL default '0',
  `minute` char(36) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `nextrun` (`available`,`nextrun`)
) ENGINE=MyISAM ;

INSERT INTO `aijuhe_task` VALUES 
(8, 1, 'system', 'ר', 'create_group.task.php', 1198996356, 1198998000, -1, -1, -1, '30');
insert into `aijuhe_task` values 
(10,0, 'system', 'ר', 'update_group.task.php', 1198996356, 1198998000, -1, -1, -1, '45');

DROP TABLE IF EXISTS `aijuhe_task_log`;
CREATE TABLE `aijuhe_task_log` (
  `id` int(10) NOT NULL auto_increment,
  `task_id` int(10) unsigned NOT NULL default '0',
  `exec_time` float unsigned NOT NULL default '0',
  `message` text NOT NULL,
  `error` int(10) NOT NULL default '0',
  `dateline` int(10) NOT NULL default '0',
  `ip` varchar(16) NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `agent` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`),
  KEY `task_id` (`task_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_thread_tag`;
CREATE TABLE `aijuhe_thread_tag` (
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `tag_id` mediumint(8) unsigned NOT NULL auto_increment,
  `count` smallint(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`item_id`,`tag_id`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_validate`;
CREATE TABLE `aijuhe_validate` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `item` varchar(20) NOT NULL default '',
  `item_id` int(10) unsigned NOT NULL default '0',
  `item_table` varchar(30) NOT NULL default '',
  `item_table_operation` enum('insert','update') NOT NULL default 'update',
  `item_sql` text,
  `php_code` text,
  `request_uid` int(10) unsigned NOT NULL default '0',
  `request_username` varchar(15) NOT NULL default '',
  `request_reason` text,
  `request_time` int(10) unsigned NOT NULL default '0',
  `validate_result` tinyint(1) unsigned NOT NULL default '0',
  `validate_result_describe` text NOT NULL,
  `validate_uid` int(10) unsigned NOT NULL default '0',
  `validate_username` varchar(15) NOT NULL default '',
  `validate_time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `item` (`item_id`,`item_table`)
) ENGINE=MyISAM;


DROP TABLE IF EXISTS `aijuhe_video`;
CREATE TABLE `aijuhe_video` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `item` varchar(30) NOT NULL default '0',
  `item_id` int(10) unsigned NOT NULL default '0',
  `class_id` int(10) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
`flash_host` varchar(50) NOT NULL,                             
`flash_var` varchar(50) NOT NULL,                              
`flash_addr` varchar(200) NOT NULL,                            
`flash_read_time` int(10) NOT NULL,                            
`last_visit_time` int(10) NOT NULL, 
`file` varchar(100) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `description` text NOT NULL,
  `thumb` varchar(100) NOT NULL default '',
  `remote` tinyint(1) unsigned NOT NULL default '0',
  `view_count` int(10) unsigned NOT NULL default '0',
  `use_count` smallint(5) unsigned NOT NULL default '1',
  `dateline` int(10) unsigned NOT NULL default '0',
  `filename` varchar(100) NOT NULL default '',
  `filetype` varchar(50) NOT NULL default '',
  `filesize` int(10) unsigned NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `comment_count` int(10) unsigned NOT NULL default '0',
  `last_comment` int(10) unsigned NOT NULL default '0',
  `width` smallint(6) unsigned NOT NULL default '0',
  `height` smallint(6) unsigned NOT NULL default '0',
  `hash` varchar(32) NOT NULL default '',
  `show_error_count` smallint(5) unsigned NOT NULL default '0',
  `from` varchar(100) NOT NULL default '',
  `tag` char(255) NOT NULL default '',                           
  `tag_count` smallint(4) unsigned NOT NULL default '0',   
  PRIMARY KEY  (`id`),
  KEY `class_id` (`class_id`),
  KEY `uid` (`uid`),
  KEY `view_count` (`view_count`),
  KEY `item` (`item`,`item_id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_video_comment`;
CREATE TABLE `aijuhe_video_comment` (                    
                        `id` int(10) unsigned NOT NULL auto_increment,         
                        `item_id` mediumint(8) unsigned NOT NULL default '0',  
                        `uid` int(10) unsigned NOT NULL default '0',           
                        `username` char(15) NOT NULL default '',               
                        `subject` varchar(255) NOT NULL default '',            
                        `content` text NOT NULL,                               
                        `dateline` int(10) unsigned NOT NULL default '0',      
                        `view_count` int(10) unsigned NOT NULL default '0',    
                        `ip` varchar(15) NOT NULL default '',                  
                        PRIMARY KEY  (`id`),                                   
                        KEY `item_id` (`item_id`,`uid`)                        
                      ) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_video_keyword`;
CREATE TABLE `aijuhe_video_keyword` (
  `keyword` varchar(100) NOT NULL default '',
  `video_count` int(10) unsigned NOT NULL default '0',
  `search_times` int(10) unsigned NOT NULL default '0',
  `page_views` int(10) unsigned NOT NULL default '0',
  `last_search` int(10) unsigned NOT NULL default '0',
  `cache_time` int(10) unsigned NOT NULL default '0',
  `video_ids` text NOT NULL,
  PRIMARY KEY  (`keyword`),
  KEY `page_views` (`page_views`),
  KEY `search_times` (`search_times`),
  KEY `last_search` (`last_search`),
  KEY `image_count` (`video_count`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_cache`;
CREATE TABLE `aijuhe_cache` (                         
 `key` int(10) unsigned NOT NULL default '0',         
 `name` varchar(255) NOT NULL,                        
 `data` mediumtext,                                   
 `cache_time` int(10) unsigned NOT NULL default '0',  
 PRIMARY KEY  (`key`)                                 
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_search_cache`;
CREATE TABLE `aijuhe_search_cache` (                               
                       `id` int(10) unsigned NOT NULL auto_increment,                   
                       `item` varchar(100) NOT NULL,                                    
                       `keyword` varchar(100) NOT NULL,                                 
                       `extra_condition` varchar(100) NOT NULL,                         
                       `item_count` int(10) unsigned NOT NULL default '0',              
                       `item_ids` text NOT NULL,                                        
                       `search_times` int(10) unsigned NOT NULL default '0',            
                       `last_search` int(10) unsigned NOT NULL default '0',             
                       `cache_time` int(10) unsigned NOT NULL default '0',              
                       `show` tinyint(1) NOT NULL default '-1',                         
                       PRIMARY KEY  (`id`),                                             
                       UNIQUE KEY `item-keyword` (`item`,`keyword`,`extra_condition`),  
                       KEY `search_times` (`search_times`),                             
                       KEY `last_search` (`last_search`)                                
                     ) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_about`;
CREATE TABLE `aijuhe_about` (                         
                `id` int(10) unsigned NOT NULL auto_increment,      
                `class_id` smallint(4) NOT NULL,                     
                `name` varchar(255) default NULL,                   
                `introduce` text,                                   
                `order` int(10) unsigned NOT NULL default '0',      
                 `display_in_footer` tinyint(1) NOT NULL,             
               PRIMARY KEY  (`id`)                                 
              ) ENGINE=MyISAM;
              
DROP TABLE IF EXISTS `aijuhe_about_class`;
CREATE TABLE `aijuhe_about_class` (                    
      `id` smallint(4) unsigned NOT NULL auto_increment,   
      `name` char(30) NOT NULL,                            
      `path` char(30) NOT NULL,                            
      `child_count` smallint(4) unsigned NOT NULL,         
      `display_order` smallint(4) unsigned NOT NULL,       
      PRIMARY KEY  (`id`),                                 
      KEY `path` (`path`)                                  
    ) ENGINE=MyISAMk;

DROP TABLE IF EXISTS `aijuhe_validating`;
CREATE TABLE `aijuhe_validating` (                     
		     `id` int(10) NOT NULL auto_increment,                
                     `dateline` int(10) NOT NULL default '0',                         
                     `uid` mediumint(8) NOT NULL default '0',                         
                     `username` char(15) NOT NULL default '',                        
                     `user_ip` char(15) NOT NULL default '',                         
                     `title` char(100) NOT NULL default '',                          
                     `body` text NOT NULL default '',                                
                     `data` text NOT NULL default '',                                
                     `remark` char(255) NOT NULL default '',                         
                     `type` char(15) NOT NULL default '',                            
                     PRIMARY KEY  (`id`)
                   ) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_notice`;
CREATE TABLE `aijuhe_notice` (                            
                 `id` mediumint(8) unsigned NOT NULL auto_increment,     
                 `uid` mediumint(8) unsigned NOT NULL default '0',       
                 `type` varchar(20) NOT NULL default '',                 
                 `new` tinyint(1) NOT NULL default '0',                  
                 `authorid` mediumint(8) unsigned NOT NULL default '0',  
                 `author` varchar(15) NOT NULL default '',               
                 `note` text NOT NULL,                                   
                 `dateline` int(10) unsigned NOT NULL default '0',       
                 PRIMARY KEY  (`id`),                                    
                 KEY `uid` (`uid`,`dateline`)                            
               ) ENGINE=MyISAM;

DROP TABLE IF EXISTS `aijuhe_feed`;
CREATE TABLE `aijuhe_feed` (                           
               `id` mediumint(8) unsigned NOT NULL auto_increment,  
               `appid` smallint(6) unsigned NOT NULL default '0',   
               `icon` varchar(30) NOT NULL default '',              
               `uid` mediumint(8) unsigned NOT NULL default '0',    
               `username` varchar(15) NOT NULL default '',          
               `dateline` int(10) unsigned NOT NULL default '0',    
               `friend` tinyint(1) NOT NULL default '0',            
               `hash_template` varchar(32) NOT NULL default '',     
               `hash_data` varchar(32) NOT NULL default '',         
               `title_template` text NOT NULL,                      
               `title_data` text NOT NULL,                          
               `body_template` text NOT NULL,                       
               `body_data` text NOT NULL,                           
               `body_general` text NOT NULL,                        
               `image_1` varchar(255) NOT NULL default '',          
               `image_1_link` varchar(255) NOT NULL default '',     
               `image_2` varchar(255) NOT NULL default '',          
               `image_2_link` varchar(255) NOT NULL default '',     
               `image_3` varchar(255) NOT NULL default '',          
               `image_3_link` varchar(255) NOT NULL default '',     
               `image_4` varchar(255) NOT NULL default '',          
               `image_4_link` varchar(255) NOT NULL default '',     
               `target_ids` text NOT NULL,                          
               PRIMARY KEY  (`id`),                                 
               KEY `uid` (`uid`,`dateline`),                        
               KEY `dateline` (`dateline`),                         
               KEY `friend` (`friend`,`dateline`)                   
             ) ENGINE=MyISAM;