<?php
/*
	file:	/libraries/compiler.class.php
	modify:	2009/08/29 - 2010/04/05
*/

class compiler
{
	private $_current_line_no;
	private $_template_stack= array();

	function _Make_CompileTemplate( &$TemplateText )
	{
		$TemplateText = preg_replace( "/<\?(.*?)\?>/", "<!?\\1?!>", $TemplateText );
		preg_match_all( "/\{.+?\}/", $TemplateText, $_Match );
		$tags_blocks = $_Match[0];
		$text_blocks = preg_split( "/\{.+?\}/", $TemplateText );

		$CompiledCode = $text_blocks[ 0 ];
		for ( $i= 0; $i< count( $tags_blocks ); $i++ )
		{
			$this->_current_line_no += substr_count( $text_blocks[ $i ], "\n" );
			$CompiledCode .= $this->_Analysis_TemplateLabel( $tags_blocks[ $i ], $text_blocks[ $i+ 1 ] );
			$this->_current_line_no += substr_count( $tags_blocks[ $i ], "\n" );
		}

		if ( count ( $this->_template_stack ) > 0 ) {
			list ( $_open_tag, $_line_no ) = end ( $this->_template_stack );
			raysn_clewbox ( language ( "unclosed tag", array( '@tagname'=> $_open_tag, '@line'=> $_line_no ) ) );
		}

		return preg_replace( "/\[(\w+)\.([\w]+)\s?\/\]/", "<?php echo \$make->var['\\1']['\\2'];?>", $CompiledCode );
	}

	private function _Analysis_TemplateLabel( &$TagBlock, &$TextBlock )
	{
		if ( ! preg_match("/^\{(?:(\/)?([a-z]+:[a-z]+)(?:\s(.*?))?(?:\s?(\/))?)\}$/x", $TagBlock, $_Match ) ) {
			return $TagBlock . $TextBlock;
		}
		else {
			$label_name= $_Match[2];
		}
		
		if ( $_Match[1] == NULL )
		{
			if ( ! isset ( $_Match[3] ) ) {
				$_Match[3] = NULL;
			}
			array_push( $this->_template_stack, array( $label_name, $this->_current_line_no ) );
			if ( empty ( $_Match[4] ) ) {
				return $this->_Parse_DataBlock( $label_name, $_Match[3], $TextBlock );
			}
			else {
				if ( $return = $this->_Parse_DataQuote( $label_name, $_Match[3] ) . $TextBlock ) {
					array_pop( $this->_template_stack );
					return $return;
				}
				else {
					return false;
				}
			}
		}
		else
		{
			if ( isset ( $_Match[3] )
				|| isset ( $_Match[4] ) ) {
				raysn_clewbox ( language ( "error close tag", array( '@tagname'=> $label_name, '@line'=> $this->_current_line_no ) ) );
			}

			list( $_open_tag, $_line_no ) = array_pop( $this->_template_stack );
			if ( $_open_tag == $label_name ) {
				list ( $_open_tag, $_line_no ) = end( $this->_template_stack );
				return "<?php } unset(\$make->var['{$label_name}']);?>" . $this->_Parse_Variable( $_open_tag, $TextBlock );
			}
			else {
				raysn_clewbox ( language ( "mismatched tag", array( '@tag1'=> $label_name, '@tag2'=> $_open_tag, '@line'=> $this->_current_line_no ) ) );
			}
		}
	}
	
	private function _Parse_DataBlock( $label_name, $Parameter, &$TextBlock )
	{
		return  "<?php foreach(\$make->_Get_Data('$label_name', array(".$this->_Parse_Factor( $Parameter ).")) as \$make->var['{$label_name}']){?>"
			. $this->_Parse_Variable( $label_name, $TextBlock );
	}

	private function _Parse_DataQuote( $label_name, $Parameter )
	{
		return "<?php \$make->_Get_Data('$label_name', array(".$this->_Parse_Factor( $Parameter )."));?>";
	}

	private function _Parse_Variable( $label_name, &$TextBlock )
	{
		return preg_replace("/\[([a-z]+)\s?\/\]/", "<?php echo \$make->var['{$label_name}']['\\1'];?>", $TextBlock);
	}

	private function _Parse_Factor( $FactorCode )
	{
		if ( empty ( $FactorCode ) ) {
			return NULL;
		}

		$Factors= explode( ' ', trim( $FactorCode ) );
		$FactorsArray= array();

		foreach ( $Factors as $Factor ) {
			if ( preg_match( "/([a-z]+)=\"([\$@\w\-]+(?:,\w+)*|(?:\w+:[\w\/\-:]+;)+)\"/", $Factor, $_Match ) ) {
				$FactorsArray[]= "'{$_Match[1]}'=>'{$_Match[2]}'";
			}
			else {
				list( $_open_tag, $_line_no ) = array_pop( $this->_template_stack );
				raysn_clewbox ( language ( "tag error", array( '@tagname'=> $_open_tag, '@line'=> $_line_no ) ) );
			}
		}

		return implode( ',', $FactorsArray );
	}
}

