﻿/*
 * CKFinder
 */

SetupCKEditor = function( editorObj, basePath )
{
	if ( editorObj === null )
	{
		for ( var editorName in CKEDITOR.instances )
			CKFinder.SetupCKEditor( CKEDITOR.instances[editorName], basePath ) ;

		CKEDITOR.on( 'instanceCreated', function(e) {
			CKFinder.SetupCKEditor( e.editor, basePath ) ;
		});

		return;
	}

	if ( window.screen.width > 800
		&& window.screen.height > 600 ) {
		editorObj.config.filebrowserWindowWidth = 930 ;
		editorObj.config.filebrowserWindowHeight = 740 ;
	}
	else {
		editorObj.config.filebrowserWindowWidth = window.screen.width ;
		editorObj.config.filebrowserWindowHeight = window.screen.height ;
	}

	editorObj.config.filebrowserBrowseUrl = basePath + 'attachment/list/files' ;
	editorObj.config.filebrowserImageBrowseUrl = basePath + 'attachment/list/image' ;
	editorObj.config.filebrowserFlashBrowseUrl = basePath + 'attachment/list/flash' ;

	editorObj.config.filebrowserUploadUrl = basePath + "attachment/upload/files?confirm=ok" ;
	editorObj.config.filebrowserImageUploadUrl = basePath + "attachment/upload/image?confirm=ok" ;
	editorObj.config.filebrowserFlashUploadUrl = basePath + "attachment/upload/flash?confirm=ok" ;
}
