<?php
/*
	file:	/libraries/file.class.php
	modify:	2009/01/22 - 2010/03/16
*/

class file
{
	private $Filepath;

	function path( $Filepath = NULL )
	{
		if ( isset ( $Filepath ) ) {
			$this->Filepath= $Filepath;
			return $this;
		}
		else {
			return $this->Filepath;
		}
	}
	
	function dirpath( )
	{
		return dirname( $this->Filepath ) . '/';
	}

	function &ls( $filetype = NULL )
	{
		$Filelist['file'] = $Filelist['dir'] = array( );

		if ( $this->is_dir( ) ) {
			foreach ( scandir ( $this->Filepath ) as $filename ) {
				$filepath= $this->Filepath . $filename;
				if ( @is_file( $filepath )
					&& ! preg_match( "/~$/", $filename ) ) {
					$Filelist['file'][] = $filename;
				}
				elseif ( @is_dir( $filepath )
					&& ! preg_match( "/^\.$|^\.\.$/", $filename ) ) {
					$Filelist['dir'][] = $filename;
				}
			}
		}

		if ( ! empty ( $filetype )
			&& in_array( $filetype, array( 'file', 'dir' ) ) ) {
			return $Filelist[ $filetype ];
		}
		else
			return $Filelist;
	}
	
	function dirs( )
	{
		return $this->ls( 'dir' );
	}
	
	function files( )
	{
		return $this->ls( 'file' );
	}
	
	function read( )
	{
		if ( $this->is_file( )
			&& $this->is_readable( ) )
			return file_get_contents( $this->Filepath );
		else
			return 0;
	}
	
	function make( $text= '' )
	{
		if ( $this->is_file( )
			&& ! $this->is_writeable( ) ) {
			return 0;
		} elseif ( ! $this->file_exists( )
			&& ! $this->is_dirwriteable( ) ) {
			return 0;
		} else {
			return file_put_contents( $this->Filepath, $text );
		}
	}

	function mkdir( )
	{
		if ( ! $this->file_exists( )
			&& $this->is_dirwriteable( ) )
			return mkdir( $this->Filepath, 0755 );
		else
			return 0;
	}

	function rename( $newname )
	{
		if ( $this->file_exists( )
			&& $this->is_dirwriteable( )
			&& ! file_exists( $this->dirpath( ) . $newname ) )
			return rename( $this->path(), $this->dirpath( ) . $newname );
		else
			return 0;
	}

	function remove( )
	{
		if ( $this->file_exists( )
			&& $this->is_writeable( )
			&& $this->is_dirwriteable( ) )
		{
			if ( dirname( $this->Filepath ) == './includes/cache' ) {
				if ( $this->is_dir( ) ) {
					return $this->rmdir( );
				}
				else {
					return $this->delete( );
				}
			} else {
				$filepath = './includes/cache/trash' . preg_replace( "/\.\/|\//i", '-', $this->Filepath );
				if ( file_exists ( $filepath ) ) {
					$filepath .= '-' . date( 'YmdHis' );
				}

				return rename( $this->Filepath, $filepath );
			}
		}
	}
	
	function delete( )
	{
		if ( $this->is_file( )
			&& $this->is_dirwriteable( ) )
			return unlink( $this->Filepath );
		else
			return 0;
	}
	
	function size( )
	{
		require_once './libraries/string.inc';
		return _Make_FileSize( filesize( $this->Filepath ) );
	}

	function mtime( )
	{
		return filemtime( $this->Filepath );
	}

	function _Parse_Inifile( $IsParseArray= true )
	{
		static $Inifiles;
		if ( empty ( $Inifiles[ $this->Filepath ] )
			&& $this->is_file( ) ) {
			$Inifiles[ $this->Filepath ] = parse_ini_file( $this->Filepath, $IsParseArray );
		}
		
		if ( ! empty ( $Inifiles[ $this->Filepath ] ) ) {
			return $Inifiles[ $this->Filepath ];
		}
		else {
			return false;
		}
	}

	function _Check_FileType( )
	{
		if ( $this->is_file( ) ) {
			require_once './libraries/string.inc';
			return ExtName( $this->Filepath );
		}
		else
			return 0;
	}

	function is_text( )
	{
		return $this->is_file( ) && in_array ( $this->_Check_FileType( ), array( 'php', 'htm', 'css', 'js', 'txt', 'ini' ) );
	}
	
	function is_image( )
	{
		return $this->is_file( ) && in_array ( $this->_Check_FileType( ), array( 'jpg', 'jpeg', 'gif', 'png', 'bmp' ) );
	}

	function is_file( )
	{	
		return @is_file ( $this->Filepath );
	}

	function is_dir( )
	{	
		return @is_dir ( $this->Filepath );
	}

	function is_readable( )
	{	
		return @is_readable ( $this->Filepath );
	}

	function is_writeable( )
	{	
		return @is_writeable ( $this->Filepath );
	}

	function is_dirwriteable( )
	{	
		return @is_writeable ( dirname ( $this->Filepath ) );
	}

	function file_exists( )
	{
		return @file_exists ( $this->Filepath );
	}
}
