<?php
/*
	file:	/libraries/frame.inc
	modify:	2009/01/19 - 2010/06/01
*/

define( 'CHARSET', 'utf-8' );
define( 'RAYSN_VERSION', '1.3' );

define( 'RAYSN_ACCESS_DENIED', 403 );
define( 'RAYSN_NOT_FOUND', 404 );
define( 'RAYSN_SITE_CLOSED', 405 );

define( 'WATCHDOG_EVENT', 1 );
define( 'WATCHDOG_ERROR', 3 );
define( 'DB_ERROR', 'a515ac9c2796ca0e23adbe92c68fc9fc' );
if ( ! defined( 'E_DEPRECATED' ) ) {
	define( 'E_DEPRECATED', 8192 );
}

require_once './libraries/path.inc';
require_once './libraries/session.inc';
require_once './includes/profile/settings.php';

date_default_timezone_set( $CONFIG['TIME_ZONE'] );
set_error_handler( 'raysn_error_handler' );


function variable_set( $name, $value )
{
	global $variables;

	$GLOBALS['OBJECT']['mysql']
		->replace( 'variables', array( 'name'=> $name, 'value'=> $value ) );

	$variables[ $name ] = $value;
}

function variable_get( $name, $default = NULL )
{
	global $variables;

	if ( ! isset ( $variables[ $name ] ) ) {
		if ( $variable = raysn_object( 'mysql' )
			->select_row( 'variables', array( 'where'=> "`name`= '$name'" ) ) ) {
			$variables[ $name ] = $variable[ 'value' ];
		} else {
			$GLOBALS['OBJECT']['mysql']->insert( 'variables', array( 'name'=> $name, 'value'=> $default ) );
		}
	}

	return isset ( $variables[ $name ] ) ? $variables[ $name ] : $default;
}

function translate( $string, $args= array(), $module= NULL )
{
	global $languages;

	if ( ! isset ( $languages[ $string ] ) ) {
		if ( empty ( $module ) ) {
			$module = $GLOBALS['Routers']['Module'];
		}
		$languages = @parse_ini_file( './modules/' . $module . '/language/translate.ini', TRUE );
	}

	if ( isset ( $languages[ $string ] ) ) {
		$string = $languages[ $string ];
	}
	if ( empty ( $args ) )
		return $string;
	else
		return @strtr( $string, $args );
}

function language( $string, $args= array() )
{
	global $languages;
	
	if ( ! isset ( $languages[ $string ] ) ) {
		$languages= require "./libraries/languages.php";
	}
	if ( ! empty ( $languages[ $string ] ) ) {
		$string = $languages[ $string ];
	}

	return empty ( $args )? $string: strtr( $string, $args );
}

function message_set( $string, $args= array() )
{
	global $msg_list;
	$msg_list[] = translate( $string, $args );
	return array( );
}

function message_check( )
{
	global $msg_list;
	return is_array ( $msg_list ) && ! empty ( $msg_list );
}

function show_messages( )
{
	global $msg_list;
	$messages = '';

	if ( ! empty ( $msg_list )
		&& is_array ( $msg_list ) ) {
		foreach ( $msg_list as $message ) {
			$messages .= '<span class="leaf">' . $message . '</span>';
		}
		return '<div id="raysn_clewbox">' . $messages . '</div>';
	}
}

function filter_array( &$Array )
{
	if ( is_array( $Array ) ) {
		foreach ( $Array as $key => $data ) {
			$Array[ $key ] = filter_array( $data );
		}
	} else {
		$Array = addslashes( $Array );
	}
	
	return $Array;
}

function raysn_object( $ClassName, $Parameters= array() )
{
	global $OBJECT;
	if ( ! isset ( $OBJECT[ $ClassName ] ) )
	{
		$libraryfilePath= "./libraries/$ClassName.class.php";
		if ( ! is_file( $libraryfilePath ) ) {
			watchdog( 'librariy not exist', array( '@librariy'=> $libraryfilePath ), WATCHDOG_ERROR );
			raysn_clewbox ( language( 'librariy not exist', array( '@librariy'=> $libraryfilePath ) ) );
		}

		require_once $libraryfilePath;
		if ( class_exists( $ClassName ) ) {
			$OBJECT[ $ClassName ]= new $ClassName( $Parameters );
		}
		else {
			watchdog( 'class not exist', array( '@class'=> $ClassName ), WATCHDOG_ERROR );
			raysn_clewbox ( language( 'class not exist', array( '@class'=> $ClassName ) ) );
		}
	}

	return $OBJECT[ $ClassName ];
}

function raysn_load_view( $ViewData )
{
	if ( isset( $GLOBALS['ViewAreadyLoad'] )
		&& $GLOBALS['ViewAreadyLoad']== TRUE ) {
		watchdog( 'view load error', array( '@Datas'=> print_r( $ViewData, TRUE ) ), WATCHDOG_ERROR );
		return FALSE;
	}

	if ( isset ( $GLOBALS['Parameters']['ajax'] ) ) {

		header( "Cache-Control: no-cache" );
		header( "Content-type: application/json; charset=" . CHARSET );
		exit( json_encode( $ViewData ) );
	}

	global $Routers, $Parameters;
	if ( is_array ( $ViewData ) ) {
		@extract( $ViewData, EXTR_SKIP );
	}

	if ( empty ( $ViewName ) ) {
		if ( empty ( $ViewPath ) ) {
			$ViewPath= './modules/' . $Routers['Module'] . '/view/' . $Routers['action'] . '.htm';
		}
	}
	else {
		$ViewPath= './modules/' . str_replace( '_', '/view/', strtolower( $ViewName ) ) . '.htm';
	}

	if ( ! is_file( $ViewPath ) ) {
		watchdog( 'view file lost', array( '@view'=> $ViewPath ), WATCHDOG_ERROR );
		exit ( "<br /><b>view file lost</b>:  " . $ViewPath );
	}

	$GLOBALS['ViewAreadyLoad']= TRUE;
	@header( "Cache-Control: private" );
	@header( "Content-type: text/html; charset=" . CHARSET );
	require_once $ViewPath; exit;
}

function watchdog( $message, $variables= array(), $type= WATCHDOG_EVENT )
{
	return raysn_object( 'mysql' )->insert( 'watchdog', array(
			'uid'=> raysn_get_user_id( ),
			'type'=> $type,
			'module'=> $GLOBALS['Routers']['Module'],
			'message'=> $message,
			'variables'=> addslashes( serialize( $variables ) ),
			'location'=> $_SERVER['REMOTE_ADDR'],
			'referer'=> url( trim ( $_SERVER['PATH_INFO'], '/' ), $_GET ),
			'timestamp'=> time( )
		) );
}

function raysn_goto_page( $JumpPage )
{
	Header( "Location: $JumpPage" ); exit;
}

function raysn_clewbox( $Message, $Jumplink= '' )
{
	raysn_load_view ( array(
		'ViewPath'=> './styles/themes/clewbox.htm',
		'Message'=> '<div id="raysn_clewbox"><span>' . $Message . '</span></div>',
		'Jumplink'=> $Jumplink
	) );
}

function raysn_error_handler( $errno, $message, $filename, $line, $context )
{
	if ( error_reporting() == 0 ) {
		return;
	}

	if ( $errno & ( E_ALL ^ E_DEPRECATED ^ E_NOTICE ) )
	{
		$types = array(
			1 => 'error', 2 => 'warning', 4 => 'parse error', 8 => 'notice',
			16 => 'core error', 32 => 'core warning',
			64 => 'compile error', 128 => 'compile warning',
			256 => 'user error', 512 => 'user warning', 1024 => 'user notice',
			2048 => 'strict warning', 4096 => 'recoverable fatal error'
		);

		if ( isset ( $context[ DB_ERROR ] ) ) {
			$backtrace = array_reverse( debug_backtrace() );
			$query_functions = array( 'db_query', 'pager_query', 'db_query_range', 'db_query_temporary', 'update_sql' );

			foreach ( $backtrace as $index => $function ) {
				if ( in_array ( $function['function'], $query_functions ) ) {
					$line = $backtrace[$index]['line'];
					$filename = $backtrace[$index]['file'];
					break;
				}
			}
		}

		$entry = array(
			'@file' => './' . str_replace( str_replace( 'index.php', '', $_SERVER['SCRIPT_FILENAME'] ), '', $filename ),
			'@line'=> $line,
			'@type'=> $types[ $errno ],
			'@message'=> $message
		);

		watchdog( 'error reporting', $entry, WATCHDOG_ERROR );
		if ( raysn_get_user_id() == 1 ) {
			raysn_clewbox( language( 'error reporting', $entry ) );
		}
	}
}

function raysn_check_timestamp( )
{
	static $timestamp;
	if ( empty ( $timestamp ) ) {
		$timestamp = filemtime( './libraries/session.inc' );
	}
	return $timestamp;
}

function raysn_check_installed( )
{
	if ( ! empty ( $GLOBALS['CONFIG']['DB_URL'] )
		&& raysn_object( 'mysql_table' )->_check_table_exist( 'variables' ) ) {
		return TRUE;
	}
}

function raysn_not_found( )
{
	header('HTTP/1.1 404 Not Found');
	require './styles/themes/not-found.htm';
}

function raysn_access_denied( )
{
	if ( raysn_get_user_id( ) ) {
		raysn_clewbox ( language( 'no permission' ) );
	}
	raysn_goto_page( url( 'user/login', array( 'refer'=> $_SERVER['PATH_INFO'] ) ) );
}

function raysn_site_closed( )
{
	require './styles/themes/site-closed.htm';
}
