<?php
/*
	file:	/libraries/image.class.php
	modify:	2009/04/29 - 2010/03/19
*/

define( 'ZOOM_MAX_WIDTH', 600 );
define( 'ZOOM_MAX_HEIGHT', 600 );

define( 'THUMB_MAX_WIDTH', 200 );
define( 'THUMB_MAX_HEIGHT', 200 );

define( 'FONT_PATH', './styles/themes/images/font.ttf' );
define( 'PNG_IMAGE_PATH', './styles/images/watermark.png' );

class image
{
	var	$ImageWidth;
	var	$ImageHeight;
	var	$ZoomWidth;
	var	$ZoomHeight;
	
	private $ImagePath;
	private $ImageType;
	private $ImageIdentifier;

	private $AllowdType = array(
			"jpg"	=> array("create"=>"ImageCreateFromJpeg", "output"=>"imagejpeg"),
			"gif"	=> array("create"=>"ImageCreateFromGIF" , "output"=>"imagegif"),
			"png"	=> array("create"=>"ImageCreateFromPNG" , "output"=>"imagepng")
		);

	function _Set_Imageinfo( $ImagePath )
	{
		if ( ! raysn_object( 'file' )
			->path( $ImagePath )->is_image( ) ) {
			return FALSE;
		}
		else
		{
			$PathInfo	= pathinfo( $ImagePath );
			$this->ImagePath= $ImagePath;
			$this->ImageType= strtolower( $PathInfo["extension"] );

			return array_key_exists( $this->ImageType, $this->AllowdType );
		}
	}

	function _Set_Zoom_Length( $MaxWidth, $MaxHeight )
	{
		if ( $this->ImageWidth > $MaxWidth
			|| $this->ImageHeight > $MaxHeight )
		{
			if ( $this->ImageWidth > $this->ImageHeight ) {
				$this->ZoomWidth= $MaxWidth;
				$this->ZoomHeight= round ( $this->ImageHeight * ( $MaxWidth / $this->ImageWidth ) );
			}
			elseif ( $this->ImageWidth < $this->ImageHeight ) {
				$this->ZoomWidth= round ( $this->ImageWidth * ( $MaxHeight / $this->ImageHeight ) );
				$this->ZoomHeight= $MaxHeight;
			}
			else {
				$this->ZoomWidth= $MaxWidth;
				$this->ZoomHeight= $MaxHeight;
			}
		
			return TRUE;
		}
		else {
			$this->ZoomWidth = $this->ImageWidth;
			$this->ZoomHeight = $this->ImageHeight;

			return FALSE;
		}
	}
	
	function _Zoom_Imagefile( )
	{
		$this->ImageIdentifier= @call_user_func( $this->AllowdType[ $this->ImageType ]['create'], $this->ImagePath );
		$this->ImageWidth= imagesx( $this->ImageIdentifier );
		$this->ImageHeight= imagesy( $this->ImageIdentifier );

		require_once './libraries/string.inc';
		$ZoomThumb = $this->_Set_Zoom_Length( THUMB_MAX_WIDTH, THUMB_MAX_HEIGHT );
		$this->_Make_Zoom_Imagefile( _Get_ThumbPath( $this->ImagePath ) );

		if ( $ZoomThumb ) {
			global $WaterMark;
			$WaterMark = unserialize( variable_get( 'Attachment_ImageWaterMark', serialize( array('Enabled'=> 0, 'Type'=> 1, 'Words'=> 'RAYSN.COM', 'FontSize'=> '18', 'FontColor'=> '255,255,255', 'Merge'=> 80, 'Position'=> 4) ) ) );
			$ZoomImage = $this->_Set_Zoom_Length( ZOOM_MAX_WIDTH, ZOOM_MAX_HEIGHT );

			if ( $ZoomImage || $WaterMark['Enabled'] ) {
				$this->_Make_Zoom_Imagefile( $this->ImagePath, $WaterMark['Enabled'] );
			}
		}

		imagedestroy( $this->ImageIdentifier );
		return TRUE;
	}
	
	function _Make_Zoom_Imagefile( $ImagePath, $WaterMarkEnabled= FALSE )
	{
		$ZoomIdentifier = imagecreatetruecolor( $this->ZoomWidth, $this->ZoomHeight );
		imagecopyresampled(
			$ZoomIdentifier,
			$this->ImageIdentifier,
			0, 0, 0, 0,
			$this->ZoomWidth, $this->ZoomHeight,
			$this->ImageWidth, $this->ImageHeight
		);

		if ( $WaterMarkEnabled )
		{
			global $WaterMark;
			switch ( $WaterMark['Type'] )
			{
				case 1 :
				if ( ! is_file( FONT_PATH ) ) {
					break;
				}
				$box = @imagettfbbox( $WaterMark['FontSize'], 0, FONT_PATH, $WaterMark['Words'] );
				$TextWidth = max( $box[2], $box[4] ) - min( $box[0], $box[6] );
				$TextHeight = max( $box[1], $box[3] ) - min( $box[5], $box[7] );

				switch ( $WaterMark['Position'] )
				{
					case 4 :
						$Positions['X']= $this->ZoomWidth- $TextWidth- 10;
						$Positions['Y']= $this->ZoomHeight- $TextHeight+ 5;
						break;
					case 3 :
						$Positions['X']= $this->ZoomWidth- $TextWidth- 10;
						$Positions['Y']= $TextHeight+ 10;
						break;
					case 2 :
						$Positions['X']= 10;
						$Positions['Y']= $this->ZoomHeight- $TextHeight+ 5;
						break;
					case 1 :
						$Positions['X']= 10;
						$Positions['Y']= $TextHeight+ 10;
						break;
					default :
						$Positions['X']= ( $this->ZoomWidth- $TextWidth )/ 2;
						$Positions['Y']= ( $this->ZoomHeight- $TextHeight )/ 2;
				}

				$ShadowColor = imagecolorallocate( $ZoomIdentifier, 100, 120, 100 );
				imagettftext( $ZoomIdentifier, $WaterMark['FontSize'], 0, $Positions['X']+ 1, $Positions['Y']+ 1, $ShadowColor, FONT_PATH, $WaterMark['Words'] );

				$FontRGB = explode( ',', $WaterMark['FontColor'] );
				$FontColor = imagecolorallocate( $ZoomIdentifier, $FontRGB[0], $FontRGB[1], $FontRGB[2] );
				@imagettftext( $ZoomIdentifier, $WaterMark['FontSize'], 0, $Positions['X'], $Positions['Y'], $FontColor, FONT_PATH, $WaterMark['Words'] );
				break;

				case 2 :
				if ( ! is_file( PNG_IMAGE_PATH ) ) {
					break;
				}
				$WaterMarkIdentifier = @ImageCreateFromPNG( PNG_IMAGE_PATH );
				list( $WaterMarkWidth, $WaterMarkHeight ) = @getImageSize( PNG_IMAGE_PATH );

				switch ( $WaterMark['Position'] )
				{
					case 4 :
						$Positions['X']= $this->ZoomWidth- $WaterMarkWidth- 10;
						$Positions['Y']= $this->ZoomHeight- $WaterMarkHeight- 5;
						break;
					case 3 :
						$Positions['X']= $this->ZoomWidth- $WaterMarkWidth- 10;
						$Positions['Y']= 10;
						break;
					case 2 :
						$Positions['X']= 10;
						$Positions['Y']= $this->ZoomHeight- $WaterMarkHeight- 5;
						break;
					case 1 :
						$Positions['X']= 10;
						$Positions['Y']= 10;
						break;
					default :
						$Positions['X']= ( $this->ZoomWidth- $WaterMarkWidth )/ 2;
						$Positions['Y']= ( $this->ZoomHeight- $WaterMarkHeight )/ 2;
				}

				$Transparent = imagecolorallocatealpha( $WaterMarkIdentifier, 0, 0, 0, 127 );
				imagefill( $WaterMarkIdentifier, 0, 0, $Transparent );
				imagecolortransparent( $WaterMarkIdentifier, $Transparent );
				imagecopymerge( $ZoomIdentifier, $WaterMarkIdentifier, $Positions['X'], $Positions['Y'], 0, 0, $WaterMarkWidth, $WaterMarkHeight, $WaterMark['Merge'] );
				break;
				default :
			}
		}

		if ( $this->ImageType == 'jpg' ) {
			@call_user_func( $this->AllowdType[ $this->ImageType ]['output'], $ZoomIdentifier, $ImagePath, variable_get( 'Attachment_image_ZoomQuality', '80' ) );
		}
		else {
			@call_user_func( $this->AllowdType[ $this->ImageType ]['output'], $ZoomIdentifier, $ImagePath );
		}

		imagedestroy( $ZoomIdentifier );
	}
}
