<?php
/*
	file:	/libraries/mail.class.php
	modify:	2010/02/23 - 2010/03/11
*/

class mail
{
	private $SmtpConnect;

	function __construct( )
	{
		if ( ! defined( 'CRLF' ) ) {
			define( 'CRLF', "\r\n" );
		}

		global $CONFIG;
		$this->host	= $CONFIG['MAIL_SMTPHOST'];
		$this->port	= $CONFIG['MAIL_SMTPPORT'];
		$this->auth	= $CONFIG['MAIL_AUTH'];
		$this->from	= $CONFIG['MAIL_ADDRESS'];
		$this->header	= 'From: =?utf-8?B?'.base64_encode($GLOBALS['SITE']['NAME'])."?= <{$GLOBALS['SITE']['EMAIL']}>". CRLF
			. "X-Priority: 3". CRLF
			. "X-Mailer: RAYSN WEB". CRLF
			. "MIME-Version: 1.0". CRLF
			. "Content-type: text/html; charset=utf-8". CRLF
			. "Content-Transfer-Encoding: base64". CRLF;
		$this->timeout	= 5;
	}

	function Connect( )
	{
		if ( ! $this->SmtpConnect = @fsockopen( $this->host, $this->port, $errno, $errstr, $this->timeout ) ) {
			watchdog( 'connect mail server failed', array( ), WATCHDOG_ERROR );
			return FALSE;
		}
	 	socket_set_blocking( $this->SmtpConnect, TRUE );
	
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( strpos( $SocketMessage, '220' ) != '0' ) {
			watchdog( 'connect mail server failed', array( ), WATCHDOG_ERROR );
			return FALSE;
		}
	
		fputs( $this->SmtpConnect, ( $this->auth ? 'EHLO' : 'HELO' ) . " RAYSN". CRLF );
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( substr( $SocketMessage, 0, 3 ) != 220
			&& substr( $SocketMessage, 0, 3 ) != 250 ) {
			watchdog( 'send mail error', array( '@message'=> $SocketMessage ), WATCHDOG_ERROR );
			return FALSE;
		}

		while( TRUE ) {
			if ( substr( $SocketMessage, 3, 1 ) != '-'
				|| empty( $SocketMessage ) ) {
	 			break;
	 		}
	 		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		}

		if ( $this->auth ) {
			return $this->Auth( );
		} else
			return TRUE;
	}
	
	function Auth( )
	{
		list( $Passport ) = explode( '@', $this->from );
		$Password = $GLOBALS['CONFIG']['MAIL_PASSWORD'];

		fputs( $this->SmtpConnect, "AUTH LOGIN". CRLF );
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( substr( $SocketMessage, 0, 3 ) != 334 ) {
			watchdog( 'send mail error', array( '@message'=> $SocketMessage ), WATCHDOG_ERROR );
			return FALSE;
		}
	
		fputs( $this->SmtpConnect, base64_encode( $Passport ) . CRLF );
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( substr( $SocketMessage, 0, 3 ) != 334 ) {
			watchdog( 'email passport error', array( ), WATCHDOG_ERROR );
			return FALSE;
		}

		fputs( $this->SmtpConnect, base64_encode( $Password ) . CRLF );
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( substr( $SocketMessage, 0, 3 ) != 235 ) {
			watchdog( 'email password error', array( ), WATCHDOG_ERROR );
			return FALSE;
		}

		return TRUE;
	}
	
	function Send( $MailTo, $MailPage, $DataArray )
	{
		fputs( $this->SmtpConnect, "MAIL FROM: <" . preg_replace( "/.*\<(.+?)\>.*/", "\\1", $this->from ) . ">". CRLF );
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( substr( $SocketMessage, 0, 3 ) != 250 ) {
			fputs( $this->SmtpConnect, "MAIL FROM: <" . preg_replace( "/.*\<(.+?)\>.*/", "\\1", $this->from ) . ">". CRLF );
			$SocketMessage = fgets( $this->SmtpConnect, 512 );
			if ( substr( $SocketMessage, 0, 3 ) != 250 ) {
				watchdog( 'send mail error', array( '@message'=> $SocketMessage ), WATCHDOG_ERROR );
				return FALSE;
			}
		}
	
		fputs( $this->SmtpConnect, "RCPT TO: <".preg_replace( "/.*\<(.+?)\>.*/", "\\1", $MailTo ).">". CRLF );
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( substr( $SocketMessage, 0, 3) != 250 ) {
			fputs( $this->SmtpConnect, "RCPT TO: <" . preg_replace( "/.*\<(.+?)\>.*/", "\\1", $MailTo ) . ">". CRLF );
			$SocketMessage = fgets( $this->SmtpConnect, 512 );
			if ( substr( $SocketMessage, 0, 3 ) != 250 ) {
				watchdog( 'send mail error', array( '@message'=> $SocketMessage ), WATCHDOG_ERROR );
				return FALSE;
			}
		}

		fputs( $this->SmtpConnect, "DATA". CRLF );
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( substr( $SocketMessage, 0, 3) != 354 ) {
			watchdog( 'send mail error', array( '@message'=> $SocketMessage ), WATCHDOG_ERROR );
			return FALSE;
		}
		$MailSubject = '=?'.CHARSET.'?B?'.base64_encode(preg_replace("/[\r|\n]/", '', translate($MailPage,'',$GLOBALS['Routers']['Module']))).'?=';
		$MailMessage = strtr( raysn_object( 'file' )->path( './styles/themes/mail-pages/'. $MailPage )->read(), $DataArray );
		$MailMessage = chunk_split(base64_encode(str_replace(CRLF.".", " ".CRLF."..", str_replace("\n", CRLF, str_replace("\r", "\n", str_replace(CRLF, "\n", str_replace("\n\r", "\r", $MailMessage)))))));

		$MailHeader = $this->header. "Message-ID: <" . gmdate( 'YmdHs' ) . '.' . substr( md5( $MailMessage . microtime() ), 0, 6 ) . rand( 100000, 999999 ) . '@' . $_SERVER['HTTP_HOST'] . ">";

		fputs( $this->SmtpConnect, "Date: " . gmdate( 'r' ) . CRLF
			. "To: " . $MailTo . CRLF
			. "Subject: " . $MailSubject . CRLF
			. $MailHeader . CRLF.CRLF.CRLF. $MailMessage . CRLF.'.'.CRLF );
		$SocketMessage = fgets( $this->SmtpConnect, 512 );
		if ( substr( $SocketMessage, 0, 3 ) != 250 ) {
			watchdog( 'send mail failed', array( '@mailto'=> $MailTo, '@title'=> $title ), WATCHDOG_ERROR );
			return FALSE;
		}
		
		return TRUE;
	}
	
	function __destruct( )
	{
		@fputs( $this->SmtpConnect, "QUIT". CRLF );
	}
}
