<?php
/*
	file:	/libraries/make.class.php
	modify:	2009/02/13 - 2010/05/18
*/

class make
{
	var $var;

	var $FileMakePath;
	var $TemplateFile;

	function __construct()
	{
		require_once './modules/column/column.inc';
		$this->_Set_Var( 'SITE', $GLOBALS['SITE'] )
			->_Set_Var( 'PATH', array( 'ROOT'=> ROOT_DIR, 'INDEX'=> ROOT_DIR . INDEX_PATH ) );
	}

	function _Set_Var( $Key, $Array )
	{
		if ( ! empty ( $Key )
			&& is_array( $Array ) )
		{
			if ( empty ( $this->var[ $Key ] ) )
				$this->var[ $Key ]= $Array;
			else
				foreach ( $Array as $key=> $value )
					$this->var[ $Key ][ $key ]= $value;
		}

		return $this;
	}

	function _Set_Tpl( $TemplateName )
	{
		$this->TemplateFile = raysn_object( 'cache' )
			->path( $TemplateName . '.tpl' )->path( );

		if ( ! is_file( $this->TemplateFile ) ) {
			//.Make Cache
			require_once './modules/template/template.inc';
			if ( ! _Make_TemplateCache( $TemplateName ) ) {
				watchdog( 'template not exist', array( '@tpl'=> $TemplateName ), WATCHDOG_ERROR );
				raysn_clewbox ( language( 'template not exist' ) );
			}
		}

		return $this;
	}
	
	function _Set_Url( $UpdateUrl ) {
		$this->UpdateUrl = $UpdateUrl;
		return $this;
	}

	function _Get_Data( $ModuleCommand, $Parameter )
	{
		if ( preg_match( "/^([a-z]+):([a-z]+)$/", $ModuleCommand, $Match ) ) {
			$Function = $Match[1] . "Api__Get_" . $Match[2];
			if ( ! function_exists( $Function ) ) {
				if ( ! in_array( $Match[1], array( 'user' ) ) ) {
					require_once './libraries/module.inc';
					if ( ! _Check_ModuleEnabled( $Match[1] ) ) {
						return array( );
					}
				}
				$DataApiPath = './modules/' . $Match[1] . '/' . $Match[1] . '.api';
				if ( is_file( $DataApiPath ) ) {
					require_once $DataApiPath;
				}
			}
			if ( function_exists( $Function ) ) {
				return $Function( $Parameter );
			}
		}

		return array( );
	}

	function _Run_Template( )
	{
		global $make;
		$make = $this;

		ob_start( array( $this, '_Error_handle' ) );
		require $this->TemplateFile;
		$return = preg_replace( "/<!\?(.*?)\?!>/", "<?\\1?>", ob_get_contents( ) );
		ob_end_clean();

		exit ( $return );
	}

	function _Make_File( $FilePath, $BrowsePage= TRUE )
	{
		if ( $BrowsePage && $GLOBALS['CONFIG']['CACHE_PAGE'] == 'closed' ) {
			return FALSE;
		}

		$ArchivesDir = './archives/';
		$FileObject = raysn_object( 'file' );
		if ( ! is_dir ( dirname( $ArchivesDir . $FilePath ) ) ) {
			$Dirpath = $ArchivesDir;
			foreach ( explode( '/', trim( dirname( $FilePath ), '/' ) ) as $dirname ) {
				$Dirpath .= $dirname . '/';
				if ( ! is_dir ( $Dirpath ) ) {
					$FileObject->path( $Dirpath )->mkdir( );
				}
			}
		}
		if ( ! is_writeable ( dirname( $ArchivesDir . $FilePath ) ) ) {
			watchdog( 'dir not write able', array( '@dirpath'=> dirname( $ArchivesDir . $FilePath ) ), WATCHDOG_ERROR );
			return FALSE;
		}

		global $make;
		$make = $this;

		ob_start( array( $this, '_Error_handle' ) );
		require $this->TemplateFile;
		$return = $FileObject->path( $ArchivesDir . $FilePath )
			->make( preg_replace( "/<!\?(.*?)\?!>/", "<?\\1?>", ob_get_contents( ) ). $this->_Output_Update( ) );
		ob_end_clean();

		return $return;
	}

	private function _Output_Update( ) {
		if ( $GLOBALS['CONFIG']['STATIC_LINK'] == 'opened' && ! empty ( $this->UpdateUrl ) ) {
			return '<script type="text/javascript" src="'.$this->UpdateUrl.'?ajax"></script>';
		}
	}

	private function _Error_handle( $buffer )
	{
		$_error = error_get_last();
		$buffer = array();

		return "[Template Error] <br /><br />"
		. "Error Place: " . basename( $_error['file'] ) . " line " . $_error['line'] . "<br />"
		. "Error Message: " . $_error['message'];
	}
}

//Public api function
function Factors__Get_SqlWay( $Factors )
{
	if ( ! isset ( $Factors['way'] )
		|| ! in_array ( $Factors['way'], array( 'DESC', 'ASC' ) ) ) {
		$Factors['way'] = 'DESC';
	}

	return $Factors['way'];
}
	
function Factors__Get_SqlLimit( $Factors )
{
	if ( isset ( $Factors['rows'] ) )
	{
		if ( is_numeric( $Factors['rows'] ) ) {
			return "0," . $Factors['rows'];
		}
		elseif ( preg_match( "/^\d+,\d+$/", $Factors['rows'] ) ) {
			return $Factors['rows'];
		}
		elseif ( defined( 'PAGE_NOWINDEX' )
			&& preg_match( "/^@,(\d+)$/", $Factors['rows'], $_Match ) )
		{
			define( 'PAGE_SIZE', $_Match[1] );
			$GLOBALS['OBJECT']['make']->var['Page']['Pagelist']= raysn_object( 'pagelist' )->_Set_PageInfo( array(
				'TotalNumber'=> raysn_object( 'mysql' )->select_count( $Factors['table'], $Factors['where'] ),
				'NowIndex'=> PAGE_NOWINDEX ) )->_Get_Pagelist( );

			if ( PAGE_NOWINDEX > $GLOBALS['OBJECT']['pagelist']->TotalPage && PAGE_NOWINDEX > 1 ) {
				@raysn_goto_page( ROOT_DIR );
			}
			return ( ( PAGE_NOWINDEX- 1 ) * $_Match[1] ) . ',' . $_Match[1];
		}
	}

	return "0,1";
}

function Factors__Get_Style( $Factor )
{
	$Factors= explode( ';', trim( $Factor ) );
	$FactorsArray= array();

	foreach ( $Factors as $Factor ) {
		if ( preg_match( "/(\w+):([\w\/\-:]+)/", $Factor, $_Match ) ) {
			$FactorsArray[ $_Match[1] ]= str_replace( '_', ' ', $_Match[2] );
		}
	}

	return $FactorsArray;
}
