<?php
/*
	file:	/libraries/module.inc
	modify:	2009/08/11 - 2010/05/04
*/

	function _Check_ModuleExist( $ModuleName )
	{
		return raysn_object( 'file' )
			->path( './modules/' . $ModuleName . '/' . $ModuleName . '.info' )
			->is_file( );
	}

	function _Check_ModuleInstalled( $ModuleName )
	{
		require_once './modules/' . $ModuleName . '/' . $ModuleName . '.install';
		$MysqlObject = raysn_object( 'mysql_table' );
		foreach ( call_user_func( $ModuleName . "_schema" ) as $tablename=> $table ) {
			if ( ! $MysqlObject->_check_table_exist( $tablename ) ) {
				return FALSE;
			}
		}
		return TRUE;
	}

	function _Check_ModuleEnabled( $ModuleName )
	{
		if ( ! _Check_ModuleExist( $ModuleName ) ) {
			return FALSE;
		}

		//.Check database
		if ( ! _Check_ModuleInstalled( $ModuleName ) ) {
			return FALSE;
		}

		//.Check permit file
		$PermitFilePath= _Get_ModulePermitFilepath( $ModuleName );
		if ( ! is_file ( $PermitFilePath ) ) {
			return FALSE;
		}

		$Permit= require $PermitFilePath;
		return is_array ( $Permit ) && ! empty ( $Permit );
	}

	function _Check_ModuleWriteable( $ModuleName )
	{
		$PermitFilePath= _Get_ModulePermitFilepath( $ModuleName );

		if ( ( is_file( $PermitFilePath ) && is_writeable( $PermitFilePath ) )
			|| ( ! is_file( $PermitFilePath ) && is_writeable( dirname( $PermitFilePath ) ) ) ) {
			return TRUE;
		}
	}

	function _Check_ModuleInstallFile( $ModuleName )
	{
		return @filemtime( './modules/' . $ModuleName . '/' . $ModuleName . '.install' ) == raysn_check_timestamp( );
	}
	
	function _Get_ModuleList( )
	{
		foreach ( raysn_object( 'file' )
			->path( './modules/' )->dirs() as $ModuleName )	{
			if ( $ModuleInfo = _Get_ModuleInfo( $ModuleName ) ) {
				$ModuleList[] = $ModuleInfo;
			}
		}
		return $ModuleList;
	}

	function _Get_ModuleInfo( $ModuleName )
	{
		if ( $ModuleInfo= raysn_object( 'file' )
			->path( './modules/' . $ModuleName . '/' . $ModuleName . '.info' )
			->_Parse_Inifile( ) )
		{
			if ( empty ( $ModuleInfo['type'] )
				|| ! preg_match( "/^(base|plus)-module$/", $ModuleInfo['type'] ) ) {
				$ModuleInfo['type'] = NULL;
			}
			return $ModuleInfo;
		}

		return FALSE;
	}

	function _Get_ModuleActionTitles( $ModuleName )
	{
		$InstallInfos= raysn_object( 'file' )
			->path( './modules/' . $ModuleName . '/' . $ModuleName . '.ini' )
			->_Parse_Inifile( );
		return $InstallInfos['title'];
	}

	function _Get_ModuleStatsTitles( $ModuleName )
	{
		$InstallInfos= raysn_object( 'file' )
			->path( './modules/' . $ModuleName . '/' . $ModuleName . '.ini' )
			->_Parse_Inifile( );
		return $InstallInfos['stats'];
	}

	function _Get_ModuleTablesTitle( )
	{
		$TablesTitle = array( );
		foreach ( raysn_object( 'file' )
			->path( './modules/' )->dirs() as $ModuleName )	{
			$InstallInfos= $GLOBALS['OBJECT']['file']
				->path( './modules/' . $ModuleName . '/' . $ModuleName . '.ini' )
				->_Parse_Inifile( );
			if ( isset ( $InstallInfos['table'] )
				&& is_array ( $InstallInfos['table'] ) ) {
				$TablesTitle = array_merge( $InstallInfos['table'], $TablesTitle );
			}
		}

		return $TablesTitle;
	}

	function _Get_ModuleTemplateLabels( )
	{
		$TemplateLabels = array( );
		foreach ( raysn_object( 'file' )
			->path( './modules/' )->dirs() as $ModuleName )	{
			$InstallInfos= $GLOBALS['OBJECT']['file']
				->path( './modules/' . $ModuleName . '/' . $ModuleName . '.ini' )
				->_Parse_Inifile( );
			if ( isset ( $InstallInfos['label'] )
				&& is_array ( $InstallInfos['label'] ) ) {
				$TemplateLabels = array_merge( $InstallInfos['label'], $TemplateLabels );
			}
		}

		return $TemplateLabels;
	}

	function _Get_ModuleShortcuts( )
	{
		$Shortcuts = array( );
		foreach ( raysn_object( 'file' )
			->path( './modules/' )->dirs() as $ModuleName ) {
			if ( _Check_ModuleEnabled( $ModuleName ) ) {
				$InstallInfos= $GLOBALS['OBJECT']['file']
					->path( './modules/' . $ModuleName . '/' . $ModuleName . '.ini' )
					->_Parse_Inifile( );
				if ( isset ( $InstallInfos['links'] )
					&& is_array ( $InstallInfos['links'] ) ) {
					foreach ( $InstallInfos['links'] as $action=> $icon ) {
						$Shortcuts[] = array(
							'module'=> $ModuleName,
							'action'=> $action,
							'icon'=> $icon,
							'title'=> $InstallInfos['title'][ $action ]
						);
					}
				}
			}
		}

		return $Shortcuts;
	}

	function _Get_ModulePermitFilepath( $ModuleName )
	{
		return './includes/permit/' . $ModuleName . '.php';
	}
	
	function _Get_ModuleInstallPermission( $ModuleName )
	{
		$InstallfilePath = './modules/' . $ModuleName . '/' . $ModuleName . '.install';
		if ( ! is_file ( $InstallfilePath ) ) {
			raysn_clewbox ( language( 'Install file <em>@1</em> lost', array( '@1'=> $InstallfilePath ) ) );
		}

		require_once $InstallfilePath;
		$PermitFunction = $ModuleName . '_permission';
		if ( ! function_exists( $PermitFunction ) ) {
			raysn_clewbox ( language( 'Permit function <em>@1</em> lost', array( "@1"=> $PermitFunction, "@2"=> $InstallfilePath ) ) );
		}

		if ( is_array ( $ModulePermission = $PermitFunction( ) ) ) {
			return $ModulePermission;
		}
		else {
			raysn_clewbox ( language( 'Install file <em>@1</em> error', array( '@1'=> $InstallfilePath ) ) );
		}
	}

	function _Get_ModulePermission( $ModuleName )
	{
		$PermitfilePath= _Get_ModulePermitFilepath( $ModuleName );
		if ( is_file( $PermitfilePath ) ) {
			$ModulePermission = require $PermitfilePath;
		}
		else {
			$ModulePermission = array( );
		}

		return _Set_ModulePermission( $ModuleName, $ModulePermission );
	}
	
	function _Set_ModulePermission( $ModuleName, $ModulePermission= NULL )
	{
		$ModulePermission2 = _Get_ModuleInstallPermission( $ModuleName );
		if ( ! empty ( $ModulePermission['access'] )
			&& is_array ( $ModulePermission['access'] ) )
		{
			if ( isset ( $ModulePermission['unlock'] )
				&& is_array ( $ModulePermission['unlock'] ) ) {
				$ModulePermission2['unlock'] = $ModulePermission['unlock'];
			}

			foreach ( $ModulePermission2['access'] as $action => $permit ) {
				//.Check permit installed
				if ( isset ( $ModulePermission['access'][ $action ] ) ) {
					if ( empty ( $permit )
						&& in_array( 0, $ModulePermission['access'][ $action ] ) ) {
						unset ( $ModulePermission['access'][ $action ][ array_search( 0, $ModulePermission['access'][ $action ] ) ] );
					}
					$ModulePermission2['access'][ $action ] = $ModulePermission['access'][ $action ];
				}
				else
					$ModulePermission2['access'][ $action ] = array( );
			}
		}

		return $ModulePermission2;
	}

	function _Make_ModulePermitFile( $ModuleName, $ModulePermission= NULL )
	{
		$ModulePermission2 = _Set_ModulePermission( $ModuleName, $ModulePermission );
		$PermitCodes= $UnlockCodes= array( );

		foreach ( $ModulePermission2['access'] as $action => $permit ) {
			$PermitCodes[]= "'" . $action . "'=> array(" . @implode( ',', $permit ) . ")";
		}
		
		foreach ( $ModulePermission2['unlock'] as $unlock ) {
			$UnlockCodes[]= "'" . $unlock . "'";
		}

		return raysn_object( 'file' )
			->path( _Get_ModulePermitFilepath( $ModuleName ) )
			->make( "<?php return array('access'=> array(" . implode( ',', $PermitCodes ) . "),'unlock'=> array(" . implode( ',', $UnlockCodes ) . "));" );
	}

	function _Enable_ModuleAccess( $ModuleName )
	{
		if ( ! _Check_ModuleInstalled( $ModuleName ) ) {
			$MysqlObject = raysn_object( 'mysql_table' );
			foreach ( call_user_func( $ModuleName . "_schema" ) as $tablename=> $table ) {
				$MysqlObject->create_table( $tablename, $table );
			}
		}

		return _Make_ModulePermitFile( $ModuleName );
	}
	
	function _Disable_ModuleAccess( $ModuleName )
	{
		return raysn_object( 'file' )
			->path( _Get_ModulePermitFilepath( $ModuleName ) )
			->delete( );
	}
