<?php
/*
	file:	/libraries/mysql_table.class.php
	modify:	2009/09/23 - 2010/04/23
*/

require_once './libraries/mysql.class.php';
class mysql_table extends mysql
{
	function _show_tables( )
	{
		static $Tables;
		if ( ! isset ( $Tables ) ) {
			$this->SqlQuery= "SHOW TABLES";
			$this->_Execute_SqlQuery( );

			$Tables = array( );
			while ( $Table= mysql_fetch_array( $this->result, MYSQL_ASSOC ) )
				$Tables[ ]= end ( $Table );
		}

		return $Tables;
	}
	
	function _show_table_fields( $Tablename )
	{
		if ( $this->_check_table_exist( $Tablename ) ) {
			$this->SqlQuery= "SHOW FIELDS FROM `{$Tablename}`";
			$this->_Execute_SqlQuery( );

			while ( $Field= mysql_fetch_array( $this->result, MYSQL_ASSOC ) ) {
				$Fields[ $Field['Field'] ]= $Field;
			}

			return $Fields;
		}
	}

	function _check_table_exist( $Tablename )
	{
		return in_array ( $Tablename, $this->_show_tables( ) );
	}
	
	function _create_table_struct( $Tablename )
	{
		if ( $this->_check_table_exist( $Tablename ) ) {
			$this->SqlQuery= "SHOW CREATE TABLE `{$Tablename}`";
			$this->_Execute_SqlQuery( );

			return mysql_fetch_array( $this->result, MYSQL_ASSOC );
		}
	}
	
	function _repair_table( $Tablename )
	{
		$this->SqlQuery= "REPAIR TABLE `{$Tablename}`";
		$this->_Execute_SqlQuery( );
		
		return $this->result;
	}

	function _optimeze_table( $Tablename )
	{
		$this->SqlQuery= "OPTIMIZE TABLE `{$Tablename}`";
		$this->_Execute_SqlQuery( );

		return $this->result;
	}

	function create_table( $tablename, $table )
	{
		$this->SqlQuery= $this->db_create_table_sql( $tablename, $table );
		$this->_Execute_SqlQuery( );

		return $this->result;
	}
	
	function alter_add( $tablename, $FieldArray )
	{
		if ( empty ( $FieldArray )
			|| ! is_array ( $FieldArray ) ) {
			return 0;
		}

		foreach ( $FieldArray as $fieldname=> $filedset ) {
			$FiledsSql[] = $this->_db_create_field_sql( $fieldname, $this->_db_process_field( $filedset ) ). ( $filedset['after']? ' AFTER `'.$filedset['after'].'`':' FIRST ' );
		}

		$this->SqlQuery= "ALTER TABLE `{$tablename}` ADD " . implode( ',', $FiledsSql );
		$this->_Execute_SqlQuery( );

		return $this->result;
	}
	
	function alter_drop( $tablename, $FieldArray )
	{
		if ( empty ( $FieldArray )
			|| ! is_array ( $FieldArray ) ) {
			return 0;
		}

		foreach ( $FieldArray as $fieldname=> $filedset ) {
			$FiledsSql[]= "`$fieldname`";
		}

		$this->SqlQuery= "ALTER TABLE `{$tablename}` DROP " . implode( ',', $FiledsSql );
		$this->_Execute_SqlQuery( );

		return $this->result;
	}

	function db_create_table_sql( $tablename, $table )
	{
		$sql = "CREATE TABLE IF NOT EXISTS `". $tablename ."` (\n";

		// Add the SQL statement for each field.
		foreach ( $table['fields'] as $fieldname => $field ) {
			$sql .= $this->_db_create_field_sql( $fieldname, $this->_db_process_field( $field ) ) . ", \n";
		}

		// Process keys & indexes.
		$keys = $this->_db_create_keys_sql( $table );
		if ( count( $keys ) ) {
			$sql .= implode( ", \n", $keys ) . ", \n";
		}

		// Remove the last comma and space.
		$sql = substr( $sql, 0, -3 ) . "\n) ENGINE=MyISAM DEFAULT CHARSET=utf8";
		if ( ! empty ( $table['auto_increment'] )
			&& is_numeric( $table['auto_increment'] ) ) {
			$sql .= " AUTO_INCREMENT=" . $table['auto_increment'];
		}

		return $sql;
	}

	function _db_create_field_sql( $name, $spec )
	{
		$sql = "`" . $name . "` " . $spec['mysql_type'];

		if ( isset ( $spec['length'] ) ) {
			$sql .= '('. $spec['length'] .')';
		}
		elseif ( isset ( $spec['precision'] )
			&& isset ( $spec['scale'] ) ) {
			$sql .= '('. $spec['precision'] .', '. $spec['scale'] .')';
		}

		if ( ! empty ( $spec['unsigned'] ) ) {
			$sql .= ' unsigned';
		}

		if ( ! empty ( $spec['not null'] ) ) {
			$sql .= ' NOT NULL';
		}

		if ( ! empty ( $spec['auto_increment'] ) ) {
			$sql .= ' auto_increment';
		}

		if ( isset ( $spec['default'] ) ) {
			if ( is_string( $spec['default'] ) ) {
				$spec['default'] = "'". $spec['default'] ."'";
			}
			$sql .= ' DEFAULT '. $spec['default'];
		}

		if ( empty ( $spec['not null'] ) && ! isset ( $spec['default'] ) ) {
			$sql .= ' DEFAULT NULL';
		}

		return $sql;
	}
	
	function _db_process_field( $field )
	{
		if (!isset($field['size'] ) ) {
			$field['size'] = 'normal';
		}

		if (!isset($field['mysql_type'] ) ) {
			$map = $this->db_type_map();
			$field['mysql_type'] = $map[$field['type'] .':'. $field['size']];
		}

		if ($field['type'] == 'serial') {
			$field['auto_increment'] = TRUE;
		}

		return $field;
	}

	function db_type_map( )
	{
		$map = array
		(
		'varchar:normal'	=> 'VARCHAR',
		'char:normal'		=> 'CHAR',
		'set:normal'		=> 'SET',
		'enum:normal'		=> 'ENUM',
		'bool:normal'		=> 'BOOL',

		'text:tiny'		=> 'TINYTEXT',
		'text:small'		=> 'SMALLTEXT',
		'text:medium'		=> 'MEDIUMTEXT',
		'text:normal'		=> 'TEXT',
		'text:big'		=> 'LONGTEXT',

		'serial:tiny'		=> 'TINYINT',
		'serial:small'		=> 'SMALLINT',
		'serial:medium'		=> 'MEDIUMINT',
		'serial:normal'		=> 'INT',
		'serial:big'		=> 'BIGINT',

		'int:tiny'		=> 'TINYINT',
		'int:small'		=> 'SMALLINT',
		'int:medium'		=> 'MEDIUMINT',
		'int:normal'		=> 'INT',
		'int:big'		=> 'BIGINT',

		'float:tiny'		=> 'FLOAT',
		'float:small'		=> 'FLOAT',
		'float:medium'		=> 'FLOAT',
		'float:normal'		=> 'FLOAT',
		'float:big'		=> 'DOUBLE',

		'numeric:normal'	=> 'DECIMAL',

		'blob:normal'		=> 'BLOB',
		'blob:big'		=> 'LONGBLOB',

		'datetime:normal'	=> 'DATETIME',
		);
		return $map;
	}

	function _db_create_keys_sql( $spec )
	{
		$keys = array();

		if ( ! empty ( $spec['primary key'] ) ) {
			$keys[] = 'PRIMARY KEY (' . $this->_db_create_key_sql( $spec['primary key'] ) . ')';
		}
		if ( ! empty ( $spec['unique keys'] ) ) {
			foreach ( $spec['unique keys'] as $key => $fields ) {
				$keys[] = 'UNIQUE KEY ' . $key . ' (' . $this->_db_create_key_sql( $fields ) . ')';
			}
		}
		if ( ! empty ( $spec['indexes'] ) ) {
			foreach ( $spec['indexes'] as $index => $fields ) {
				$keys[] = 'INDEX ' . $index . ' (' . $this->_db_create_key_sql( $fields ) . ')';
			}
		}

		return $keys;
	}

	function _db_create_key_sql( $fields )
	{
		$ret = array();
		foreach ( $fields as $field )
		{
			if ( is_array( $field ) ) {
				$ret[] = $field[0] .'('. $field[1] .')';
			}
			else {
				$ret[] = $field;
			}
		}
		return '`' . implode( '`, `', $ret ) . '`';
	}
}
