<?php
/*
	file:	/libraries/pagelist.class.php
	modify:	2009/02/08 - 2010/04/17
*/

define( 'DisplayEllipsis', 5 );

class pagelist
{
	var $TotalPage	= 0;
	var $NowIndex	= 1;
	var $UrlPrefix	= array( );

	function _Set_PageInfo( $PageInfo )
	{
		if ( ! defined( 'PAGE_SIZE' ) ) {
			define( 'PAGE_SIZE', variable_get( 'PageSize', 10 ) );
		}
		if ( empty ( $PageInfo[ 'TotalNumber' ] )
			|| $PageInfo[ 'TotalNumber' ] < 0 ) {
			$this->TotalPage= 0 ;
		} else {
			$this->TotalPage= ceil ( $PageInfo[ 'TotalNumber' ] / PAGE_SIZE );
		}

		if ( ! empty ( $PageInfo[ 'NowIndex' ] )
			&& $PageInfo[ 'NowIndex' ] > 0
			&& $PageInfo[ 'NowIndex' ] <= $this->TotalPage ) {
			$this->NowIndex= $PageInfo[ 'NowIndex' ];
		}

		if ( ! empty ( $PageInfo[ 'UrlPrefix' ] )
			&& is_array ( $PageInfo[ 'UrlPrefix' ] ) ) {
			$this->UrlPrefix= $PageInfo[ 'UrlPrefix' ];
		}

		return $this;
	}
		
	function _Get_Pagelist()
	{
		
		$plus = ceil( DisplayEllipsis / 2 );
		if ( DisplayEllipsis - $plus + $this->NowIndex > $this->TotalPage ) {
			$plus = DisplayEllipsis - $this->TotalPage + $this->NowIndex;
		}

		$FirstPage = $this->NowIndex- $plus + 1;
		if ( $FirstPage < 1 ) {
			$FirstPage = 1;
		}

		if ( $FirstPage + DisplayEllipsis <= $this->TotalPage ) {
			$LastPage = $FirstPage + DisplayEllipsis - 1;
		}
		else {
			$LastPage = $this->TotalPage;
		}

		$Pagelist= $this->_Get_PrePage( );
		
		if ( $FirstPage > 2 ) {
			$Pagelist.= $this->_Get_PageLink( 1 ) .'...';
		}
		elseif ( $FirstPage== 2 ) {
			$Pagelist.= $this->_Get_PageLink( 1 );
		}

		for ( $Page= $FirstPage; $Page<= $LastPage; $Page++ ) {
			if ( $Page != $this->NowIndex) {
				$Pagelist.= $this->_Get_PageLink( $Page );
			}
			else {
				$Pagelist.= "<em>$Page</em>";
			}
		}

		if ( $LastPage< $this->TotalPage -1 ) {
			$Pagelist .= '...'. $this->_Get_PageLink( $this->TotalPage );
		}
		elseif ( $LastPage == $this->TotalPage -1 ) {
			$Pagelist .= $this->_Get_PageLink( $this->TotalPage );
		}

		$Pagelist.= $this->_Get_NextPage();
		if ( empty ( $Pagelist ) ) {
			$Pagelist = language( 'no page here' );
		}

		return $Pagelist;
	}

	private function _Get_PrePage( ) {
		if ( $this->NowIndex > 1 ) {
			return '<a href="'. $this->_Get_UrlLink( $this->NowIndex- 1 ) .'">'. language( 'prepage' ) .'</a>';
		}
	}

	private function _Get_NextPage( ) {
		if ( $this->NowIndex < $this->TotalPage ) {
			return '<a href="'. $this->_Get_UrlLink( $this->NowIndex+ 1 ) .'">'. language( 'nextpage' ) .'</a>';
		}
	}

	private function _Get_PageLink( $PageNumber ) {
		return '<a href="'. $this->_Get_UrlLink( $PageNumber ) .'">'.$PageNumber.'</a>';
	}

	private function _Get_UrlLink( $PageNumber ) {
		return url( trim ( $GLOBALS['BackupPath'] . $PageNumber, '/' ), $this->UrlPrefix );
	}
}
