<?php
/*
	file:	/libraries/path.inc
	modify:	2009/11/21 - 2010/05/18
*/

if ( ! defined( 'RAYSN_HOME_PAGE' ) ) {
	define( 'RAYSN_HOME_PAGE', 'column' );
}
define( 'RAYSN_INDEX_PAGE', 'index' );
define( 'RAYSN_BROWSE_PAGE', 'browse' );

function raysn_get_path_items( )
{
	global $BackupPath, $Parameters;
	$path_items= explode( '/', trim ( $_SERVER['PATH_INFO'], '/' ) );
	$Routers[ 'Module' ] = $path_items[0];

	if ( isset ( $path_items[1] ) )
	{
		if ( ! is_numeric ( $path_items[1] ) )
		{
			$Routers[ 'action' ] = $path_items[1];
			$BackupPath = $Routers[ 'Module' ].'/'.$Routers[ 'action' ].'/';
			if ( isset ( $path_items[2] ) ) {
				$Parameters[ 'id' ] = $path_items[2];
				$BackupPath.= $Parameters[ 'id' ].'/';
				if ( isset ( $path_items[3] )
					&& is_numeric ( $path_items[3] ) ) {
					$Parameters[ 'page' ] = $path_items[3];
				}
			}
		}
		else
		{
			$Parameters[ 'id' ] = $path_items[1];
			$BackupPath = $Routers[ 'Module' ].'/'.$Parameters[ 'id' ].'/';
			if ( isset ( $path_items[2] ) ) {
				if ( ! is_numeric ( $path_items[2] ) ) {
					$Routers[ 'action' ] = $path_items[2];
					$BackupPath.= $Routers[ 'action' ].'/';
					if ( isset ( $path_items[3] )
						&& is_numeric ( $path_items[3] ) ) {
						$Parameters[ 'page' ] = $path_items[3];
					}
				}
				else
					$Parameters[ 'page' ] = $path_items[2];
			}
			if ( empty ( $Routers[ 'action' ] ) ) {
				$Routers[ 'action' ] = RAYSN_BROWSE_PAGE;
			}
		}
	}
	else
		$Routers[ 'action' ] = RAYSN_INDEX_PAGE;

	return $Routers;
}

function raysn_execute_path_handler( )
{
	//rewrite:	user/login
	//pathinfo:	index.php/user/login	$_SERVER['PATH_INFO']

	if ( empty ( $_SERVER['PATH_INFO'] ) ) {
		$_SERVER['PATH_INFO'] = RAYSN_HOME_PAGE;
	}

	global $CONFIG, $Routers, $Parameters;
	if ( $CONFIG['SITE_ACCESS'] == 'closed'
		&& ! in_array( $_SERVER['PATH_INFO'], array( '/user/login', '/install' ) ) ) {
		if ( ! raysn_check_installed( ) ) {
			raysn_goto_page( ROOT_DIR . 'index.php/install' );
		}
		if ( raysn_get_user_id( ) != 1 ) {
			return RAYSN_SITE_CLOSED;
		}
	}

	$Routers = raysn_get_path_items( );
	if ( $Routers['Module'] == 'archives' ) {
		$Routers['Module'] = $Routers['action'];
		$Routers['action'] = RAYSN_BROWSE_PAGE;
		$Parameters['id'] = preg_replace( "/^.+\/([a-zA-Z\d-_]+)\.[a-z]{3,4}$/", "\\1", $_SERVER['PATH_INFO'] );
	}
	$ModelfilePath = './modules/' . $Routers[ 'Module' ] . '/' . $Routers[ 'action' ] . '.php';
	if ( ! is_file( $ModelfilePath ) ) {
		return RAYSN_NOT_FOUND;
	}

	if ( empty ( $Parameters ) ) {
		$Parameters = array_merge( $_GET, $_POST );
	} else {
		$Parameters = array_merge( $_GET, $_POST, $Parameters );
	}
	if ( ! get_magic_quotes_gpc() ) {
		$Parameters = filter_array( $Parameters );
	}

	//.check permit
	if ( $_SERVER['PATH_INFO'] != '/user/login' ) {
		if ( ! raysn_check_user_permit( $Routers['Module'], $Routers['action'] ) ) {
			return RAYSN_ACCESS_DENIED;
		}
		raysn_check_user_unlock( );
	}

	require_once $ModelfilePath;
	return call_user_func( $Routers[ 'Module' ] . '_' . $Routers[ 'action' ], $Parameters );
}

function url( $PATH_INFO, $Parameters = array() )
{
	$Parameter = '';
	if ( is_array ( $Parameters )
		&& ! empty ( $Parameters ) )
	{
		foreach ( $Parameters as $key=> $value ) {
			$ParameterValues[] = $key . '=' . $value;
		}
		$Parameter = '?' . implode( '&', $ParameterValues );
	}

	return ROOT_DIR . INDEX_PATH . $PATH_INFO . $Parameter;
}
	
function raysn_get_archives_path( $type, $id )
{
	static $Archives;
	if ( empty ( $Archives[ $type ][ $id ] ) ) {
		$Archives[ $type ][ $id ] = $type ."/" . substr( $id, 0, -2 ) ."/". $id .".html";
	}
	return $Archives[ $type ][ $id ];
}
