<?php
/*
	file:	/libraries/plus/seccode.php
	modify:	2010/03/01 - 2010/05/01
*/

	//.Create Background Color
	$ImageWidth = 100;
	$ImageHeight = 40;
	$ImageIdentifier = imagecreatetruecolor( $ImageWidth, $ImageHeight );

	for ( $i = 0;$i < 3;$i++ ) {
		$ColorRGB[ $i ] = mt_rand( 200, 250 );
		$Step[ $i ] = ( mt_rand( 100, 240 ) - $ColorRGB[ $i ] ) / $ImageWidth;
	}
	for ( $i = 0;$i < $ImageWidth;$i++ ) {
		$BackgroundColor = imagecolorallocate( $ImageIdentifier, $ColorRGB[0], $ColorRGB[1], $ColorRGB[2] );
		imageline( $ImageIdentifier, $i, 0, $i, $ImageHeight, $BackgroundColor );
		$ColorRGB[0] += $Step[0];
		$ColorRGB[1] += $Step[1];
		$ColorRGB[2] += $Step[2];
	}

	ob_start( );
	imagepng( $ImageIdentifier );
	imagedestroy( $ImageIdentifier );
	$BackContent = ob_get_contents( );
	ob_end_clean();
	ob_start( 'ob_gzhandler' );

	//.Create Background Lines
	$ImageIdentifier = imagecreatefromstring( $BackContent );
	$LineColor = imagecolorallocate( $ImageIdentifier, $ColorRGB[0]- 20, $ColorRGB[1]- 20, $ColorRGB[2]- 20 );
	$LineNumbers = $ImageHeight / 10;
	for ( $i= 1; $i < $LineNumbers; $i++ ) {
		$x = mt_rand( 0, $ImageWidth );
		$y = mt_rand( 0, $ImageHeight );
		if ( mt_rand( 0, 1 ) ) {
			imageline( $ImageIdentifier, $x, $y, mt_rand( 0, 20 ), mt_rand( 0, mt_rand( $ImageHeight, $ImageWidth ) ), $LineColor );
		}
		else {
			imagearc( $ImageIdentifier, $x, $y, mt_rand( 0, $ImageWidth ), mt_rand( 0, $ImageHeight ), mt_rand( 0, 360 ), mt_rand( 0, 360 ), $LineColor );
		}
	}

	//.Create Fonts
	$seccode = '';
	$Characters = 'BCEFGHJKMPQRTVWXY2346789';
	$max = strlen( $Characters ) - 1;

	mt_srand( );
	for ( $i = 0; $i < 4; $i++ ) {
		$seccode .= $Characters[ mt_rand( 0, $max ) ];
	}

	$seccodedir = array();
	$seccoderoot = './seccode/';
	$dirs = opendir( $seccoderoot );
	while ( $dir = readdir( $dirs ) ) {
		if ( $dir != '.' && $dir != '..'
			&& file_exists( $seccoderoot.$dir.'/9.gif' ) ) {
			$seccodedir[] = $dir;
		}
	}

	$widthtotal = 0;
	for ( $i = 0; $i <= 3; $i++ ) {
		$imcodefile = $seccodedir ? $seccoderoot.$seccodedir[ array_rand( $seccodedir ) ].'/'.strtolower( $seccode[$i] ).'.gif' : '';
		if ( ! empty( $imcodefile )
			&& file_exists( $imcodefile ) ) {
			$font[ $i ]['file'] = $imcodefile;
			$font[ $i ]['data'] = getimagesize( $imcodefile );
			$font[ $i ]['width'] = $font[ $i ]['data'][0] + mt_rand( 0, 6 ) - 4;
			$font[ $i ]['height'] = $font[ $i ]['data'][1] + mt_rand( 0, 6 ) - 4;
			$font[ $i ]['width'] += mt_rand( 0, $ImageWidth / 5 - $font[ $i ]['width'] );
			$widthtotal += $font[ $i ]['width'];
		} else {
			$font[ $i ]['file'] = '';
			$font[ $i ]['width'] = 8 + mt_rand( 0, $ImageWidth / 5 - 5 );
			$widthtotal += $font[ $i ]['width'];
		}
	}
	$x = mt_rand( 1, $ImageWidth - $widthtotal );
	for ( $i = 0; $i <= 3; $i++ ) {
		if ( $font[ $i ]['file'] ) {
			$imcode = imagecreatefromgif( $font[ $i ]['file'] );
			$y = mt_rand( 0, $ImageHeight - $font[ $i ]['height'] );
			
			$imcodeshadow = $imcode;
			imagecolorset( $imcodeshadow, 0 , 255 - $ColorRGB[0], 255 - $ColorRGB[1], 255 - $ColorRGB[2] );
			imagecopyresized( $ImageIdentifier, $imcodeshadow, $x + 1, $y + 1, 0, 0, $font[$i]['width'], $font[$i]['height'], $font[$i]['data'][0], $font[$i]['data'][1] );
			imagecolorset( $imcode, 0 , $ColorRGB[0], $ColorRGB[1], $ColorRGB[2] );
			imagecopyresized( $ImageIdentifier, $imcode, $x, $y, 0, 0, $font[$i]['width'], $font[$i]['height'], $font[$i]['data'][0], $font[$i]['data'][1] );
		} else {
			$y = mt_rand( 0, $ImageHeight - 20 );
			
			$text_shadowcolor = imagecolorallocate( $ImageIdentifier, 255 - $ColorRGB[0], 255 - $ColorRGB[1], 255 - $ColorRGB[2] );
			imagechar( $ImageIdentifier, 5, $x + 1, $y + 1, $seccode[ $i ], $text_shadowcolor );
			$text_color = imagecolorallocate( $ImageIdentifier, $ColorRGB[0], $ColorRGB[1], $ColorRGB[2] );
			imagechar( $ImageIdentifier, 5, $x, $y, $seccode[ $i ], $text_color );
		}
		$x += $font[ $i ]['width'];
	}

	setcookie ( "RAYSN_SECCODE", strtolower( $seccode ), 0, '/' );

	header( 'Content-type: image/png' );
	imagepng( $ImageIdentifier );
	imagedestroy( $ImageIdentifier );
