<?php
/*
	file:	/libraries/session.inc
	modify:	2009/01/19 - 2010/05/19
*/

define( 'GUEST_USER_RID', 0 );
define( 'UNLOCK_ACTIVE', 1800 );
define( 'SESSION_ACTIVE', 3000 );
define( 'LOGIN_WAITING_TIME', 300 );

	function raysn_start_user_session( )
	{
		static $SessionStart;
		if ( empty ( $SessionStart ) ) {
			ini_set('session.gc_maxlifetime',   604800);
			ini_set('session.cookie_lifetime',  604800);
			session_set_save_handler( 'session_open', 'session_close', 'session_read', 'session_write', 'session_destroy_sid', 'session_clean' );
			session_start( );
			$SessionStart = true;
		}
	}

	function session_open( $save_path, $session_name ) {
		return TRUE;
	}

	function session_close( ) {
		return TRUE;
	}

	function session_read( $key )
	{
		register_shutdown_function( 'session_write_close' );

		if ( ! isset ( $_POST[ session_name() ] )
			&& ! isset ( $_COOKIE[ session_name() ] ) ) {
			return '';
		}
		
		if ( $user = raysn_object( 'mysql' )
			->select_object( 'user_session', array( 'select'=> '`session`', 'where'=> "`sid`= '" . $key . "'" ) ) ) {
			return $user->session;
		}
	}

	function session_write( $key, $value )
	{
		raysn_object( 'mysql' )
			->replace( 'user_session', array(
				'uid'=> raysn_get_user_id(),
				'sid'=> $key,
				'active'=> time(),
				'access'=> $_SERVER['REMOTE_ADDR'],
				'session'=> $value
			) );

		return TRUE;
	}

	function session_destroy_sid( $sid )
	{
		raysn_object( 'mysql' )->delete( 'user_session', "`sid`= '" . $sid . "'" );
		$GLOBALS['OBJECT']['mysql']->update( 'user', array( 'login'=> time() ), "`uid`= '". raysn_get_user_id( ) ."'" );
	}

	function session_clean( )
	{
		raysn_object( 'mysql' )
			->delete( 'user_session', "`active`< " . ( time() - SESSION_ACTIVE ) );

		return TRUE;
	}

	function raysn_get_user_id( )
	{
		global $user;
		if ( isset ( $user )
			&& is_object ( $user ) ) {
			return $user->uid;
		}

		if ( ! isset ( $_POST[ session_name() ] )
			&& ! isset ( $_COOKIE[ session_name() ] ) ) {
			$user = new stdClass();
			$user->uid = 0;
			return $user->uid;
		}

		$sid = $_POST[ session_name() ]? $_POST[ session_name() ]: $_COOKIE[ session_name() ];
		$active_time = time( );

		if ( $user = raysn_object( 'mysql' )
			->select_object( 'user_session', array(
			'select'=> "`user`.`uid`,`user`.`rid`,`user_session`.`active`",
			'join'=> array(	'table'=> 'user', 'way'=> 'left', 'on'=> 'uid' ),
			'where'=> "`user_session`.`sid`= '" . $sid . "'" ) ) )
		{
			if ( $user->active + SESSION_ACTIVE > $active_time ) {
				$GLOBALS['OBJECT']['mysql']->update( 'user_session', array( 'active'=> $active_time ), "`sid`= '" . $sid . "'" );
				return $user->uid;
			}
			elseif ( ! in_array( $_SERVER['PATH_INFO'], array( '/user/login', '/install' ) ) ) {
				session_destroy_sid( $sid );
				raysn_clewbox ( language( 'session expired', array( '@url'=> url( 'user/login/expired', array( 'refer'=> $_SERVER['PATH_INFO'] ) ) ) ) );
			}
		}

		return 0;
	}

	function raysn_get_user_info( $Field= NULL )
	{
		global $user;
		$AllowFields = array( 'name','mail','point','login','created' );
		$SqlArray['where']= "`uid`= '" . $user->uid . "'";

		if ( ! empty ( $Field )
			&& in_array( $Field, $AllowFields ) )
		{
			$SqlArray['select'] = '`' . $Field . '`';
			$UserInfo = raysn_object( 'mysql' )->select_row( 'user', $SqlArray );
			return $UserInfo[ $Field ];
		}
		else
		{
			$SqlArray['select'] = implode( ',', $AllowFields );
			return raysn_object( 'mysql' )->select_row( 'user', $SqlArray );
		}
	}

	function raysn_get_user_role( )
	{
		global $user;
		if ( ! isset ( $user->rid ) ) {
			$user= raysn_object( 'mysql' )
				->select_object( 'user', array( 'select'=> "`uid`,`rid`", 'where' => "`uid`= '" . raysn_get_user_id( ) . "'" ) );
		}

		return $user->rid;
	}

	function raysn_check_user_login( $passport, $password )
	{
		global $user;
		$user->uid= 0;
		if ( $user = raysn_object( 'mysql' )
			->select_object( 'user', array(
				'select'=> "`user`.`uid`,`user`.`rid`,`user`.`status`,`user_session`.`active`",
				'join'=> array(	'table'=> 'user_session', 'way'=> 'left', 'on'=> 'uid' ),
				'where'=> "`user`.`user`= '$passport' && `user`.`pass`= '" . raysn_get_pass_encode( $password ) . "'" ) ) )
		{
			if ( $GLOBALS['CONFIG']['ACCESS'] == 'closed' && $user->uid != 1 ) {
				$user->uid= 0;
				raysn_clewbox ( language( 'site has closed' ) );
			}
			if ( ! $user->status ) {
				$user->uid= 0;
				raysn_clewbox ( language( 'user not active' ) );
			}
			if ( $user->active!= NULL ) {
				if ( $user->active >= time() - LOGIN_WAITING_TIME ) {
					$user->uid= 0;
					raysn_clewbox ( language( 'user online now' ) );
				}
				else {
					$GLOBALS['OBJECT']['mysql']->delete( 'user_session', "`uid`= '". $user->uid ."'" );
					$GLOBALS['OBJECT']['mysql']->update( 'user', array( 'login'=> $user->active ), "`uid`= '". $user->uid ."'" );
				}
			}
		}

		return $user->uid;
	}

	function raysn_check_user_permit( $Module, $action )
	{
		global $ModulePermits;
		if ( ! isset ( $ModulePermits[ $Module ] ) ) {
			$ModulePermits[ $Module ]= @include './includes/permit/' . $Module . '.php';
		}

		if ( isset ( $ModulePermits[ $Module ]['access'][ $action ] )
			&& is_array ( $ModulePermits[ $Module ]['access'][ $action ] ) )
		{
			if ( in_array ( GUEST_USER_RID, $ModulePermits[ $Module ]['access'][ $action ] ) ) {
				return TRUE;
			}
			if ( raysn_get_user_id( ) == 1 || in_array( raysn_get_user_role( ), $ModulePermits[ $Module ]['access'][ $action ] ) ) {
				return TRUE;
			}
		}
	}

	function raysn_check_text_permit( $Permits )
	{
		foreach ( $Permits as $permit ) {
			$Roles[] = $permit['rid'];
		}
		if ( raysn_get_user_id( ) == 1 || in_array( raysn_get_user_role( ), $Roles ) ) {
			return TRUE;
		}
	}

	function raysn_check_user_column( $cid )
	{
		if ( variable_get( 'User_ColumnPermission', 'closed' ) == 'closed' || raysn_get_user_id( ) == 1
			|| raysn_object( 'mysql' )->select_row( 'user_column', array(
				'select'=> 1,
				'where'=> "`uid`= '" . raysn_get_user_id( ) . "' && `cid`= '" . $cid . "'"
			) ) ) {
			return TRUE;
		}
	}

	function raysn_check_user_unlock( )
	{
		global $Routers, $ModulePermits;
		if ( in_array( $Routers[ 'action' ], $ModulePermits[ $Routers[ 'Module' ] ]['unlock'] ) ) {
			return TRUE;
		}

		$TimeNow = time( );
		raysn_start_user_session( );
		if ( isset ( $_SESSION['unlock_active'] )
			&& $_SESSION['unlock_active']+ UNLOCK_ACTIVE > $TimeNow ) {
			return $_SESSION['unlock_active']= $TimeNow;
		}

		if ( ! empty ( $_SESSION['unlockfaild'] )
			&& $_SESSION['unlockfaild'] >= 3 ) {
			raysn_clewbox ( language( 'too many failed unlock' ) );
		}

		global $Routers, $Parameters, $CONFIG;
		if ( isset ( $Parameters['unlockpass'] ) )
		{
			if ( raysn_get_pass_encode( $Parameters['unlockpass'] ) == $CONFIG['UNLOCK'] ) {
				return $_SESSION['unlock_active'] = $TimeNow;
			}
			else
			{
				if ( empty ( $_SESSION['unlockfaild'] ) ) {$_SESSION['unlockfaild'] = 0;}
				$User_unlock['message'] = language( 'unlock failed' );
				if ( ( ++ $_SESSION['unlockfaild'] ) >= 3 ) {
					$User_unlock['message'] = language( 'too many failed unlock' );
				}
			}
		}
		$User_unlock['ViewName'] = "User_unlock";
		$User_unlock['JumpLink'] = url( $Routers['Module'] . '/' . $Routers['action'], $Parameters );
		raysn_load_view ( $User_unlock );
	}
	
	function raysn_cost_user_points( $Cost )
	{
		if ( is_numeric( $Cost ) && $Cost > 0 ) {
			if ( raysn_get_user_id( ) == 1 ) {return true;}
			$UserData = raysn_object( 'mysql' )->select_row( 'user', array( 'select'=> '`point`', 'where'=> "`uid`= '" . raysn_get_user_id( ) . "'" ) );
			if ( $UserData['point'] >= $Cost ) {
				return $GLOBALS['OBJECT']['mysql']->update( 'user', array( 'point'=> $UserData['point']- $Cost ), "`uid`= '" . raysn_get_user_id( ) . "'" );
			}
		}
	}
	
	function raysn_add_user_points( $Point )
	{
		if ( is_numeric( $Point ) && $Point > 0 ) {
			if ( $uid = raysn_get_user_id( ) ) {
				$UserData = raysn_object( 'mysql' )->select_row( 'user', array( 'select'=> '`point`', 'where'=> "`uid`= '" . $uid . "'" ) );
				return $GLOBALS['OBJECT']['mysql']->update( 'user', array( 'point'=> $UserData['point']+ $Point ), "`uid`= '" . $uid . "'" );
			}
		}
	}
	
	function raysn_del_user_points( $uid, $Point )
	{
		if ( is_numeric( $Point ) && $Point > 0 ) {
			if ( $uid > 0 ) {
				$UserData = raysn_object( 'mysql' )->select_row( 'user', array( 'select'=> '`point`', 'where'=> "`uid`= '" . $uid . "'" ) );
				return $GLOBALS['OBJECT']['mysql']->update( 'user', array( 'point'=> $UserData['point']- $Point ), "`uid`= '" . $uid . "'" );
			}
		}
	}

	function raysn_get_pass_encode( $passcode )
	{
		return crypt( $passcode, substr( $passcode, 1, -1 ) );
	}
