<?php
/*
	file:	/libraries/string.inc
	modify:	2009/08/22 - 2010/03/27
*/

	function _Check_Strlen( $String, $Minlen, $Maxlen )
	{
		$Strlen= mb_strlen( $String, 'utf-8' );
		return ( $Strlen>= $Minlen && $Strlen<= $Maxlen );
	}

	function _Check_Chrlen( $String, $Minlen, $Maxlen )
	{
		return preg_match( "/^[a-zA-Z0-9\-\_\.:]{{$Minlen},{$Maxlen}}$/", $String );
	}

	function _Check_EmailFormat( $Email )
	{
		return preg_match( "/^[\w-_\.]{3,20}@([a-z0-9\-]+\.)+([a-z]{2,4})$/", $Email );
	}
	
	function ExtName( $FilePath )
	{
		if ( preg_match( "/\.([a-zA-Z\d]+)$/", $FilePath, $_Match ) ) {
			return strtolower( $_Match[1] );
		}
	}
	
	function _Get_PlainText( $Text, $Maxlen= NULL )
	{
		if ( empty ( $Maxlen ) ) {
			$Maxlen = strlen ( $Text );
		}
		return htmlspecialchars( mb_substr( preg_replace( "/(<.+>|\r|\n|\t|\s{3,}|&[a-z]{2,5};)/", '', $Text ), 0, $Maxlen, CHARSET ) );
	}

	function _Get_ImageUrl( &$HtmlText )
	{
		if ( ! preg_match( "/<img[\s\S]+?src=[\\\\'\"]*([a-zA-Z0-9:\.\/\\-_%]+)[\\\\'\"]*[\s\S]*>/", $HtmlText, $Image ) )
			return NULL;
		else
			return $Image[1];
	}

	function _Get_ThumbPath( $FilePath )
	{
		if ( ! preg_match( "/^http:\/\//", $FilePath ) ) {
			$ImageType = ExtName( $FilePath );
			return preg_replace( "/\." . $ImageType . "/i", ".thumb." . $ImageType, $FilePath );
		}
		else {
			return $FilePath;
		}
	}

	function _Make_TimeStamp( $DateTime )
	{
		if ( preg_match( "/^(\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2})$/", $DateTime, $DateMatch ) )
			return mktime( $DateMatch[4], $DateMatch[5], $DateMatch[6], $DateMatch[2], $DateMatch[3], $DateMatch[1] );
		else
			return false;
	}

	function _Make_FileSize( $SizeNumber )
	{
		$SizeName = array( 'B', 'K', 'M', 'G' );
		$SizeCount = 0;

		while ( $SizeCount < 1
			|| $SizeNumber > 1024 && $SizeCount < 4 )
		{
			$SizeNumber /= 1024;
			$SizeCount ++;	
		}

		return number_format( $SizeNumber, 2 ) . $SizeName[ $SizeCount ];
	}

	function _Filter_Quote( $Array )
	{
		if ( is_array ( $Array ) )
			foreach ( $Array as $key => $data )
				$Array[ $key ]= _Filter_Quote( $data );
		else
			$Array = str_replace( '"', '""', $Array );

		return $Array;
	}
