<?php
/*
	file:	/modules/article/add.php
	modify:	2009/02/03 - 2010/05/31
*/

function Article_add( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		require_once './libraries/module.inc';
		require_once './modules/column/column.inc';

		$DataArray['editor'] = raysn_get_user_info( 'name' );
		$DataArray['PassAllowed']= raysn_check_user_permit( 'article', 'pass' );
		$DataArray['ColumnAvailable'] = _Get_ColumnAvailable( 'article' );

		if ( variable_get( 'User_ColumnPermission', 'closed' ) == 'opened'
			&& raysn_get_user_id( ) != 1 )
		{
			require_once './modules/user/user.inc';
			$UserAllowedCids = _Get_UserColumns( raysn_get_user_id() );
			$DataArray['ColumnAvailable'] = array_intersect( $UserAllowedCids, $DataArray['ColumnAvailable'] );
		}

		return $DataArray;
	}
	else
	{
		//1.Check Request
		require_once './modules/column/column.inc';
		$ColumnDatas= _Get_ColumnDatas( );

		//.Check cid
		if ( ! empty ( $p['cid'] ) ) {
			if ( ! empty ( $ColumnDatas[ $p['cid'] ]['pass'] )
				&& $ColumnDatas[ $p['cid'] ]['type'] == 'article' ) {
				if ( raysn_check_user_column( $p['cid'] ) ) {
					$SqlArray['cid']= $p['cid'];
				} else {
					raysn_clewbox( language( 'no permission for the column' ) );
				}
			} else {
				raysn_clewbox( translate( 'can not publish this column' ) );
			}
		} else {
			raysn_clewbox( translate( 'cid empty' ) );
		}

		$SqlArray['pass']= raysn_check_user_permit( 'article', 'pass' );

		//.Check title
		require_once './libraries/string.inc';
		if ( isset ( $p['title'] )
			&& _Check_Strlen( $p['title'], 3, 60 ) ) {
			$SqlArray['title']= trim( $p['title'] );
		}
		else
			raysn_clewbox( translate( 'title empty', array( '@min'=> 3, '@max'=> 60 ) ) );

		//.Check color
		if ( ! empty ( $p['color'] )
			&& ! empty ( $SqlArray['pass'] )
			&& preg_match( "/^([\da-f]{3}|[\da-f]{6})$/", $p['color'] ) ) {
			$SqlArray['color']= $p['color'];
		}

		//.Check text
		if ( ! empty ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 65535 ) )
			$SqlArray2['text']= trim( $p['text'] );
		else
			raysn_clewbox( translate( 'text empty' ) );

		//.Check mark
		if ( ! empty ( $p['mark'] )
			&& ! empty ( $SqlArray['pass'] )
			&& is_array( $p['mark'] ) ) {
			$p['mark']= implode( ',', $p['mark'] );
			if ( preg_match( "/^\d(,\d){0,8}$/", $p['mark'] ) )
				$SqlArray['mark']= $p['mark'];
			else
				raysn_clewbox( translate( 'mark error' ) );
		}

		//.Check keywords
		if ( isset ( $p['keywords'] ) ) {
			if ( _Check_Strlen( $p['keywords'], 0, 60 ) )
				$SqlArray['keywords']= trim( $p['keywords'] );
			else
				raysn_clewbox( translate( 'keywords too many', array( '@max'=> 60 ) ) );
		}

		//.Check description
		if ( ! isset ( $p['description'] )
			|| $p['description'] == NULL ) {
			if ( variable_get( "Article_AutoDescription", "128" ) ) {
				$SqlArray['description']= _Get_PlainText( $SqlArray2['text'], variable_get( "Article_AutoDescription", "128" ) );
			}
		} else {
			if ( _Check_Strlen( $p['description'], 10, 255 ) )
				$SqlArray['description']= trim( $p['description'] );
			else
				raysn_clewbox( translate( 'description length illegal', array( '@min'=> 10, '@max'=> 255 ) ) );
		}
		
		//.Check comments
		if ( isset ( $p['comments'] )
			&& in_array( $p['comments'], array( 0, 1, 2 ) ) ) {
			$SqlArray['comments']= $p['comments'];
		}

		//.Check editor
		if ( ! empty ( $p['editor'] )
			&& _Check_Strlen( $p['editor'], 2, 16 ) )
			$SqlArray['editor']= trim( $p['editor'] );
		else
			raysn_clewbox( translate( 'editor empty' ) );

		//.Check date
		$SqlArray['modified']= time( );
		if ( empty ( $p['pubdate'] ) ) {
			$SqlArray['pubdate'] = $SqlArray['modified'];
		}
		elseif ( ! $SqlArray['pubdate'] = _Make_TimeStamp( $p['pubdate'] ) ) {
			raysn_clewbox ( translate( 'time format error', array( '@time'=> $p['pubdate'] ) ) );
		}

		//.Check image
		if ( isset ( $p['txtUrl'] )
			&& _Check_Strlen( $p['txtUrl'], 20, 255 ) ) {
			$SqlArray['image'] = $p['txtUrl'];
		}
		else {
			$SqlArray['image'] = _Get_ImageUrl( $p['text'] );
		}

		$SqlArray['uid']= raysn_get_user_id( );

		//2.Insert Data
		$MysqlObject= raysn_object( 'mysql' );
		$MysqlObject->insert( 'article', $SqlArray );

		$SqlArray2['aid']= $MysqlObject->_Get_InsertId();
		$MysqlObject->insert( 'article_text', $SqlArray2 );

		//3.Update Column & Article Page
		_Count_Documents( $SqlArray['cid'] );

		if ( $SqlArray['pass'] ) {
			if ( $SqlArray['pubdate'] <= $SqlArray['modified'] ) {
				_Drop_ColumnPages( $SqlArray['cid'] );
			}
			if ( $GLOBALS['CONFIG']['STATIC_LINK'] == 'opened' && INDEX_PATH != '' ) {
				require_once './modules/article/article.inc';
				_Make_ArticlePage( $SqlArray2['aid'] );
			}
		}

		//.Operation Complete
		setcookie ( "Article_cid", $SqlArray['cid'] );
		raysn_clewbox ( translate( 'add success' ), url( 'article/add' ) );
	}
}
