<?php
/*
	file:	/modules/article/article.inc
	modify:	2009/08/22 - 2010/05/17
*/

	function _Check_ArticlePassStatus( $aid )
	{
		return raysn_object( 'mysql' )
			->select_row( 'article', array( 'select'=> 1, 'where'=> "`aid`= '$aid' && `pass`= 1 && `pubdate`<= " . time() ) );
	}

	function _Check_ArticleAllowComments( $aid )
	{
		return raysn_object( 'mysql' )
			->select_row( 'article', array( 'select'=> '`comments`', 'where'=> "`aid`= '$aid' && `pass`= 1 && `pubdate`<= " . time() ) );
	}

	function _Get_ArticleByTitle( $title )
	{
		return raysn_object( 'mysql' )
			->select_row( 'article', array( 'select'=> 'cid', 'where'=> "`title`= '$title'" ) );
	}

	function _Get_ArticleData( $aid )
	{
		static $Articles;
		if ( empty ( $Articles[ $aid ] ) ) {
			$Articles[ $aid ] = raysn_object( 'mysql' )
			->select_row( 'article', array(
				'select'=> '`article`.*,`article_text`.`text`',
				'join'=> array(	'table'=> 'article_text', 'way'=> 'left', 'on'=> 'aid' ),
				'where'=> "`article`.`aid`= '$aid'" )
			);
		}

		return $Articles[ $aid ];
	}

	function _Get_ArticleCount( $cid )
	{
		return raysn_object( 'mysql' )
			->select_count( 'article', "`cid`= '$cid'" );
	}
	
	function _Move_ArticleColumn( $cid, $movecid )
	{
		foreach ( raysn_object( 'mysql' )
			->select( 'article', array( 'select'=> '`aid`', 'where'=> "`cid`= '$cid'" ) ) as $article ) {
			$Moveaid[] = $article['aid'];
		}
		if ( isset ( $Moveaid ) ) {
			return $GLOBALS['OBJECT']['mysql']->update( 'article', array( 'cid'=> $movecid ), "`aid` IN( ". implode( ',', $Moveaid ) ." )" );
		} else
			return TRUE;
	}

	function translateMark( $Mark )
	{
		if ( empty ( $Mark ) ) {
			return '';
		}

		$MarkTitles= translate( 'marktitle' );
		foreach ( explode( ',', $Mark ) as $mark ) {
			$Marks[ ] = $MarkTitles[ $mark ];
		}
		return '[' . implode( ',', $Marks ) . ']';
	}
	
	function _Get_ArticlePagePath( $aid )
	{
		static $ArticlePath;
		if ( empty ( $ArticlePath[ $aid ] ) ) {
			$ArticlePath[ $aid ] = "article/" . substr( $aid, 0, -2 ) ."/". $aid .".html";
		}
		return $ArticlePath[ $aid ];
	}

	function _Get_ArticleStat( )
	{
		require_once './libraries/string.inc';
		return array(
			'total'=> raysn_object( 'mysql' )->select_count( 'article' ),
			'today'=> $GLOBALS['OBJECT']['mysql']->select_count( 'article', '`pubdate`> '. _Make_TimeStamp( date( 'Y-m-d' ). ' 00:00:00' ) ),
			'yesterday'=> $GLOBALS['OBJECT']['mysql']->select_count( 'article', '`pubdate`< '. _Make_TimeStamp( date( 'Y-m-d' ). ' 00:00:00' ) .' && `pubdate`> '. _Make_TimeStamp( date( 'Y-m-d', time()- 86400 ). ' 00:00:00' ) ),
		);
	}

	function _Make_ArticlePage( $aid )
	{
		$article = _Get_ArticleData( $aid );
		$article['pubdate'] = date( variable_get( "Article_PubdateFormat", "Y-m-d H:i:s" ), $article['pubdate'] );
		require_once './modules/column/column.inc';
		$column = _Get_ColumnById( $article[ 'cid' ] );

		return raysn_object( 'make' )
			->_Set_Var( 'column', $column )
			->_Set_Var( 'article', $article )
			->_Set_Tpl( $column['TextTemplate'] )
			->_Set_Url( url( "article/$aid" ) )
			->_Make_File( raysn_get_archives_path( 'article', $aid ) );
	}
	
	function _Drop_ArticlePage( $aid )
	{
		return raysn_object( 'file' )
			->path( './archives/' . raysn_get_archives_path( 'article', $aid ) )
			->delete( );
	}
