<?php
/*
	file:	/modules/article/edit.php
	modify:	2009/02/08 - 2010/05/31
*/

function Article_edit( &$p )
{
	//1.Check Request
	if ( empty ( $p['id'] )
		|| ! is_numeric( $p['id'] ) ) {
		raysn_clewbox ( translate( 'article id empty' ) );
	}

	require_once './modules/article/article.inc';
	if ( ! $Article= _Get_ArticleData( $p['id']  ) ) {
		raysn_clewbox ( translate( 'article not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		//.Get Column Option
		require_once './libraries/module.inc';
		require_once './modules/column/column.inc';

		$Article['title'] = htmlspecialchars( $Article['title'] );

		//.Process Mark
		if ( empty ( $Article['mark'] ) )
			$Article['mark']= array();
		else
			$Article['mark']= explode( ',', $Article['mark'] );
		$Article['text'] = htmlspecialchars( $Article['text'] );
		$Article['keywords'] = htmlspecialchars( $Article['keywords'] );
		$Article['description'] = htmlspecialchars( $Article['description'] );
		$Article['PassAllowed']= raysn_check_user_permit( 'article', 'pass' );
		$Article['ColumnAvailable'] = _Get_ColumnAvailable( 'article' );

		if ( variable_get( 'User_ColumnPermission', 'closed' ) == 'opened'
			&& raysn_get_user_id( ) != 1 )
		{
			require_once './modules/user/user.inc';
			$UserAllowedCids = _Get_UserColumns( raysn_get_user_id() );
			$Article['ColumnAvailable'] = array_intersect( $UserAllowedCids, $Article['ColumnAvailable'] );
		}

		return $Article;
	}
	else
	{
		//1.Check Request
		$SqlArray['pass'] = raysn_check_user_permit( 'article', 'pass' );
		if ( raysn_get_user_id() != $Article['uid'] && ! $SqlArray['pass'] ) {
			raysn_clewbox( translate( 'you can not edit others' ) );
		}
		require_once './modules/column/column.inc';

		//.Check cid
		if ( ! empty ( $p['cid'] )
			&& $p['cid'] != $Article['cid'] )
		{
			$ColumnDatas= _Get_ColumnDatas( );
			if ( ! empty ( $ColumnDatas[ $p['cid'] ]['pass'] )
				&& $ColumnDatas[ $p['cid'] ]['type'] == 'article' ) {
				if ( raysn_check_user_column( $p['cid'] ) ) {
					$SqlArray['cid']= $p['cid'];
				} else
					raysn_clewbox( language( 'no permission for the column' ) );
			} else
				raysn_clewbox( translate( 'can not publish this column' ) );
		}

		require_once './libraries/string.inc';

		//.Check title
		if ( isset ( $p['title'] )
			&& $p['title'] != $Article['title'] )
		{
			if ( _Check_Strlen( $p['title'], 3, 60 ) ) {
				$SqlArray['title']= trim( $p['title'] );
			}
			else
				raysn_clewbox( translate( 'title empty', array( '@min'=> 3, '@max'=> 60 ) ) );
		}

		//.Check color
		if ( isset ( $p['color'] )
			&& ! empty ( $SqlArray['pass'] )
			&& $p['color'] != $Article['color']
			&& preg_match( "/^([\da-f]{3}|[\da-f]{6})$/", $p['color'] ) ) {
			$SqlArray['color']= $p['color'];
		}

		//.Check text
		if ( ! empty ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 65535 ) )
			$SqlArray2['text']= trim( $p['text'] );
		else
			raysn_clewbox( translate( 'text empty' ) );

		//.Check mark
		if ( ! empty ( $SqlArray['pass'] ) )
		{
			if ( ! empty ( $p['mark'] )
				&& is_array( $p['mark'] ) ) {
				$p['mark']= implode( ',', $p['mark'] );
				if ( preg_match( "/^\d(,\d){0,8}$/", $p['mark'] ) )
					$SqlArray['mark'] = $p['mark'];
				else
					raysn_clewbox( translate( 'mark error' ) );
			}
			else {
				$SqlArray['mark'] = NULL;
			}
		}

		//.Check keywords
		if ( isset ( $p['keywords'] ) ) {
			if ( _Check_Strlen( $p['keywords'], 0, 60 ) )
				$SqlArray['keywords']= trim( $p['keywords'] );
			else
				raysn_clewbox( translate( 'keywords too many', array( '@max'=> 60 ) ) );
		}

		//.Check description
		if ( isset ( $p['description'] ) ) {
			if ( $p['description'] != NULL ) {
				if ( _Check_Strlen( $p['description'], 10, 255 ) )
					$SqlArray['description']= trim( $p['description'] );
				else
					raysn_clewbox( translate( 'description length illegal', array( '@min'=> 10, '@max'=> 255 ) ) );
			}
			elseif ( variable_get( "Article_AutoDescription", "128" ) ) {
				$SqlArray['description']= _Get_PlainText( $SqlArray2['text'], variable_get( "Article_AutoDescription", "128" ) );
			}
		}
		
		//.Check comments
		if ( isset ( $p['comments'] )
			&& $p['comments'] != $Article['comments']
			&& in_array( $p['comments'], array( 0, 1, 2 ) ) ) {
			$SqlArray['comments']= $p['comments'];
		}

		//.Check editor
		if ( isset ( $p['editor'] )
			&& $p['editor'] != $Article['editor'] )
		{
			if ( _Check_Strlen( $p['editor'], 2, 16 ) )
				$SqlArray['editor']= trim( $p['editor'] );
			else
				raysn_clewbox( translate( 'editor empty' ) );
		}

		//.Check date
		$SqlArray['modified'] = time( );
		if ( isset ( $p['pubdate'] )
			&& $p['pubdate'] != $Article['pubdate'] )
		{
			if ( $pubdate = _Make_TimeStamp( $p['pubdate'] ) )
				$SqlArray['pubdate'] = $pubdate;
			else
				raysn_clewbox ( translate( 'time format error', array( '@time'=> $p['pubdate'] ) ) );
		}

		//.Check image
		if ( isset ( $p['txtUrl'] )
			&& _Check_Strlen( $p['txtUrl'], 20, 255 ) ) {
			$SqlArray['image'] = $p['txtUrl'];
		}
		else {
			$SqlArray['image'] = _Get_ImageUrl( $p['text'] );
		}

		//2.Update Data
		$MysqlObject= raysn_object( 'mysql' );
		$MysqlObject->update( 'article', $SqlArray, "`aid`= '{$p['id']}'");
		$MysqlObject->update( 'article_text', $SqlArray2, "`aid`= '{$p['id']}'");

		//3.Update Column
		if ( ! empty ( $p['cid'] )
			&& $p['cid']!= $Article['cid'] ) {
			_Count_Documents( $p['cid'] );//Update New Column
			_Count_Documents( $Article['cid'] );//Update Old Column
		}

		//.Update Page
		if ( $SqlArray['pass'] ) {
			if ( isset ( $SqlArray['cid'] )
				|| $SqlArray['mark'] != $Article['mark']
				|| $SqlArray['pass'] != $Article['pass']
				|| isset ( $SqlArray['title'] )
				|| isset ( $SqlArray['pubdate'] ) ) {
				_Drop_ColumnPages( $SqlArray['cid'] );
			}
			if ( $GLOBALS['CONFIG']['STATIC_LINK'] == 'opened' && INDEX_PATH != '' ) {
				_Make_ArticlePage( $p['id'] );
			}
			else {
				_Drop_ArticlePage( $p['id'] );
			}
		}

		
		//.Update Comment
		if ( isset ( $SqlArray['title'] ) ) {
			require_once './libraries/module.inc';
			if ( _Check_ModuleEnabled( 'comment' ) ) {
				require_once './modules/comment/comment.inc';
				_Set_CommentTitle( 'article', $p['id'], $SqlArray['title'] );
			}
		}

		//.Operation Complete
		raysn_clewbox ( translate( 'edit success' ) );
	}
}
