<?php
/*
	file:	/modules/article/move.php
	modify:	2009/03/10 - 2010/03/12
*/

function Article_move( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		//.Check aids
		if ( ! empty ( $p['aids'] )
			&& is_array( $p['aids'] ) ) {
			$DataArray['aids']= implode( ',', $p['aids'] );
			if ( ! preg_match( "/^\d+(,\d+)*$/", $DataArray['aids'] ) ) {
				raysn_clewbox ( translate( 'article id error' ) );
			}
		}
		else
			raysn_clewbox ( translate( 'article id empty' ) );

		if ( ! $DataArray['Articles']= raysn_object( 'mysql' )
			->select( 'article', array( 'select'=> '`aid`,`cid`,`title`,`pubdate`', 'where'=> "`aid` IN ( " . $DataArray['aids'] . " )" ) ) ) {
			raysn_clewbox ( translate( 'article not exist' ), url( 'article/main' ) );
		}

		require_once './modules/column/column.inc';
		$DataArray['ColumnDatas']= _Get_ColumnDatas( );
		$DataArray['ColumnAvailable'] = _Get_ColumnAvailable( 'article' );

		if ( variable_get( 'User_ColumnPermission', 'closed' ) == 'opened'
			&& raysn_get_user_id( ) != 1 )
		{
			require_once './modules/user/user.inc';
			$UserAllowedCids = _Get_UserColumns( raysn_get_user_id() );
			$DataArray['ColumnAvailable'] = array_intersect( $UserAllowedCids, $DataArray['ColumnAvailable'] );
		}

		return $DataArray;
	}
	else
	{
		//1.Check Request
		//Check cid
		require_once './modules/column/column.inc';
		$ColumnDatas= _Get_ColumnDatas( );
		if ( empty ( $p['cid'] )
			|| empty ( $ColumnDatas[ $p['cid'] ]['pass'] )
			|| $ColumnDatas[ $p['cid'] ]['type'] != 'article' ) {
			raysn_clewbox( translate( 'cid empty' ) );
		}

		raysn_check_user_column( $p['cid'] );

		//Check aids
		if ( empty ( $p['aids'] )
			|| ! preg_match( "/^\d+(,\d+)*$/", $p['aids'] ) )
			raysn_clewbox ( translate( 'article id error' ) );

		if ( ! $Articles= raysn_object( 'mysql' )
			->select( 'article', array( 'select'=> '`aid`,`cid`', 'where'=> "`aid` IN ( " . $p['aids'] . " )" ) ) )
			raysn_clewbox ( translate( 'article not exist' ) );

		//2.Update Data
		require_once './modules/article/article.inc';
		foreach ( $Articles as $article ) {
			_Drop_ArticlePage( $article['aid'] );
			$GLOBALS['OBJECT']['mysql']->update( 'article', array( 'cid'=> $p['cid'] ), "`aid`= '{$article['aid']}'");
		}

		//.Count Column
		_Count_Documents( $p['cid'] );

		foreach ( $Articles as $article ) {
			if ( empty ( $cids[ $article['cid'] ] ) ) {
				_Count_Documents( $article['cid'] );
				$cids[ $article['cid'] ]= true;
			}
		}
		
		//3.Operation Complete
		_Drop_ColumnPages( );
		variable_set( 'UPDATE_COLUMN_TIMESTAMP', time( ) );
		raysn_clewbox ( translate( 'move success' ), url( 'article/main' ) );
	}
}
