<?php
/*
	file:	/modules/attachment/delete.php
	modify:	2009/04/29 - 2012/02/27
*/

function Attachment_delete( &$p )
{
	//Check Attachment
	if ( empty ( $p['id'] )
		|| ! in_array ( $p['id'], array( 'image', 'flash', 'files' ) )
		|| ! isset ( $p['page'] )
		|| ! is_numeric ( $p['page'] ) ) {
		raysn_clewbox ( translate( 'attachment id empty' ) );
	}

	//Check file type
	switch ( $p['id'] )
	{
		case 'image' :
			$AttachmentTable= 'attachment_image';
			$GetAttachment	= '_Get_AttachmentImageById';
			break;

		case 'flash' :
			$AttachmentTable= 'attachment_flash';
			$GetAttachment	= '_Get_AttachmentFlashById';
			break;

		case 'files' :
			$AttachmentTable= 'attachment';
			$GetAttachment	= '_Get_AttachmentById';
			break;

		default :
	}
		
	require_once './modules/attachment/attachment.inc';
	if ( ! $Attachment = $GetAttachment( $p['page'] ) ) {
		raysn_clewbox ( translate( 'attachment not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		if ( $p['id']== 'image' ) {
			$Attachment['ImagePath'] = ROOT_DIR . 'archives/attachment/image/' . preg_replace( "/^(\d+)\d{2}$/", "\\1/", $Attachment['aid'] ) . $Attachment['file'];
		}

		require_once './modules/user/user.inc';
		return $Attachment;
	}
	else
	{
		//Remove attachment
		$FileObject = raysn_object( 'file' )
			->path( './archives/attachment/' . $p['id'] . preg_replace( "/^(\d+)\d{2}$/", "/\\1/", $Attachment['aid'] ) . $Attachment['file'] );
		
		if ( $p['id']== 'image' ) {
			require_once './libraries/string.inc';
			$FileObject->delete( );
			$FileObject->path( _Get_ThumbPath( $FileObject->path() ) )->delete( );
		}
		else {
			$FileObject->delete( );
		}

		raysn_object( 'mysql' )->delete( $AttachmentTable, "`aid`= " . $Attachment['aid'] );

		//Operation Complete
		raysn_clewbox ( translate( 'delete attachment success' ), url( 'attachment/main/' . $p['id'] ) );
	}
}
