<?php
/*
	file:	/modules/attachment/list.php
	modify:	2009/04/07 - 2010/03/29
*/

function Attachment_list( &$p )
{
	if ( isset ( $p['id'] )
		&& in_array ( $p['id'], array( 'image', 'flash', 'files' ) ) ) {
		$DataArray['ViewName'] = 'attachment_' . $p['id'];
	}
	else {
		raysn_clewbox ( translate( 'list type empty' ) );
	}

	//Get File list
	$AttachmentDirPath = './archives/attachment/'. $p['id'] .'/';

	switch ( $p['id'] )
	{
		case 'image' :
			require_once './libraries/string.inc';
			$AttachmentTable = 'attachment_image';
			break;

		case 'flash' :
			$AttachmentTable = 'attachment_flash';
			break;

		default :
			$AttachmentTable = 'attachment';
	}

	//Get Dir list
	$DataArray['AttachmentDirs'] = raysn_object( 'file' )
		->path( $AttachmentDirPath )
		->dirs( );

	//Set Dir path
	if ( empty ( $p['path'] )
		|| ! is_numeric( $p['path'] )
		|| ! is_dir ( $AttachmentDirPath . $p['path'] ) ) {
		$p['path']= end( $DataArray['AttachmentDirs'] );
	}

	$DataArray['path'] = $p['path'];
	$DataArray['AttachmentList']= raysn_object( 'mysql' )
		->select( $AttachmentTable, array(
			'select'=> '`name`,`file`,`type`,`size`',
			'where'=> "`aid`>= '" . ($p['path'] * 100) . "' && `aid`< '" . ($p['path'] * 100 + 100) . "'",
			'order'=> "`aid`"
		) );

	$AttachmentFiles= $GLOBALS['OBJECT']['file']
		->path( $AttachmentDirPath . $p['path'] . '/' )
		->files( );

	foreach ( $DataArray['AttachmentList'] as $k=> $attachment ) {
		if ( ! in_array( $attachment['file'], $AttachmentFiles ) ) {
			unset ( $DataArray['AttachmentList'][ $k ] );
		}
	}

	return $DataArray;
}
