<?php
/*
	file:	/modules/attachment/modify.php
	modify:	2009/04/07 - 2012/03/06
*/

function Attachment_modify( &$p )
{
	//Check Attachment
	if ( empty ( $p['id'] )
		|| ! in_array ( $p['id'], array( 'image', 'flash', 'files' ) )
		|| ! isset ( $p['page'] )
		|| ! is_numeric ( $p['page'] ) ) {
		raysn_clewbox ( translate( 'attachment id empty' ) );
	}

	//Check file type
	switch ( $p['id'] )
	{
		case 'image' :
			$AttachmentTable= 'attachment_image';
			$GetAttachment	= '_Get_AttachmentImageById';
			break;

		case 'flash' :
			$AttachmentTable= 'attachment_flash';
			$GetAttachment	= '_Get_AttachmentFlashById';
			break;

		case 'files' :
			$AttachmentTable= 'attachment';
			$GetAttachment	= '_Get_AttachmentById';
			break;

		default :
	}
		
	require_once './modules/attachment/attachment.inc';
	if ( ! $Attachment = $GetAttachment( $p['page'] ) ) {
		raysn_clewbox ( translate( 'attachment not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		if ( $p['id']== 'image' ) {
			$Attachment['ImagePath'] = ROOT_DIR . 'archives/attachment/image/' . preg_replace( "/^(\d+)\d{2}$/", "\\1/", $Attachment['aid'] ) . $Attachment['file'];
		}

		require_once './modules/user/user.inc';
		$Attachment['type']= $p['id'];
		return $Attachment;
	}
	else
	{
		require_once './libraries/string.inc';

		//.Check name
		if ( isset ( $p['name'] )
			&& $p['name'] != $Attachment['name'] )
		{
			if ( ! _Check_Strlen( $p['name'], 1, 32 ) )
				raysn_clewbox ( translate( 'name format error', array( '@min'=> 1, '@max'=> 32 ) ) );
			elseif ( _Check_AttachmentExist( $p['name'] ) )
				raysn_clewbox ( translate( 'name already exist' ) );
			else
				$SqlArray['name'] = $p['name'];
		}

		//.Check file
		if ( isset ( $p['file'] )
			&& $p['file'] != $Attachment['file'] )
		{
			if ( ! preg_match( "/^[\w-_\.]{1,32}\.{$Attachment['type']}$/", $p['file'] ) )
				raysn_clewbox ( translate( 'file name error', array( '@min'=> 1, '@max'=> 32 ) ) );
			elseif ( raysn_object( 'file' )
				->path( './archives/attachment/' . $p['id'] . preg_replace( "/^(\d+)\d{2}$/", "/\\1/", $Attachment['aid'] ) . $p['file'] )
				->file_exists( ) )
				raysn_clewbox ( translate( 'file already exist' ) );
			else
			{
				$SqlArray['file'] = $p['file'];
				$GLOBALS['OBJECT']['file']
					->path( $GLOBALS['OBJECT']['file']->dirpath() . $Attachment['file'] );

				if ( $p['id'] == 'image' ) {
					require_once './libraries/string.inc';
					$GLOBALS['OBJECT']['file']->rename( $SqlArray['file'] );
					$GLOBALS['OBJECT']['file']
						->path( _Get_ThumbPath( $GLOBALS['OBJECT']['file']->path() ) )
						->rename( _Get_ThumbPath( $SqlArray['file'] ) );
				}
				else {
					$GLOBALS['OBJECT']['file']->rename( $SqlArray['file'] );
				}
			}
		}
		
		if ( empty ( $SqlArray ) ) {
			raysn_clewbox ( translate( 'name no change' ) );
		}
	
		//Insert data to Mysql
		raysn_object( 'mysql' )->update( $AttachmentTable, $SqlArray, "`aid`= " . $Attachment['aid'] );

		//Operation Complete
		raysn_clewbox ( translate( 'modify attachment success' ), url( "attachment/main/". $p['id'] ) );
	}
}
