<?php
/*
	file:	/modules/attachment/upload.php
	modify:	2009/04/07 - 2010/04/23
*/

function Attachment_upload( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		$FileTypes = variable_get( 'Attachment_files_AllowdType', 'doc,xls,ppt' );
		return array(
			'PHPSESSID'=> $_COOKIE[ session_name() ],
			'MAXUPLOAD'=> ini_get( "upload_max_filesize" ),
			'FILETYPES'=> $FileTypes? '*.'.str_replace( ',', ';*.', $FileTypes ): ''
		);
	}
	else
	{
		//Check upload file
		if ( ! $UploadObject= raysn_object( 'upload' )
			->_Set_Uploadinfo( 'UploadAttachment' ) ) {
			raysn_clewbox ( translate( 'file empty' ) );
		}

		//Check file type
		if ( ! isset ( $p['id'] ) ) {
			$FileTypes = array(
				'image'=> array( 'jpg','gif','png' ),
				'flash'=> array( 'swf' ),
				'files'=> explode( ',', variable_get( 'Attachment_files_AllowdType', 'doc,xls,ppt' ) )
				);
			foreach ( $FileTypes as $type=> $filetypes ) {
				if ( in_array( $UploadObject->UploadfileType, $filetypes ) ) {
					$p['id'] = $type;
					break;
				}
			}
		}

		//Check file type
		switch ( $p['id'] )
		{
			case 'image' :
				$AllowedTypes	= array( 'jpg','gif','png' );
				$AttachmentTable= 'attachment_image';
				$CheckNameExist = '_Check_AttachmentImageExist';
				break;

			case 'flash' :
				$AllowedTypes	= array( 'swf' );
				$AttachmentTable= 'attachment_flash';
				$CheckNameExist = '_Check_AttachmentFlashExist';
				break;

			case 'files' :
				$AllowedTypes	= explode( ',', variable_get( 'Attachment_files_AllowdType', 'doc,xls,ppt' ) );
				$AttachmentTable= 'attachment';
				$CheckNameExist = '_Check_AttachmentExist';
				break;

			default :
				raysn_clewbox ( translate( 'all type disallowed' ) );
		}

		if ( ! in_array( $UploadObject->UploadfileType, $AllowedTypes ) ) {
			raysn_clewbox ( translate( 'this type disallowed', array( '@type'=> $p['id'], '@file'=> $UploadObject->UploadfileType ) ) );
		}

		//.Check file name
		require_once './modules/attachment/attachment.inc';
		$AttachmentName = preg_replace( "/(\.[a-zA-Z]+)?\.[a-zA-Z]+$/", '', $UploadObject->UploadfileInfo['name'] );
		if ( $CheckNameExist( $AttachmentName ) ) {
			$NextNumber = 2;
			while ( $CheckNameExist( $AttachmentName. ' (' .$NextNumber. ')' ) ) {
				$NextNumber ++;
			}
			$AttachmentName .= ' (' .$NextNumber. ')';
		}

		$AttachmentFile= md5( microtime() ) . strtolower( substr( $UploadObject->UploadfileInfo['name'], strlen( $AttachmentName ) ) );

		//Insert data
		require_once './libraries/string.inc';
		raysn_object( 'mysql' )
			->insert( $AttachmentTable, array
			(
				'uid' => raysn_get_user_id( ),
				'name'=> $AttachmentName,
				'file'=> $AttachmentFile,
				'type'=> $UploadObject->UploadfileType,
				'size'=> _Make_FileSize( $UploadObject->UploadfileInfo['size'] ),
				'time'=> time( )
			) );

		//Check attachment dir
		$ArchivesDir = './archives/';
		$AttachmentPath = 'attachment/'. $p['id'] . preg_replace( "/^(\d+)\d{2}$/", "/\\1", $GLOBALS['OBJECT']['mysql']->_Get_InsertId( ) ) . '/';

		if ( ! is_dir( $ArchivesDir . $AttachmentPath ) ) {
			$Dirpath = $ArchivesDir;
			$FileObject = raysn_object( 'file' );
			foreach ( explode( '/', trim( $AttachmentPath, '/' ) ) as $dirname ) {
				$Dirpath .= $dirname . '/';
				if ( ! is_dir ( $Dirpath ) ) {
					$FileObject->path( $Dirpath )->mkdir( );
				}
			}
		}

		//Save Upload attachment
		if ( ! $UploadObject->_Save_Uploadfile( $ArchivesDir . $AttachmentPath . $AttachmentFile ) ) {
			raysn_clewbox ( translate( 'dir not writeable', array( '@dir'=> $ArchivesDir . $AttachmentPath ) ) );
		}

		//Zoom Image file
		if ( $p['id']== 'image' ) {
			if ( raysn_object( 'image' )->_Set_Imageinfo( $UploadObject->UploadfilePath ) ) {
				$GLOBALS['OBJECT']['image']->_Zoom_Imagefile( );
			}
		}

		//Operation Complete
		if ( isset ( $p['refer'] ) ) {
			raysn_clewbox ( translate( 'upload attachment success' ), url( trim( $p['refer'], '/' ) ) );
		} else {
			raysn_clewbox ( translate( 'upload attachment success' ), url( "attachment/main/" . $p['id'] ) );
		}
	}
}
