<?php
/*
	file:	/modules/block/make.php
	modify:	2009/02/28 - 2009/12/17
*/

function Block_make( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) ) {
		return array( );
	}	
	else
	{
		//.Check Request
		require_once './libraries/string.inc';
		require_once './modules/block/block.inc';

		//Check Title
		if ( isset ( $p['title'] )
			&& _Check_Strlen( $p['title'], 2, 16 ) )
		{
			if ( ! _Check_BlockTitleExist( $p['title'] ) )
				$SqlArray['title']= htmlspecialchars( trim( $p['title'] ) );
			else
				raysn_clewbox ( translate( 'title already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'title length illegal' ) );

		//Check BlockName
		if ( isset ( $p['name'] )
			&& _Check_Chrlen( $p['name'], 3, 16 ) )
		{
			if ( ! _Check_BlockNameExist( $p['name'] ) )
				$SqlArray['name']= $p['name'];
			else
				raysn_clewbox ( translate( 'name already exist' ) );
		}
		else
			raysn_clewbox ( translate( 'name format error' ) );

		$SqlArray['created']= $SqlArray['changed']= time( );

		//.Insert Data
		raysn_object( 'mysql' )->insert( 'block', $SqlArray );
		$bid = $GLOBALS['OBJECT']['mysql']->_Get_InsertId( );

		//.Make Cache
		_Make_BlockCache( $p['name'] );

		//.Operation Complete
		watchdog( 'creating a block', array( '@block'=> $SqlArray['title'], '@name'=> $SqlArray['name'] ) );
		raysn_clewbox ( translate( 'make block success' ), url( 'block/' . $bid . '/edit' ) );
	}
}
