<?php
/*
	file:	/modules/column/column.inc
	modify:	2009/02/12 - 2010/05/17
*/

	function _Check_ColumnPassStatus( $cid )
	{
		return raysn_object( 'mysql' )
			->select_row( 'column', array( 'select'=> '1', 'where'=> "`cid`= '$cid'" ) );
	}
	
	function _Check_ColumnSubExist( $cid )
	{
		return raysn_object( 'mysql' )
			->select_count( 'column', "`pid`= '$cid'" );
	}
	
	function _Check_IsSubColumn( $cid, $cid2 )
	{
		$ColumnDatas = _Get_ColumnDatas( );
		while ( $ColumnDatas[ $cid2 ]['pid'] ) {
			if ( $ColumnDatas[ $cid2 ]['pid'] == $cid ) {
				return TRUE;
			}
			$cid2 = $ColumnDatas[ $cid2 ]['pid'];
		}
	}

	function _Get_ColumnById( $ColumnId )
	{
		return raysn_object( 'mysql' )
			->select_row( 'column', array( 'where'=> "`cid`= '$ColumnId'" ) );
	}

	function _Get_ColumnByName( $ColumnName )
	{
		return raysn_object( 'mysql' )
			->select_row( 'column', array( 'select'=> '`pid`,`name`', 'where'=> "`name`= '$ColumnName'" ) );
	}

//
	function _Get_ColumnDatas( )
	{
		static $ColumnDatas;
		if ( empty ( $ColumnDatas ) ) {
			if ( ! raysn_object( 'cache' )
				->path( 'column.datas.inc' )->CacheExist( ) )
			{
				$ColumnDatas= array( );
				foreach ( raysn_object( 'mysql' )
				->select('column', array( 'select'=> '`cid`,`pid`,`pass`,`type`,`sort`,`name`,`HomeTemplate`,`ListTemplate`,`TextTemplate`' ) ) as $Column ) {
					$ColumnDatas[ $Column['cid'] ]= $Column;
				}

				$GLOBALS['OBJECT']['cache']->text( serialize ( $ColumnDatas ) );
			}
			$ColumnDatas = unserialize ( $GLOBALS['OBJECT']['cache']->text( ) );
		}

		return $ColumnDatas;
	}
	
	function _Get_ColumnModuleTypes( )
	{
		$ModuleTypes = unserialize( variable_get( 'Column_ModuleTypes', serialize( array() ) ) );
		if ( empty ( $Column_ModuleTypes ) ) {
			require_once './libraries/module.inc';
			foreach ( _Get_ModuleList( ) as $Module ) {
				if ( isset( $Module['depend'] )
					&& $Module['depend']== 'column'
					&& _Check_ModuleInstalled( $Module['name'] ) ) {
					$ModuleTypes[ $Module['name'] ] = $Module['title'];
				}
			}
			if ( ! empty ( $ModuleTypes ) ) {
				variable_set( 'Column_ModuleTypes', serialize( $ModuleTypes ) );
			}
		}
		return $ModuleTypes;
	}

	function _Get_ColumnAvailable( $type= NULL )
	{
		$SqlWhere= '`pass`= 1';
		if ( ! empty ( $type ) ) {
			$SqlWhere.= " && `type`= '$type'";
		}
		foreach ( raysn_object( 'mysql' )
			->select( 'column', array( 'select'=> 'cid', 'where'=> $SqlWhere ) ) as $column ) {
			$ColumnAvailable[]= $column['cid'];
		}
		return isset ( $ColumnAvailable )? $ColumnAvailable:  array();
	}

	function _Get_ColumnDisabled( $type= NULL )
	{
		$SqlWhere= '`pass`= 0';
		if ( ! empty ( $type ) ) {
			$SqlWhere.= " && `type`= '$type'";
		}
		foreach ( raysn_object( 'mysql' )
			->select( 'column', array( 'select'=> 'cid', 'where'=> $SqlWhere ) ) as $column ) {
			$ColumnDisabled[]= $column['cid'];
		}
		return isset ( $ColumnDisabled )? $ColumnDisabled:  array();
	}

	function _Get_ColumnsByType( $type )
	{
		foreach ( raysn_object( 'mysql' )
			->select( 'column', array( 'select'=> 'cid', 'where'=> "`type`= '$type'" ) ) as $column ) {
			$ColumnSameType[]= $column['cid'];
		}
		return isset ( $ColumnSameType )? $ColumnSameType: array();
	}

//
	function _Get_ColumnOptionGroup( $type= 'column' )
	{
		if ( ! raysn_object( 'cache' )
			->path( $type . '.option.inc' )->CacheExist( ) )
		{
			_Drop_ColumnCache( );
			if ( $type!= 'column' ) {
				$GLOBALS['OBJECT']['cache']->path( $type . '.option.inc' )->text( _OptionGroup_Cache( $type ) );
			} else {
				$GLOBALS['OBJECT']['cache']->path( $type . '.option.inc' )->text( _OptionGroup_Cache( ) );
			}
		}

		return $GLOBALS['OBJECT']['cache']->text( );
	}

	function _OptionGroup_Cache( $type= NULL, $pid= 0, $indent= NULL )
	{
		$CacheCode= NULL;
		foreach ( raysn_object( 'mysql' )->select( 'column', array(
				'select'=> '`cid`,`pid`,`name`',
				'where'=> "`pid`= '$pid'". ( ! empty ( $type )? " && `type`= '$type'":'' ),
				'order'	=> '`sort`,`cid`', 'way'=> 'ASC'
			) ) as $column ) {
			$CacheCode .= '<option value="' . $column['cid'] . '">' . $indent . $column['name'] . '</option>';
			if ( _Check_ColumnSubExist( $column['cid'] ) ) {
				$CacheCode .= _OptionGroup_Cache( $type, $column['cid'], '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $indent );
			}
		}

		return $CacheCode;
	}

//
	function _Get_ColumnPath( $cid )
	{
		if ( ! is_numeric( $cid ) ) {
			return NULL;
		}

		$ColumnDatas = _Get_ColumnDatas( );
		$ColumnPaths = array( );
		while ( $ColumnDatas[ $cid ]['pid'] ) {
			$cid = $ColumnDatas[ $cid ]['pid'];
			$ColumnPaths[]= $ColumnDatas[ $cid ];
		}

		return $ColumnPaths;
	}

	function _Count_Documents( $cid )
	{
		if ( $column = _Get_ColumnById( $cid ) ) {
			empty ( $column['type'] ) && $column['type']= 'article';
			require_once './modules/'. $column['type'] .'/'. $column['type'] .'.inc';
			$Count= call_user_func( '_Get_'. $column['type'] .'Count', $cid );
			raysn_object( 'mysql' )->update( 'column', array( 'documents'=> $Count ), "`cid`= '$cid'" );
		}
	}

	function _Make_ColumnPage( $cid )
	{
		$column = _Get_ColumnById( $cid );
		return raysn_object( 'make' )
			->_Set_Var( 'column', $column )
			->_Set_Tpl( $column['HomeTemplate'] )
			->_Set_Url( url( "column/$cid" ) )
			->_Make_File( "column/$cid.html" );
	}

	function _Drop_ColumnPages( &$cid= NULL )
	{
		//.Drop homepage Cache
		raysn_object( 'file' )
			->path( './archives/column/index.php' )
			->delete( );

		//.Make column
		if ( empty ( $cid ) ) {
			return '';
		}
		if ( is_numeric ( $cid ) ) {
			$GLOBALS['OBJECT']['file']
				->path( './archives/column/'.$cid.'.html' )
				->delete( );
			foreach ( _Get_ColumnPath( $cid ) as $column ) {
				$GLOBALS['OBJECT']['file']
					->path( './archives/column/'.$column['cid'].'.html' )
					->delete( );
			}
		}
		elseif ( is_array ( $cid ) ) {
			foreach ( $cid as $cid ) {
				$GLOBALS['OBJECT']['file']
					->path( './archives/column/'.$cid.'.html' )
					->delete( );
			}
		}
	}
	
	function _Drop_ColumnCache( )
	{
		raysn_object( 'cache' )->path( 'column.datas.inc' )->_Drop_File( );
		foreach ( $GLOBALS['OBJECT']['cache']->files() as $CacheName ) {
			if ( preg_match( "/^[a-z]+\.option\.inc$/", $CacheName ) ) {
				$GLOBALS['OBJECT']['cache']->path( $CacheName )->_Drop_File( );
			}
		}
	}
