<?php
/*
	file:	/modules/column/edit.php
	modify:	2009/02/03 - 2010/05/18
*/

function Column_edit( &$p )
{
	//1.Check Request
	if ( ! empty ( $p['id'] )
		&& is_numeric( $p['id'] ) )
		$cid = $p['id'];
	else
		raysn_clewbox ( translate( 'column id empty' ) );

	require_once './modules/column/column.inc';
	if ( ! $column = _Get_ColumnById( $cid ) ) {
		raysn_clewbox ( translate( 'column not exist' ) );
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		require_once './modules/template/template.inc';
		$column['description'] = htmlspecialchars( $column['description'] );
		$column['ModuleTypes'] = _Get_ColumnModuleTypes( );

		return $column;
	}
	else
	{
		//1.Check Request
		$ColumnDatas= _Get_ColumnDatas( );

		//.Check pid
		if ( isset ( $p['pid'] )
			&& $p['pid']!= $column['pid'] )
		{
			if ( $p['pid'] && empty ( $ColumnDatas[ $p['pid'] ] ) )
				raysn_clewbox( translate( 'pid error' ) );
			elseif ( $p['pid']== $cid )
				raysn_clewbox ( translate( 'pid is self' ) );
			elseif ( _Check_IsSubColumn( $column['cid'], $p['pid'] ) )
				raysn_clewbox ( translate( 'this is the subcolumn' ) );
			else
				$SqlArray['pid']= $pid = $p['pid'];
		} else {
			$pid = $column['pid'];
		}

		//.Check pass
		if ( isset ( $p['type'] )
			&& $p['type']!= $column['type'] ) {
			$pid= isset ( $SqlArray['pid'] ) ? $SqlArray['pid']: $column['pid'];
			if ( ! empty ( $pid )
				&& $p['type'] != $ColumnDatas[ $pid ]['type'] ) {
				raysn_clewbox ( translate( 'different column type' ) );
			}
			if ( _Check_ColumnSubExist( $column['cid'] ) ) {
				raysn_clewbox ( translate( 'can not modify type' ) );
			}
			if ( ! array_key_exists( $p['type'], _Get_ColumnModuleTypes( ) ) ) {
				raysn_clewbox ( translate( 'type format error' ) );
			}

			empty ( $column['type'] ) && $column['type']= 'article';
			require_once './modules/'. $column['type'] .'/'. $column['type'] .'.inc';
			if ( call_user_func( '_Get_'. $column['type'] .'Count', $column['cid'] ) ) {
				raysn_clewbox ( translate( 'move documents elsewhere' ) );
			}
			$SqlArray['type']= $p['type'];
		}

		require_once './libraries/string.inc';

		//.Check name
		if ( isset ( $p['name'] )
			&& $p['name']!= $column['name'] )
		{
			if ( ! empty ( $p['name'] )
				&& _Check_Strlen( $p['name'], 2, 16 ) )
			{
				if ( $checkcolumn = _Get_ColumnByName( $p['name'] ) ) {
					if ( $checkcolumn['pid']== $pid ) {
						raysn_clewbox ( translate( 'name already exist' ) );
					}
				}

				$SqlArray['name']= trim( $p['name'] );
			}
			else
				raysn_clewbox ( translate( 'name length illegal', array( '@min'=> 2, '@max'=> 16 ) ) );
		}

		//.Check pass
		if ( isset ( $p['pass'] )
			&& $p['pass']!= $column['pass'] )
		{
			if ( in_array( $p['pass'], array( 1, 0 ) ) )
				$SqlArray['pass']= $p['pass'];
			else
				raysn_clewbox ( translate( 'pass format error' ) );
		}

		//.Check Home template
		require_once './modules/template/template.inc';
		if ( isset ( $p['HomeTemplate'] ) ) {
			if ( _Check_TemplateNameExist( $p['HomeTemplate'] ) )
				$SqlArray['HomeTemplate']= $p['HomeTemplate'];
			else
				raysn_clewbox ( translate( 'home template empty' ) );
		}

		//.Check List template
		if ( isset ( $p['ListTemplate'] ) ) {
			if ( _Check_TemplateNameExist( $p['ListTemplate'] ) )
				$SqlArray['ListTemplate']= $p['ListTemplate'];
			else
				raysn_clewbox ( translate( 'list template empty' ) );
		}

		//.Check Text template
		if ( isset ( $p['TextTemplate'] ) ) {
			if ( _Check_TemplateNameExist( $p['TextTemplate'] ) )
				$SqlArray['TextTemplate']= $p['TextTemplate'];
			else
				raysn_clewbox ( translate( 'text template empty' ) );
		}

		//.Check description
		if ( isset ( $p['description'] )
			&& $p['description'] != NULL )
		{
			if ( _Check_Strlen( $p['description'], 0, 65535 ) )
				$SqlArray['description']= trim( $p['description'] );
			else
				raysn_clewbox ( translate( 'description too many', array( '@max'=> 65535 ) ) );
		}
		
		//.Check sort
		if ( isset ( $p['sort'] )
			&& is_numeric( $p['sort'] ) ) {
			$SqlArray['sort']= $p['sort'];
		}

		//2.Insert Data
		$MysqlObject= raysn_object( 'mysql' );
		$MysqlObject->update( 'column', $SqlArray, "`cid`= '$cid'" );

		//.Drop Column Cache
		_Drop_ColumnCache( );
		_Drop_ColumnPages( );

		if ( $GLOBALS['CONFIG']['STATIC_LINK'] == 'opened' && INDEX_PATH != '' ) {
			_Make_ColumnPage( $cid );
		}

		//3.Operation Complete
		variable_set( 'UPDATE_COLUMN_TIMESTAMP', time( ) );
		watchdog( 'modified a column', array( '@column'=> $column['name'], '@cid'=> $cid ) );
		raysn_clewbox ( translate( 'edit column success' ), url( 'column/main/' . $pid ) );
	}
}
