<?php
/*
	file:	/modules/column/make.php
	modify:	2009/02/02 - 2010/05/18
*/

function Column_make( &$p )
{
	//1.Check Request
	require_once './modules/column/column.inc';
	$ColumnDatas= _Get_ColumnDatas( );

	//.Check pid
	if ( ! empty ( $p['id'] )
		&& ! empty ( $ColumnDatas[ $p['id'] ] ) ) {
		$DataArray['pid']= $p['id'];
		$DataArray['type'] = $ColumnDatas[ $p['id'] ]['type'];
	} else {
		$DataArray['pid']= 0;
		$DataArray['type'] = '';
	}

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		require_once './modules/template/template.inc';
		$DataArray['ModuleTypes']= _Get_ColumnModuleTypes( );
		return $DataArray;
	}
	else
	{
		//1.Check Request
		require_once './libraries/string.inc';

		//.Check pid
		if ( empty ( $p['pid'] ) ) 
			$SqlArray['pid']= 0;
		elseif ( ! empty ( $ColumnDatas[ $p['pid'] ] ) )
			$SqlArray['pid']= $p['pid'];
		else
			raysn_clewbox( translate( 'pid error' ) );

		//.Check type
		if ( isset ( $p['type'] )
			&& array_key_exists( $p['type'], _Get_ColumnModuleTypes( ) ) ) {
			if ( ! empty ( $SqlArray['pid'] )
				&& $p['type'] != $ColumnDatas[ $SqlArray['pid'] ]['type'] ) {
				raysn_clewbox ( translate( 'different column type' ) );
			}
			$SqlArray['type']= $p['type'];
		}
		else {
			raysn_clewbox ( translate( 'type format error' ) );
		}

		//.Check name
		if ( isset ( $p['name'] )
			&& _Check_Strlen( $p['name'], 2, 16 ) ) {
			if ( $checkcolumn = _Get_ColumnByName( $p['name'] ) ) {
				if ( $checkcolumn['pid'] == $p['pid'] ) {
					raysn_clewbox ( translate( 'name already exist' ) );
				}
			}
			$SqlArray['name']= trim( $p['name'] );
		}
		else
			raysn_clewbox ( translate( 'name length illegal', array( '@min'=> 2, '@max'=> 16 ) ) );

		//.Check Home template
		require_once './modules/template/template.inc';
		if ( isset ( $p['HomeTemplate'] )
			&& _Check_TemplateNameExist( $p['HomeTemplate'] ) ) {
			$SqlArray['HomeTemplate']= $p['HomeTemplate'];
		} else {
			raysn_clewbox ( translate( 'home template empty' ) );
		}

		//.Check List template
		if ( isset ( $p['ListTemplate'] )
			&& _Check_TemplateNameExist( $p['ListTemplate'] ) ) {
			$SqlArray['ListTemplate']= $p['ListTemplate'];
		} else {
			raysn_clewbox ( translate( 'list template empty' ) );
		}

		//.Check Text template
		if ( isset ( $p['TextTemplate'] )
			&& _Check_TemplateNameExist( $p['TextTemplate'] ) ) {
			$SqlArray['TextTemplate']= $p['TextTemplate'];
		} else {
			raysn_clewbox ( translate( 'text template empty' ) );
		}

		//.Check description
		if ( isset ( $p['description'] )
			&& $p['description'] != NULL )
		{
			if ( _Check_Strlen( $p['description'], 0, 65535 ) )
				$SqlArray['description']= trim( $p['description'] );
			else
				raysn_clewbox( translate( 'description too many', array( '@max'=> 65535 ) ) );
		}
		
		//.Check sort
		if ( isset ( $p['sort'] )
			&& is_numeric( $p['sort'] ) ) {
			$SqlArray['sort']= $p['sort'];
		}

		//.Check pass
		if ( isset ( $p['pass'] )
			&& in_array( $p['pass'], array( 1, 0 ) ) ) {
			$SqlArray['pass']= $p['pass'];
		}
		else {
			raysn_clewbox ( translate( 'pass format error' ) );
		}

		//2.Insert Data
		$MysqlObject= raysn_object( 'mysql' );
		$MysqlObject->insert( 'column', $SqlArray );
		$cid = $MysqlObject->_Get_InsertId( );

		//.Drop Column Cache
		_Drop_ColumnCache( );
		_Drop_ColumnPages( );

		if ( $GLOBALS['CONFIG']['STATIC_LINK'] == 'opened' && INDEX_PATH != '' ) {
			_Make_ColumnPage( $cid );
		}

		//3.Operation Complete
		variable_set( 'UPDATE_COLUMN_TIMESTAMP', time( ) );
		watchdog( 'creating a column', array( '@column'=> $SqlArray['name'], '@cid'=> $cid ) );
		raysn_clewbox ( translate( 'make column success' ), url( 'column/main/' . $DataArray['pid'] ) );
	}
}
