<?php
/*
	file:	/modules/comment/browse.php
	modify:	2010/02/11 - 2010/05/18
*/

function Comment_browse( &$p )
{
	//1.Check Request
	require_once './modules/comment/comment.inc';
	if ( empty ( $p['id'] )
		|| ! $Comment = _Get_CommentData( $p['id'] ) ) {
		return RAYSN_NOT_FOUND;
	}

	require_once './modules/'. $Comment['type'] .'/'. $Comment['type'] .'.inc';
	$CheckResult = call_user_func( '_Check_'. $Comment['type'] .'AllowComments', $Comment['tid'] );
	if ( $CheckResult['comments'] < 1 ) {
		raysn_clewbox ( translate( 'Disallowed Browse' ) );
	}

	//.Check page
	if ( empty ( $p['page'] ) || $p['page'] < 1 ) {
		$NowIndex= 1;
	} else {
		$NowIndex= $p['page'];
	}

	//.Check File
	$filepath = raysn_get_archives_path( "comment", $p["id"] );
	if ( $GLOBALS['CONFIG']['CACHE_PAGE'] == 'closed'
		|| ! is_file ( './archives/' . $filepath )
		|| time( ) - filemtime ( './archives/' . $filepath ) > variable_get( 'COMMENT_UPDATE_INTERVAL', '604800' )
		|| filemtime ( './archives/' . $filepath ) < variable_get( 'COMMENT_UPDATE_TIMESTAMP_'. $p['id'] ) )
	{
		define( 'PAGE_NOWINDEX', $NowIndex );
		$comment = _Get_CommentData( $p['id'] );
		$comment['text'] = htmlspecialchars( $comment['text'] );
		$comment['created'] = date( variable_get( "Comment_CreatedFormat", "Y-m-d H:i:s" ), $comment['created'] );

		if ( ! raysn_object( 'make' )
			->_Set_Var( 'comment', $comment )
			->_Set_Tpl( variable_get( 'Comment_BrowseTemplate', 'comment_browse' ) )
			->_Set_Url( url( "comment/$cid" ) )
			->_Make_File( $filepath ) ) {
			$GLOBALS['OBJECT']['make']->_Run_Template( );
		}
	}

	//.Load File
	return array( 'ViewPath'=> './archives/' . $filepath );
}
