<?php
/*
	file:	/modules/comment/delete.php
	modify:	2010/02/11 - 2010/05/18
*/

function Comment_delete( &$p )
{
	//.Check Request
	if ( ! empty ( $p['id'] )
		&& is_numeric( $p['id'] ) )
		$cid = $p['id'];
	else
		raysn_clewbox ( translate( 'comment id empty' ) );

	//View Form
	if ( empty ( $p['confirm'] ) )
	{
		//.Check cids
		if ( empty ( $p['rids'] )
			|| ! is_array( $p['rids'] ) ) {
			raysn_clewbox ( translate( 'comment id empty' ) );
		}
		$rids= implode( ',', $p['rids'] );
		if ( ! preg_match( "/^\d+(,\d+)*$/", $rids ) ) {
			raysn_clewbox ( translate( 'comment id error' ) );
		}

		if ( ! $Comments= raysn_object( 'mysql' )
			->select( 'comment_reply', array( 'select'=> '`uid`,`text`,`created`', 'where'=> "`rid` IN ( " . $rids . " )" ) ) )
			raysn_clewbox ( translate( 'comment not exist' ), url( 'comment/main' ) );

		require_once './modules/user/user.inc';
		return array( 'cid'=> $cid, 'rids' => $rids, 'Comments' => $Comments );
	}
	else
	{
		//.Check Request
		//Check cids
		if ( empty ( $p['rids'] )
			|| ! preg_match( "/^\d+(,\d+)*$/", $p['rids'] ) )
			raysn_clewbox ( translate( 'comment id error' ) );

		if ( ! $Comments = raysn_object( 'mysql' )
			->select( 'comment_reply', array( 'select'=> '`uid`', 'where'=> "`rid` IN ( " . $p['rids'] . " )" ) ) ) {
			raysn_clewbox ( translate( 'comment not exist' ), url( 'comment/main' ) );
		}

		$GLOBALS['OBJECT']['mysql']->delete( 'comment_reply', "`rid` IN ( " . $p['rids'] . " )" );

		//.Cost Point
		foreach ( $Comments as $comment ) {
			raysn_del_user_points( $comment['uid'], variable_get( 'Comment_PointDel', 2 ) );
		}

		require_once './modules/comment/comment.inc';

		if ( ! $GLOBALS['OBJECT']['mysql']
			->select_count( 'comment_reply', "`cid`= $cid" ) )
		{
			$GLOBALS['OBJECT']['mysql']->delete( 'comment', "`cid`= $cid" );
			_Drop_CommentPage( $cid );
			raysn_clewbox ( translate( 'delete success' ), url( 'comment/main' ) );
		}

		//.Operation Complete
		_Set_CommentMakeMark( $cid );
		raysn_clewbox ( translate( 'delete success' ), url( 'comment/'.$cid.'/list' ) );
	}
}
