<?php
/*
	file:	/modules/comment/publish.php
	modify:	2010/02/11 - 2010/04/19
*/

define( 'COMMENT_INTERVAL_TIME', 3600 );

function Comment_publish( &$p )
{
	//View Form
	if ( empty ( $p['confirm'] ) ) {
		return RAYSN_NOT_FOUND;
	}
	else
	{
		//.Check Request
		if ( empty ( $p['id'] ) || empty ( $p['page'] ) || ! is_numeric( $p['page'] ) ) {
			return RAYSN_NOT_FOUND;
		}

		$ModuleIncFilePath = './modules/'. $p['id'] .'/'. $p['id'] .'.inc';
		$CheckCommentsFunction = '_Check_'. $p['id'] .'AllowComments';

		if ( ! is_file ( $ModuleIncFilePath ) ) {
			raysn_clewbox ( translate( 'comments check not exist' ) );
		}
		require_once $ModuleIncFilePath;
		if ( ! function_exists ( $CheckCommentsFunction ) ) {
			raysn_clewbox ( translate( 'comments check not exist' ) );
		}
		$CheckResult = call_user_func( $CheckCommentsFunction, $p['page'] );
		if ( $CheckResult['comments'] < 2 ) {
			raysn_clewbox ( translate( 'Disallowed Comments this' ) );
		}

		//.
		raysn_start_user_session( );
		if ( isset ( $_SESSION['CommentsMark'][ $p['id'] ][ $p['page'] ] )
			&& $_SESSION['CommentsMark'][ $p['id'] ][ $p['page'] ] > time( ) - COMMENT_INTERVAL_TIME ) {
			raysn_clewbox ( translate( 'Too fast' ) );
		}
		
		//Check Text
		require_once './libraries/string.inc';

		if ( isset ( $p['text'] )
			&& _Check_Strlen( $p['text'], 10, 255 ) )
			$SqlArray['text']= htmlspecialchars( trim( $p['text'] ) );
		else
			raysn_clewbox ( translate( 'text format error' ) );

		//Check Exist
		require_once './modules/comment/comment.inc';
		$SqlArray['created']= time( );
		if ( ! $Comments = _Get_CommentTarget( $p['id'], $p['page'] ) ) {
			$Comments = call_user_func( '_Get_'. $p['id'] .'Data', $p['page'] );
			raysn_object( 'mysql' )
				->insert( 'comment', array(
					'tid'=> $p['page'],
					'type'=> $p['id'],
					'pass'=> 1,
					'title'=> addslashes( $Comments['title'] ),
					'created'=> $SqlArray['created']
				) );
			$Comments['cid'] = $GLOBALS['OBJECT']['mysql']->_Get_InsertId( );
		}

		$SqlArray['cid']= $Comments['cid'];
		$SqlArray['uid']= raysn_get_user_id( );
		$SqlArray['pass']= raysn_check_user_permit( 'comment', 'pass' );

		//.Insert Data
		raysn_object( 'mysql' )->update( 'comment', array( 'replied'=> $SqlArray['created'] ), '`cid`= '. $Comments['cid'] );
		raysn_object( 'mysql' )->insert( 'comment_reply', $SqlArray );

		//.Add Point
		raysn_add_user_points( variable_get( 'Comment_PointAdd', 1 ) );

		$_SESSION['CommentsMark'][ $p['id'] ][ $p['page'] ]= time( );

		//.Operation Complete
		if ( $SqlArray['pass'] ) {
			variable_set( 'COMMENT_UPDATE_TIMESTAMP_'. $Comments['cid'], time( ) );
			variable_set( strtoupper( $p['id'] ). '_UPDATE_TIMESTAMP_'. $p['page'], time( ) );
			raysn_clewbox ( translate( 'publish success' ), url( $p['id'] .'/'. $p['page'] ) );
		}
		else {
			raysn_clewbox ( translate( 'wait for the audit' ) );
		}
	}
}
