<?php
/*
	file:	/modules/data/export.php
	modify:	2009/09/23 - 2010/03/27
*/

function Data_export( &$p )
{
	if ( ! isset ( $p['id'] )
		|| ! raysn_object( 'mysql_table' )->_check_table_exist( $p['id'] ) )
	{
		require_once './libraries/module.inc';
		$TablesTitle = _Get_ModuleTablesTitle( );

		foreach ( raysn_object( 'mysql_table' )->_show_tables( ) as $tablename ) {
			$TableList[ $tablename ] = array (
				'title'=> $TablesTitle[ $tablename ],
				'count'=> $GLOBALS['OBJECT']['mysql_table']->select_count( $tablename ),
				'module'=> preg_replace( "/(_\w+)$/", '', $tablename )
			);
		}

		return array( 'ViewName'=> 'Data_tables', 'TableList'=> $TableList );
	}

	$DataArray['TableName'] = $p['id'];
	if ( empty ( $p['confirm'] ) )
	{
		if ( ! raysn_object ( 'file' )
			->path( './includes/backup/' )->is_dir( ) ) {
			message_set( 'backup dir not exist', array( '@dirpath'=> $GLOBALS['OBJECT']['file']->path( ) ) );
		}

		$DataArray['FileList'] = array( );
		$DataArray['Module'] = preg_replace( "/(_\w+)$/", '', $DataArray['TableName'] );
		$DataArray['TableList'] = $GLOBALS['OBJECT']['mysql_table']->_show_tables( );

		foreach ( $GLOBALS['OBJECT']['file']
			->path( './includes/backup/'. $DataArray['Module'] .'/' )
			->files( ) as $filename ) {
			if ( preg_match( "/^{$DataArray['Module']}(_\w+)?_\d{14}(_\d+)?\.csv$/", $filename ) ) {
				$GLOBALS['OBJECT']['file']->path( './includes/backup/'. $DataArray['Module'] .'/' . $filename );
				$DataArray['FileList'][] = array(
					'name'=> $filename,
					'size'=> $GLOBALS['OBJECT']['file']->size( ),
					'time'=> $GLOBALS['OBJECT']['file']->mtime( )
				);
			}
		}

		return $DataArray;
	}
	else
	{
		if ( ! raysn_object ( 'file' )
			->path( './includes/backup/' )
			->is_dir( ) || ! $GLOBALS['OBJECT']['file']->is_writeable( ) ) {
			raysn_clewbox( translate( 'backup dir not writeable', array( '@dirpath'=> $GLOBALS['OBJECT']['file']->path( ) ) ) );
		}

		if ( isset ( $p['table'] )
			&& raysn_object( 'mysql_table' )->_check_table_exist( $p['table'] ) ) {
			$DataArray['TableName'] = $p['table'];
		}

		//.Select Datas
		if ( ! $Datas= $GLOBALS['OBJECT']['mysql_table']->select( $DataArray['TableName'] ) ) {
			raysn_clewbox ( translate( 'table empty', array( '@table'=> $DataArray['TableName'] ) ) );
		}

		//.Process Datas
		foreach ( end ( $Datas ) as $field => $value ) {
			$Fields[]= $field;
		}
		
		$BackupDirPath = './includes/backup/' . preg_replace( "/(_\w+)$/", '', $DataArray['TableName'] ) . '/';
		if ( ! $GLOBALS['OBJECT']['file']->path( $BackupDirPath )->is_dir( ) ) {
			$GLOBALS['OBJECT']['file']->mkdir( );
		}

		$Fieldsline = '"' . implode( '","', $Fields ) . '"';
		$TableEncode = $BackupDirPath . $p['table'] . '_' . date( 'YmdHis' );
		$EncodeNumber = 1;
		$Datalines = $Fieldsline;
		require_once './libraries/string.inc';
		foreach ( $Datas as $data ) {
			$Datalines.= "\n\"" . implode( '","', _Filter_Quote( $data ) ) . '"';
			if ( strlen( $Datalines ) >= 2000000 ) {
				$GLOBALS['OBJECT']['file']->path( $TableEncode . '_' . ( $EncodeNumber++ ) . '.csv' )->make( $Datalines );
				$Datalines = $Fieldsline;
			}
		}

		if ( strlen( $Datalines ) > strlen( $Fieldsline ) ) {
			if ( $EncodeNumber > 1 ) {
				$TableEncode .= '_' . $EncodeNumber;
			}
			$GLOBALS['OBJECT']['file']->path( $TableEncode . '.csv' )->make( $Datalines );
		}

		watchdog( 'Exporting Data Sheet', array( '@table'=> $DataArray['TableName'] ) );
		raysn_clewbox ( translate( 'export data succeed' ), url( 'data/export/' . $DataArray['TableName'] ) );
	}
}
