<?php
/*
	file:	/modules/download/browse.php
	modify:	2009/02/08 - 2010/05/17
*/

define( 'MAXIMUM_DOWNLOADS', 3 );

function Download_browse( &$p )
{
	//.Check Request
	if ( ! isset ( $p['id'] ) ) {
		return RAYSN_ACCESS_DENIED;
	}

	require_once './modules/download/download.inc';
	if ( is_numeric( $p['id'] ) )
	{
		if ( ! _Check_DownloadPassStatus( $p['id'] ) ) {
			return RAYSN_NOT_FOUND;
		}

		//.Check File
		$filepath = raysn_get_archives_path( "download", $p["id"] );

		if ( $GLOBALS['CONFIG']['CACHE_PAGE'] == 'closed'
			|| ! is_file ( './archives/' . $filepath )
			|| time( ) - filemtime ( './archives/' . $filepath ) > variable_get( 'DOWNLOAD_UPDATE_INTERVAL', '604800' )
			|| filemtime ( './archives/' . $filepath ) < variable_get( 'DOWNLOAD_UPDATE_TIMESTAMP_'. $p['id'] ) )
		{
			if ( ! _Make_DownloadPage( $p['id'] ) ) {
				$GLOBALS['OBJECT']['make']->_Run_Template( );
			}
		}

		//.Load file
		return array( 'ViewPath'=> './archives/' . $filepath );
	}
	else
	{
		if ( empty ( $_POST['confirm'] ) ) {
			return RAYSN_ACCESS_DENIED;
		}
		//Check Download
		if ( ! $Download = _Get_DownloadByCode( $p['id'] ) ) {
			return RAYSN_NOT_FOUND;
		}
		//Check Request
		if ( isset ( $_COOKIE['download_click'][ $p['id'] ] )
			&& ( $_COOKIE['download_click'][ $p['id'] ] > MAXIMUM_DOWNLOADS ) ) {
			raysn_clewbox ( translate( 'Too many downloads' ) );
		}

		//Check Permit
		if ( $Permits = raysn_object( 'mysql' )
			->select( 'download_role', array( 'select'=> '`rid`', 'where'=> "`did`= {$Download['did']}" ) ) )
		{
			if ( ! raysn_check_text_permit( $Permits ) ) {
				raysn_clewbox ( translate( 'No download permission' ) );
			}
			raysn_start_user_session( );
			if ( $Download['cost'] && ! $_SESSION['DownloadCost'][ $p['id'] ] ) {
				if ( ! raysn_cost_user_points( $Download['cost'] ) ) {
					raysn_clewbox ( translate( 'Point not enough', array( '@cost'=> $Download['cost'] ) ) );
				} else {
					$_SESSION['DownloadCost'][ $p['id'] ] = TRUE;
				}
			}
		}

		//Set Cookie
		if ( empty ( $_COOKIE['download_click'][ $p['id'] ] ) ) {
			$GLOBALS['OBJECT']['mysql']->update_count( 'download', array( 'click'=> 1 ), "`code`= '{$p['id']}'" );
			setcookie ( "download_click[{$p['id']}]", 1, time() + 3600 );
		} else {
			setcookie ( "download_click[{$p['id']}]", $_COOKIE['download_click'][ $p['id'] ]+ 1, time() + 3600 );
		}

		return array( 'DownloadUrl'=> $Download['url'] );
	}
}
