<?php
/*
	file:	/modules/download/download.inc
	modify:	2009/08/22 - 2010/05/18
*/

	function _Check_DownloadPassStatus( $did )
	{
		return raysn_object( 'mysql' )
			->select_row( 'download', array( 'select'=> 1, 'where'=> "`did`= '$did' && `pass`= 1 && `pubdate`<= " . time() ) );
	}

	function _Check_DownloadAllowComments( $did )
	{
		return raysn_object( 'mysql' )
			->select_row( 'download', array( 'select'=> '`comments`', 'where'=> "`did`= '$did' && `pass`= 1 && `pubdate`<= " . time() ) );
	}

	function _Check_DownloadUrlExist( $url )
	{
		if ( $Download = raysn_object( 'mysql' )
			->select_row( 'download', array( 'select'=> '`url`', 'where'=> "`url`= '$url'" ) ) ) {
			return $Download['url']== $url;
		}
	}

	function _Get_DownloadByTitle( $title )
	{
		return raysn_object( 'mysql' )
			->select_row( 'download', array( 'select'=> 'cid', 'where'=> "`title`= '$title'" ) );
	}
	
	function _Get_DownloadByCode( $code )
	{
		return raysn_object( 'mysql' )
			->select_row( 'download', array( 'select'=> '`did`,`cost`,`url`', 'where'=> "`code`= '$code'" ) );
	}

	function _Get_DownloadData( $did )
	{
		static $Downloads;
		if ( empty ( $Downloads[ $did ] ) ) {
			$Downloads[ $did ] = raysn_object( 'mysql' )
			->select_row( 'download', array(
				'select'=> '`download`.*,`download_text`.`text`',
				'join'=> array(	'table'=> 'download_text', 'way'=> 'left', 'on'=> 'did' ),
				'where'=> "`download`.`did`= '$did'" )
			);
		}

		return $Downloads[ $did ];
	}

	function _Get_DownloadRoles( $did )
	{
		$DownloadRoles= array( );
		foreach ( raysn_object( 'mysql' )
			->select( 'download_role', array( 'select'=> "`rid`", 'where' => "`did`= '$did'" ) ) as $role )
		{
			$DownloadRoles[]= $role['rid'];
		}
		
		return $DownloadRoles;
	}

	function _Get_DownloadCount( $cid )
	{
		return raysn_object( 'mysql' )
			->select_count( 'download', "`cid`= '$cid'" );
	}
	
	function _Move_DownloadColumn( $cid, $movecid )
	{
		foreach ( raysn_object( 'mysql' )
			->select( 'download', array( 'select'=> '`did`', 'where'=> "`cid`= '$cid'" ) ) as $download ) {
			$Moveaid[] = $download['did'];
		}
		if ( isset ( $Moveaid ) ) {
			return $GLOBALS['OBJECT']['mysql']->update( 'download', array( 'cid'=> $movecid ), "`did` IN( ". implode( ',', $Moveaid ) ." )" );
		} else
			return TRUE;
	}

	function translatePlatform( $Platform )
	{
		if ( empty ( $Platform ) ) {
			return '';
		}

		$PlatForms= translate( 'platform' );
		foreach ( explode( ',', $Platform ) as $platform ) {
			$Platforms[ ] = $PlatForms[ $platform ];
		}
		return implode( ' , ', $Platforms );
	}

	function _Get_DownloadStat( )
	{
		require_once './libraries/string.inc';
		return array(
			'total'=> raysn_object( 'mysql' )->select_count( 'download' ),
			'today'=> $GLOBALS['OBJECT']['mysql']->select_count( 'download', '`pubdate`> '. _Make_TimeStamp( date( 'Y-m-d' ). ' 00:00:00' ) ),
			'yesterday'=> $GLOBALS['OBJECT']['mysql']->select_count( 'download', '`pubdate`< '. _Make_TimeStamp( date( 'Y-m-d' ). ' 00:00:00' ) .' && `pubdate`> '. _Make_TimeStamp( date( 'Y-m-d', time()- 86400 ). ' 00:00:00' ) ),
		);
	}

	function _Make_DownloadPage( $did )
	{
		$download = _Get_DownloadData( $did );
		$download['text'] = preg_replace( "/(<\?|\?>)/", "?", $download['text'] );
		$download['pubdate'] = date( variable_get( "Download_PubdateFormat", "Y-m-d_H:i:s" ), $download['pubdate'] );
		$download['platform']= translatePlatform( $download['platform'] );
		require_once './modules/column/column.inc';
		$column = _Get_ColumnById( $download[ 'cid' ] );

		return raysn_object( 'make' )
			->_Set_Var( 'column', $column )
			->_Set_Var( 'download', $download )
			->_Set_Tpl( $column['TextTemplate'] )
			->_Set_Url( url( "download/$did" ) )
			->_Make_File( raysn_get_archives_path( "download", $did ) );
	}
	
	function _Drop_DownloadPage( $did )
	{
		return raysn_object( 'file' )
			->path( './archives/' . raysn_get_archives_path( "download", $did ) )
			->delete( );
	}
